/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.event.type;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.event.connection.GeyserBedrockPingEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.BedrockPong;

public class GeyserBedrockPingEventImpl
implements GeyserBedrockPingEvent {
    private final InetSocketAddress address;
    private final BedrockPong pong;

    public GeyserBedrockPingEventImpl(BedrockPong pong, InetSocketAddress address) {
        this.address = address;
        this.pong = pong;
    }

    @Override
    public void primaryMotd(@NonNull String primary) {
        this.pong.motd(Objects.requireNonNull(primary, "Primary MOTD cannot be null"));
    }

    @Override
    public void secondaryMotd(@NonNull String secondary) {
        this.pong.subMotd(Objects.requireNonNull(secondary, "Secondary MOTD cannot be null"));
    }

    @Override
    public void playerCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Player count cannot be below 0");
        }
        this.pong.playerCount(count);
    }

    @Override
    public void maxPlayerCount(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max player count cannot be below 1");
        }
        this.pong.maximumPlayerCount(max);
    }

    @Override
    public @Nullable String primaryMotd() {
        return this.pong.motd();
    }

    @Override
    public @Nullable String secondaryMotd() {
        return this.pong.subMotd();
    }

    @Override
    public @NonNegative int playerCount() {
        return this.pong.playerCount();
    }

    @Override
    public int maxPlayerCount() {
        return this.pong.maximumPlayerCount();
    }

    @Override
    public @NonNull InetSocketAddress address() {
        return this.address;
    }
}

