/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.codec;

import io.netty.buffer.ByteBuf;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v897.serializer.TextSerializer_v897;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TextConverter;

public class CustomTextPacketSerializer
extends TextSerializer_v897 {
    public static final CustomTextPacketSerializer INSTANCE = new CustomTextPacketSerializer();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, TextPacket packet) {
        CharSequence message;
        TextPacket.Type type = packet.getType();
        TextConverter converter = helper.getTextConverter();
        Boolean needsTranslation = converter.needsTranslation(message = packet.getMessage(CharSequence.class));
        buffer.writeBoolean(needsTranslation != null ? needsTranslation.booleanValue() : packet.isNeedsTranslation());
        switch (type) {
            case RAW: 
            case TIP: 
            case SYSTEM: {
                buffer.writeByte(0);
                helper.writeString(buffer, "raw");
                helper.writeString(buffer, "tip");
                helper.writeString(buffer, "systemMessage");
                helper.writeString(buffer, "textObjectWhisper");
                helper.writeString(buffer, "textObjectAnnouncement");
                helper.writeString(buffer, "textObject");
                buffer.writeByte(type.ordinal());
                String msg = converter.serialize(message);
                if (msg.isEmpty()) {
                    msg = " ";
                }
                helper.writeString(buffer, msg);
                break;
            }
            case JSON: 
            case WHISPER_JSON: 
            case ANNOUNCEMENT_JSON: {
                buffer.writeByte(0);
                helper.writeString(buffer, "raw");
                helper.writeString(buffer, "tip");
                helper.writeString(buffer, "systemMessage");
                helper.writeString(buffer, "textObjectWhisper");
                helper.writeString(buffer, "textObjectAnnouncement");
                helper.writeString(buffer, "textObject");
                buffer.writeByte(type.ordinal());
                String msg = converter.serializeJson(message);
                if (msg.isEmpty()) {
                    msg = " ";
                }
                helper.writeString(buffer, msg);
                break;
            }
            case CHAT: 
            case WHISPER: 
            case ANNOUNCEMENT: {
                buffer.writeByte(1);
                helper.writeString(buffer, "chat");
                helper.writeString(buffer, "whisper");
                helper.writeString(buffer, "announcement");
                buffer.writeByte(type.ordinal());
                helper.writeString(buffer, packet.getSourceName());
                String msg = converter.serialize(message);
                if (msg.isEmpty()) {
                    msg = " ";
                }
                helper.writeString(buffer, msg);
                break;
            }
            case TRANSLATION: 
            case POPUP: 
            case JUKEBOX_POPUP: {
                buffer.writeByte(2);
                helper.writeString(buffer, "translate");
                helper.writeString(buffer, "popup");
                helper.writeString(buffer, "jukeboxPopup");
                buffer.writeByte(type.ordinal());
                String text = converter.serializeWithArguments(message, packet.getParameters());
                if (text.isEmpty()) {
                    text = " ";
                }
                helper.writeString(buffer, text);
                helper.writeArray(buffer, packet.getParameters(), helper::writeString);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported TextType " + String.valueOf((Object)type));
            }
        }
        helper.writeString(buffer, packet.getXuid());
        helper.writeString(buffer, packet.getPlatformChatId());
        String filtered = converter.serialize(packet.getFilteredMessage(CharSequence.class));
        helper.writeOptional(buffer, s -> !s.isEmpty(), filtered, (buf, codecHelper, s) -> codecHelper.writeString((ByteBuf)buf, (String)s));
    }
}

