/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v291.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandParamOption;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AvailableCommandsPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.SequencedHashSet;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class AvailableCommandsSerializer_v291
implements BedrockPacketSerializer<AvailableCommandsPacket> {
    protected static final InternalLogger log = InternalLoggerFactory.getInstance(AvailableCommandsSerializer_v291.class);
    protected static final CommandPermission[] PERMISSIONS = CommandPermission.values();
    protected static final int ARG_FLAG_VALID = 0x100000;
    protected static final int ARG_FLAG_ENUM = 0x200000;
    protected static final int ARG_FLAG_POSTFIX = 0x1000000;
    protected static final int ARG_FLAG_SOFT_ENUM = 0x4000000;
    protected static final ToIntFunction<ByteBuf> READ_BYTE = ByteBuf::readUnsignedByte;
    protected static final ToIntFunction<ByteBuf> READ_SHORT = ByteBuf::readUnsignedShortLE;
    protected static final ToIntFunction<ByteBuf> READ_INT = ByteBuf::readIntLE;
    protected static final ObjIntConsumer<ByteBuf> WRITE_BYTE = ByteBuf::writeByte;
    protected static final ObjIntConsumer<ByteBuf> WRITE_SHORT = ByteBuf::writeShortLE;
    protected static final ObjIntConsumer<ByteBuf> WRITE_INT = ByteBuf::writeIntLE;
    protected static final CommandData.Flag[] FLAGS = CommandData.Flag.values();
    protected static final CommandParamOption[] OPTIONS = CommandParamOption.values();
    protected final TypeMap<CommandParam> paramTypeMap;

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, AvailableCommandsPacket packet) {
        SequencedHashSet<String> enumValues = new SequencedHashSet<String>();
        SequencedHashSet<String> postFixes = new SequencedHashSet<String>();
        SequencedHashSet<CommandEnumData> enums = new SequencedHashSet<CommandEnumData>();
        SequencedHashSet<CommandEnumData> softEnums = new SequencedHashSet<CommandEnumData>();
        for (CommandData data : packet.getCommands()) {
            if (data.getAliases() != null) {
                enumValues.addAll(data.getAliases().getValues().keySet());
                enums.add(data.getAliases());
            }
            for (CommandOverloadData overload : data.getOverloads()) {
                for (CommandParamData parameter : overload.getOverloads()) {
                    String postfix;
                    CommandEnumData commandEnumData = parameter.getEnumData();
                    if (commandEnumData != null) {
                        if (commandEnumData.isSoft()) {
                            softEnums.add(commandEnumData);
                        } else {
                            enumValues.addAll(commandEnumData.getValues().keySet());
                            enums.add(commandEnumData);
                        }
                    }
                    if ((postfix = parameter.getPostfix()) == null) continue;
                    postFixes.add(postfix);
                }
            }
        }
        helper.writeArray(buffer, enumValues, helper::writeString);
        helper.writeArray(buffer, postFixes, helper::writeString);
        this.writeEnums(buffer, helper, enumValues, enums);
        helper.writeArray(buffer, packet.getCommands(), (buf, command) -> this.writeCommand(buffer, helper, (CommandData)command, (List<CommandEnumData>)enums, (List<CommandEnumData>)softEnums, (List<String>)postFixes));
        helper.writeArray(buffer, softEnums, helper::writeCommandEnum);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, AvailableCommandsPacket packet) {
        SequencedHashSet<String> enumValues = new SequencedHashSet<String>();
        SequencedHashSet postFixes = new SequencedHashSet();
        SequencedHashSet<CommandEnumData> enums = new SequencedHashSet<CommandEnumData>();
        SequencedHashSet softEnums = new SequencedHashSet();
        HashSet softEnumParameters = new HashSet();
        helper.readArray(buffer, enumValues, helper::readString);
        helper.readArray(buffer, postFixes, helper::readString);
        this.readEnums(buffer, helper, enumValues, enums);
        helper.readArray(buffer, packet.getCommands(), (buf, aHelper) -> this.readCommand((ByteBuf)buf, (BedrockCodecHelper)aHelper, (List<CommandEnumData>)enums, postFixes, softEnumParameters));
        helper.readArray(buffer, softEnums, buf -> helper.readCommandEnum(buffer, true));
        softEnumParameters.forEach(consumer -> consumer.accept(softEnums));
    }

    protected void writeEnums(ByteBuf buffer, BedrockCodecHelper helper, List<String> values, List<CommandEnumData> enums) {
        int valuesSize = values.size();
        ObjIntConsumer<ByteBuf> indexWriter = valuesSize <= 256 ? WRITE_BYTE : (valuesSize <= 65536 ? WRITE_SHORT : WRITE_INT);
        helper.writeArray(buffer, enums, (buf, commandEnum) -> {
            helper.writeString((ByteBuf)buf, commandEnum.getName());
            VarInts.writeUnsignedInt(buffer, commandEnum.getValues().size());
            for (String value : commandEnum.getValues().keySet()) {
                int index = values.indexOf(value);
                Preconditions.checkArgument(index > -1, "Invalid enum value detected: " + value);
                indexWriter.accept((ByteBuf)buf, index);
            }
        });
    }

    protected void readEnums(ByteBuf buffer, BedrockCodecHelper helper, List<String> values, List<CommandEnumData> enums) {
        int valuesSize = values.size();
        ToIntFunction<ByteBuf> indexReader = valuesSize <= 256 ? READ_BYTE : (valuesSize <= 65536 ? READ_SHORT : READ_INT);
        helper.readArray(buffer, enums, buf -> {
            String name = helper.readString((ByteBuf)buf);
            int length = VarInts.readUnsignedInt(buffer);
            LinkedHashMap<String, Set<CommandEnumConstraint>> enumValues = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
            for (int i = 0; i < length; ++i) {
                enumValues.put((String)values.get(indexReader.applyAsInt((ByteBuf)buf)), (Set<CommandEnumConstraint>)EnumSet.noneOf(CommandEnumConstraint.class));
            }
            return new CommandEnumData(name, enumValues, false);
        });
    }

    protected void writeCommand(ByteBuf buffer, BedrockCodecHelper helper, CommandData commandData, List<CommandEnumData> enums, List<CommandEnumData> softEnums, List<String> postFixes) {
        helper.writeString(buffer, commandData.getName());
        helper.writeString(buffer, commandData.getDescription());
        this.writeFlags(buffer, commandData.getFlags());
        CommandPermission permission = commandData.getPermission() == null ? CommandPermission.ANY : commandData.getPermission();
        buffer.writeByte(permission.ordinal());
        CommandEnumData aliases = commandData.getAliases();
        buffer.writeIntLE(aliases == null ? -1 : enums.indexOf(aliases));
        CommandOverloadData[] overloads = commandData.getOverloads();
        VarInts.writeUnsignedInt(buffer, overloads.length);
        for (CommandOverloadData overload : overloads) {
            VarInts.writeUnsignedInt(buffer, overload.getOverloads().length);
            for (CommandParamData param : overload.getOverloads()) {
                this.writeParameter(buffer, helper, param, enums, softEnums, postFixes);
            }
        }
    }

    protected CommandData readCommand(ByteBuf buffer, BedrockCodecHelper helper, List<CommandEnumData> enums, List<String> postfixes, Set<Consumer<List<CommandEnumData>>> softEnumParameters) {
        String name = helper.readString(buffer);
        String description = helper.readString(buffer);
        Set<CommandData.Flag> flags = this.readFlags(buffer);
        CommandPermission permissions = PERMISSIONS[buffer.readUnsignedByte()];
        int aliasIndex = buffer.readIntLE();
        CommandEnumData aliases = aliasIndex == -1 ? null : enums.get(aliasIndex);
        CommandOverloadData[] overloads = new CommandOverloadData[VarInts.readUnsignedInt(buffer)];
        for (int i = 0; i < overloads.length; ++i) {
            overloads[i] = new CommandOverloadData(false, new CommandParamData[VarInts.readUnsignedInt(buffer)]);
            for (int i2 = 0; i2 < overloads[i].getOverloads().length; ++i2) {
                overloads[i].getOverloads()[i2] = this.readParameter(buffer, helper, enums, postfixes, softEnumParameters);
            }
        }
        return new CommandData(name, description, flags, permissions, aliases, Collections.emptyList(), overloads);
    }

    protected void writeFlags(ByteBuf buffer, Set<CommandData.Flag> flags) {
        int flagBits = 0;
        for (CommandData.Flag flag : flags) {
            flagBits |= 1 << flag.ordinal();
        }
        buffer.writeByte(flagBits);
    }

    protected Set<CommandData.Flag> readFlags(ByteBuf buffer) {
        int flagBits = buffer.readUnsignedByte();
        EnumSet<CommandData.Flag> flags = EnumSet.noneOf(CommandData.Flag.class);
        for (CommandData.Flag flag : CommandData.Flag.values()) {
            if ((flagBits & 1 << flag.ordinal()) != 0) {
                flags.add(flag);
            }
            flagBits |= 1 << flag.ordinal();
        }
        return flags;
    }

    protected void writeParameter(ByteBuf buffer, BedrockCodecHelper helper, CommandParamData param, List<CommandEnumData> enums, List<CommandEnumData> softEnums, List<String> postfixes) {
        int symbol;
        helper.writeString(buffer, param.getName());
        if (param.getPostfix() != null) {
            symbol = postfixes.indexOf(param.getPostfix()) | 0x1000000;
        } else if (param.getEnumData() != null) {
            symbol = param.getEnumData().isSoft() ? softEnums.indexOf(param.getEnumData()) | 0x4000000 | 0x100000 : enums.indexOf(param.getEnumData()) | 0x200000 | 0x100000;
        } else if (param.getType() != null) {
            symbol = this.paramTypeMap.getId(param.getType()) | 0x100000;
        } else {
            throw new IllegalStateException("No param type specified: " + param);
        }
        buffer.writeIntLE(symbol);
        buffer.writeBoolean(param.isOptional());
    }

    protected CommandParamData readParameter(ByteBuf buffer, BedrockCodecHelper helper, List<CommandEnumData> enums, List<String> postfixes, Set<Consumer<List<CommandEnumData>>> softEnumParameters) {
        CommandParamData param = new CommandParamData();
        param.setName(helper.readString(buffer));
        int symbol = buffer.readIntLE();
        if ((symbol & 0x1000000) != 0) {
            param.setPostfix(postfixes.get(symbol & 0xFEFFFFFF));
        } else if ((symbol & 0x100000) != 0) {
            if ((symbol & 0x4000000) != 0) {
                softEnumParameters.add(softEnums -> param.setEnumData((CommandEnumData)softEnums.get(symbol & 0xFBEFFFFF)));
            } else if ((symbol & 0x200000) != 0) {
                param.setEnumData(enums.get(symbol & 0xFFCFFFFF));
            } else {
                int parameterTypeId = symbol & 0xFFEFFFFF;
                CommandParam type = this.paramTypeMap.getTypeUnsafe(parameterTypeId);
                if (type == null) {
                    throw new IllegalStateException("Invalid parameter type: " + parameterTypeId + ", Symbol: " + symbol);
                }
                param.setType(type);
            }
        } else {
            throw new IllegalStateException("No param type specified: " + param.getName());
        }
        param.setOptional(buffer.readBoolean());
        return param;
    }

    public AvailableCommandsSerializer_v291(TypeMap<CommandParam> paramTypeMap) {
        this.paramTypeMap = paramTypeMap;
    }
}

