/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v897.serializer;

import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v685.serializer.EventSerializer_v685;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.event.EventData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.event.EventDataType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.EventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TriConsumer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class EventSerializer_v897
extends EventSerializer_v685 {
    public static final EventSerializer_v897 INSTANCE = new EventSerializer_v897();

    public EventSerializer_v897() {
        this.readers.put(EventDataType.SLASH_COMMAND_EXECUTED, this::readSlashCommandExecuted);
        this.writers.put(EventDataType.SLASH_COMMAND_EXECUTED, this::writeSlashCommandExecuted);
    }

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, EventPacket packet) {
        VarInts.writeLong(buffer, packet.getUniqueEntityId());
        EventData eventData = packet.getEventData();
        VarInts.writeInt(buffer, eventData.getType().ordinal());
        buffer.writeBoolean(packet.isUsePlayerId());
        TriConsumer function = (TriConsumer)this.writers.get((Object)eventData.getType());
        if (function == null) {
            throw new UnsupportedOperationException("Unknown event type " + (Object)((Object)eventData.getType()));
        }
        VarInts.writeUnsignedInt(buffer, eventData.getType().ordinal());
        function.accept(buffer, helper, eventData);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, EventPacket packet) {
        packet.setUniqueEntityId(VarInts.readLong(buffer));
        int eventId = VarInts.readInt(buffer);
        Preconditions.checkElementIndex(eventId, VALUES.length, "EventDataType");
        EventDataType type = VALUES[eventId];
        packet.setUsePlayerId(buffer.readBoolean());
        VarInts.readUnsignedInt(buffer);
        BiFunction function = (BiFunction)this.readers.get((Object)type);
        if (function == null) {
            throw new UnsupportedOperationException("Unknown event type " + (Object)((Object)type));
        }
        packet.setEventData((EventData)function.apply(buffer, helper));
    }
}

