/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectPool;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.util.PacketFlag;

public class BedrockPacketWrapper
extends AbstractReferenceCounted {
    private static final ObjectPool<BedrockPacketWrapper> RECYCLER = ObjectPool.newPool(BedrockPacketWrapper::new);
    private final ObjectPool.Handle<BedrockPacketWrapper> handle;
    private int packetId;
    private int senderSubClientId;
    private int targetSubClientId;
    private int headerLength;
    private BedrockPacket packet;
    private ByteBuf packetBuffer;
    private Set<PacketFlag> flags = new ObjectOpenHashSet();

    public static BedrockPacketWrapper create(int packetId, int senderSubClientId, int targetSubClientId, BedrockPacket packet, ByteBuf packetBuffer) {
        BedrockPacketWrapper wrapper = (BedrockPacketWrapper)((Object)RECYCLER.get());
        if (wrapper.packet != null || wrapper.packetBuffer != null) {
            throw new IllegalStateException("BedrockPacketWrapper was not deallocated");
        }
        wrapper.packetId = packetId;
        wrapper.senderSubClientId = senderSubClientId;
        wrapper.targetSubClientId = targetSubClientId;
        wrapper.packet = packet;
        wrapper.packetBuffer = packetBuffer;
        wrapper.setRefCnt(1);
        return wrapper;
    }

    public static BedrockPacketWrapper create() {
        BedrockPacketWrapper wrapper = (BedrockPacketWrapper)((Object)RECYCLER.get());
        if (wrapper.packet != null || wrapper.packetBuffer != null) {
            throw new IllegalStateException("BedrockPacketWrapper was not deallocated");
        }
        wrapper.setRefCnt(1);
        return wrapper;
    }

    private BedrockPacketWrapper(ObjectPool.Handle<BedrockPacketWrapper> handle) {
        this.handle = handle;
    }

    public void setFlag(PacketFlag flag) {
        this.flags.add(flag);
    }

    public boolean hasFlag(PacketFlag flag) {
        return this.flags.contains(flag);
    }

    public void unsetFlag(PacketFlag flag) {
        this.flags.remove(flag);
    }

    protected void deallocate() {
        ReferenceCountUtil.safeRelease((Object)this.packet);
        ReferenceCountUtil.safeRelease((Object)this.packetBuffer);
        this.packetId = 0;
        this.senderSubClientId = 0;
        this.targetSubClientId = 0;
        this.headerLength = 0;
        this.packet = null;
        this.packetBuffer = null;
        this.flags.clear();
        this.handle.recycle((Object)this);
    }

    public BedrockPacketWrapper touch(Object hint) {
        ReferenceCountUtil.touch((Object)this.packet);
        ReferenceCountUtil.touch((Object)this.packetBuffer);
        return this;
    }

    public BedrockPacketWrapper retain() {
        return (BedrockPacketWrapper)super.retain();
    }

    public ObjectPool.Handle<BedrockPacketWrapper> getHandle() {
        return this.handle;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public int getSenderSubClientId() {
        return this.senderSubClientId;
    }

    public int getTargetSubClientId() {
        return this.targetSubClientId;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public BedrockPacket getPacket() {
        return this.packet;
    }

    public ByteBuf getPacketBuffer() {
        return this.packetBuffer;
    }

    public Set<PacketFlag> getFlags() {
        return this.flags;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public void setSenderSubClientId(int senderSubClientId) {
        this.senderSubClientId = senderSubClientId;
    }

    public void setTargetSubClientId(int targetSubClientId) {
        this.targetSubClientId = targetSubClientId;
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public void setPacket(BedrockPacket packet) {
        this.packet = packet;
    }

    public void setPacketBuffer(ByteBuf packetBuffer) {
        this.packetBuffer = packetBuffer;
    }

    public void setFlags(Set<PacketFlag> flags) {
        this.flags = flags;
    }

    public String toString() {
        return "BedrockPacketWrapper(handle=" + this.getHandle() + ", packetId=" + this.getPacketId() + ", senderSubClientId=" + this.getSenderSubClientId() + ", targetSubClientId=" + this.getTargetSubClientId() + ", headerLength=" + this.getHeaderLength() + ", packet=" + this.getPacket() + ", packetBuffer=" + this.getPacketBuffer() + ", flags=" + this.getFlags() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BedrockPacketWrapper)) {
            return false;
        }
        BedrockPacketWrapper other = (BedrockPacketWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPacketId() != other.getPacketId()) {
            return false;
        }
        if (this.getSenderSubClientId() != other.getSenderSubClientId()) {
            return false;
        }
        if (this.getTargetSubClientId() != other.getTargetSubClientId()) {
            return false;
        }
        if (this.getHeaderLength() != other.getHeaderLength()) {
            return false;
        }
        ObjectPool.Handle<BedrockPacketWrapper> this$handle = this.getHandle();
        ObjectPool.Handle<BedrockPacketWrapper> other$handle = other.getHandle();
        if (this$handle == null ? other$handle != null : !this$handle.equals(other$handle)) {
            return false;
        }
        BedrockPacket this$packet = this.getPacket();
        BedrockPacket other$packet = other.getPacket();
        if (this$packet == null ? other$packet != null : !this$packet.equals(other$packet)) {
            return false;
        }
        ByteBuf this$packetBuffer = this.getPacketBuffer();
        ByteBuf other$packetBuffer = other.getPacketBuffer();
        if (this$packetBuffer == null ? other$packetBuffer != null : !this$packetBuffer.equals(other$packetBuffer)) {
            return false;
        }
        Set<PacketFlag> this$flags = this.getFlags();
        Set<PacketFlag> other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BedrockPacketWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPacketId();
        result = result * 59 + this.getSenderSubClientId();
        result = result * 59 + this.getTargetSubClientId();
        result = result * 59 + this.getHeaderLength();
        ObjectPool.Handle<BedrockPacketWrapper> $handle = this.getHandle();
        result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
        BedrockPacket $packet = this.getPacket();
        result = result * 59 + ($packet == null ? 43 : $packet.hashCode());
        ByteBuf $packetBuffer = this.getPacketBuffer();
        result = result * 59 + ($packetBuffer == null ? 43 : $packetBuffer.hashCode());
        Set<PacketFlag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        return result;
    }
}

