/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.spongepowered.configurate.loader;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.shaded.org.spongepowered.configurate.loader.LoaderOptionSource;

final class LoaderOptionSources {
    static final LoaderOptionSource ENVIRONMENT = new EnvironmentVariables("CONFIGURATE");
    static final LoaderOptionSource SYSTEM_PROPERTIES = new SystemProperties("configurate");

    private LoaderOptionSources() {
    }

    static final class Composite
    implements LoaderOptionSource {
        private final LoaderOptionSource[] sources;

        Composite(LoaderOptionSource[] sources) {
            this.sources = sources;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            for (LoaderOptionSource source : this.sources) {
                String result = source.get(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    static final class Node
    implements LoaderOptionSource {
        private final ConfigurationNode source;

        Node(ConfigurationNode source) {
            this.source = source;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            return this.source.node(path).getString();
        }
    }

    static final class SystemProperties
    implements LoaderOptionSource {
        private static final char SYSTEM_PROPERTY_SEPARATOR = '.';
        private final String prefix;

        SystemProperties(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            StringBuilder varName = new StringBuilder(this.prefix);
            for (String element : path) {
                varName.append('.').append(element);
            }
            return System.getProperty(varName.toString());
        }
    }

    static final class EnvironmentVariables
    implements LoaderOptionSource {
        private static final char ENVIORNMENT_VAR_SEPARATOR = '_';
        private final String prefix;

        EnvironmentVariables(String prefix) {
            this.prefix = prefix.toUpperCase(Locale.ROOT);
        }

        @Override
        public @Nullable String get(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("A provided path must have at least one element");
            }
            StringBuilder varName = new StringBuilder(this.prefix);
            for (String element : path) {
                varName.append('_').append(element.toUpperCase(Locale.ROOT));
            }
            return System.getenv(varName.toString());
        }
    }
}

