/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.PistonBlock;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValueType;

public class PistonBlockEntity {
    private final GeyserSession session;
    private final Vector3i position;
    private final Direction orientation;
    private final boolean sticky;
    private PistonValueType action;
    private final Object2ObjectMap<Vector3i, BlockState> attachedBlocks = new Object2ObjectOpenHashMap();
    private int[] flattenedAttachedBlocks = IntArrays.EMPTY_ARRAY;
    private boolean placedFinalBlocks = true;
    private float progress;
    private float lastProgress;
    private long timeSinceCompletion = 0L;
    private static final BoundingBox SOLID_BOUNDING_BOX = new BoundingBox(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    private static final BoundingBox HONEY_BOUNDING_BOX;
    private static final int REMOVAL_DELAY = 5;

    public PistonBlockEntity(GeyserSession session, Vector3i position, Direction orientation, boolean sticky, boolean extended) {
        this.session = session;
        this.position = position;
        this.orientation = orientation;
        this.sticky = sticky;
        if (extended) {
            this.action = PistonValueType.PUSHING;
            this.progress = 1.0f;
        } else {
            this.action = PistonValueType.PULLING;
            this.progress = 0.0f;
        }
        this.lastProgress = this.progress;
    }

    public void setAction(PistonValueType action) {
        if (this.action == action) {
            return;
        }
        this.placeFinalBlocks();
        this.removeMovingBlocks();
        this.action = action;
        if (action == PistonValueType.PUSHING || action == PistonValueType.PULLING && this.sticky) {
            this.findAffectedBlocks();
            this.removeBlocks();
            this.createMovingBlocks();
        } else {
            this.removePistonHead();
        }
        this.placedFinalBlocks = false;
        switch (action) {
            case PUSHING: {
                this.progress = 0.0f;
                break;
            }
            case PULLING: 
            case CANCELLED_MID_PUSH: {
                this.progress = 1.0f;
            }
        }
        this.lastProgress = this.progress;
        BlockEntityUtils.updateBlockEntity(this.session, this.buildPistonTag(), this.position);
    }

    public void setAction(PistonValueType action, Map<Vector3i, BlockState> attachedBlocks) {
        this.placeFinalBlocks();
        this.removeMovingBlocks();
        this.action = action;
        if (action == PistonValueType.PUSHING || action == PistonValueType.PULLING && this.sticky) {
            if (attachedBlocks.size() <= 12) {
                this.attachedBlocks.putAll(attachedBlocks);
                this.flattenPositions();
            }
            this.removeBlocks();
            this.createMovingBlocks();
        } else {
            this.removePistonHead();
        }
        this.placedFinalBlocks = false;
        switch (action) {
            case PUSHING: {
                this.progress = 0.0f;
                break;
            }
            case PULLING: 
            case CANCELLED_MID_PUSH: {
                this.progress = 1.0f;
            }
        }
        this.lastProgress = this.progress;
        BlockEntityUtils.updateBlockEntity(this.session, this.buildPistonTag(), this.position);
    }

    public void updateMovement() {
        if (this.isDone()) {
            ++this.timeSinceCompletion;
            return;
        }
        this.timeSinceCompletion = 0L;
        this.updateProgress();
        this.pushPlayer();
        BlockEntityUtils.updateBlockEntity(this.session, this.buildPistonTag(), this.position);
    }

    public void updateBlocks() {
        if (this.isDone()) {
            if (this.timeSinceCompletion == 0L) {
                this.placeFinalBlocks();
            }
            if (this.timeSinceCompletion >= 5L) {
                this.removeMovingBlocks();
            }
        }
    }

    private void removePistonHead() {
        Vector3i blockInFront = this.position.add(this.orientation.getUnitVector());
        BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, blockInFront);
        if (state.is(Blocks.PISTON_HEAD)) {
            ChunkUtils.updateBlock(this.session, 0, blockInFront);
        } else if ((this.session.getGeyser().getWorldManager().hasOwnChunkCache() || this.session.getErosionHandler().isActive()) && state.is(Blocks.AIR)) {
            ChunkUtils.updateBlock(this.session, 0, blockInFront);
        }
    }

    private void findAffectedBlocks() {
        ObjectOpenHashSet blocksChecked = new ObjectOpenHashSet();
        LinkedList<Vector3i> blocksToCheck = new LinkedList<Vector3i>();
        Vector3i directionOffset = this.orientation.getUnitVector();
        Vector3i movement = this.getMovement();
        blocksChecked.add(this.position);
        if (this.action == PistonValueType.PULLING) {
            blocksChecked.add(this.getPistonHeadPos());
            blocksToCheck.add(this.position.add(directionOffset.mul(2)));
        } else if (this.action == PistonValueType.PUSHING) {
            this.removePistonHead();
            blocksToCheck.add(this.position.add(directionOffset));
        }
        boolean moveBlocks = true;
        while (!blocksToCheck.isEmpty() && this.attachedBlocks.size() <= 12) {
            BlockState state;
            Vector3i blockPos = (Vector3i)blocksToCheck.remove();
            if (!blocksChecked.add(blockPos) || (state = this.session.getGeyser().getWorldManager().blockAt(this.session, blockPos)).block() == Blocks.AIR) continue;
            if (BlockStateValues.canPistonMoveBlock(state, this.action == PistonValueType.PUSHING)) {
                this.attachedBlocks.put((Object)blockPos, (Object)state);
                if (BlockStateValues.isBlockSticky(state)) {
                    for (Direction direction : Direction.VALUES) {
                        BlockState adjacentBlockState;
                        Vector3i adjacentPos;
                        Vector3i offset = direction.getUnitVector();
                        if (offset.equals(movement) || (adjacentPos = blockPos.add(offset)).equals(this.position) || this.action == PistonValueType.PULLING && this.position.add(directionOffset).equals(adjacentPos) || (adjacentBlockState = this.session.getGeyser().getWorldManager().blockAt(this.session, adjacentPos)).block() == Blocks.AIR || !BlockStateValues.isBlockAttached(state, adjacentBlockState) || !BlockStateValues.canPistonMoveBlock(adjacentBlockState, false)) continue;
                        if (BlockStateValues.isBlockSticky(adjacentBlockState)) {
                            blocksToCheck.add(adjacentPos);
                            continue;
                        }
                        this.attachedBlocks.put((Object)adjacentPos, (Object)adjacentBlockState);
                        blocksChecked.add(adjacentPos);
                        blocksToCheck.add(adjacentPos.add(movement));
                    }
                }
                blocksToCheck.add(blockPos.add(movement));
                continue;
            }
            if (BlockStateValues.canPistonDestroyBlock(state)) continue;
            moveBlocks = false;
            break;
        }
        if (!moveBlocks || this.attachedBlocks.size() > 12) {
            this.attachedBlocks.clear();
        } else {
            this.flattenPositions();
        }
    }

    private Vector3i getMovement() {
        if (this.action == PistonValueType.PULLING) {
            return this.orientation.reversed().getUnitVector();
        }
        return this.orientation.getUnitVector();
    }

    private void removeBlocks() {
        for (Vector3i blockPos : this.attachedBlocks.keySet()) {
            ChunkUtils.updateBlock(this.session, 0, blockPos);
        }
        if (this.action != PistonValueType.PUSHING) {
            this.removePistonHead();
        }
    }

    public void pushPlayer() {
        Vector3d blockPos;
        BlockState state;
        BoundingBox playerBoundingBox;
        boolean onGround;
        ClientVehicle clientVehicle;
        Entity entity;
        Vector3i direction = this.orientation.getUnitVector();
        double blockMovement = this.lastProgress;
        if (this.action == PistonValueType.PULLING || this.action == PistonValueType.CANCELLED_MID_PUSH) {
            blockMovement = 1.0f - this.lastProgress;
        }
        if ((entity = this.session.getPlayerEntity().getVehicle()) instanceof ClientVehicle && (clientVehicle = (ClientVehicle)((Object)entity)).isClientControlled()) {
            onGround = this.session.getPlayerEntity().getVehicle().isOnGround();
            playerBoundingBox = clientVehicle.getVehicleComponent().getBoundingBox();
        } else {
            onGround = this.session.getPlayerEntity().isOnGround();
            playerBoundingBox = this.session.getCollisionManager().getPlayerBoundingBox();
        }
        Vector3d shrink = Vector3i.ONE.sub(direction.abs()).toDouble().mul(2.0E-5);
        double sizeX = playerBoundingBox.getSizeX();
        double sizeY = playerBoundingBox.getSizeY();
        double sizeZ = playerBoundingBox.getSizeZ();
        playerBoundingBox.setSizeX(sizeX - shrink.getX());
        playerBoundingBox.setSizeY(sizeY - shrink.getY());
        playerBoundingBox.setSizeZ(sizeZ - shrink.getZ());
        BlockState pistonHeadId = Blocks.PISTON_HEAD.defaultBlockState().withValue(Properties.SHORT, false).withValue(Properties.FACING, this.orientation);
        this.pushPlayerBlock(pistonHeadId, this.getPistonHeadPos().toDouble(), blockMovement, playerBoundingBox, onGround);
        for (Map.Entry entry : Object2ObjectMaps.fastIterable(this.attachedBlocks)) {
            state = (BlockState)entry.getValue();
            if (state.is(Blocks.SLIME_BLOCK)) continue;
            blockPos = ((Vector3i)entry.getKey()).toDouble();
            this.pushPlayerBlock(state, blockPos, blockMovement, playerBoundingBox, onGround);
        }
        for (Map.Entry entry : Object2ObjectMaps.fastIterable(this.attachedBlocks)) {
            state = (BlockState)entry.getValue();
            if (!state.is(Blocks.SLIME_BLOCK)) continue;
            blockPos = ((Vector3i)entry.getKey()).toDouble();
            this.pushPlayerBlock(state, blockPos, blockMovement, playerBoundingBox, onGround);
        }
        playerBoundingBox.setSizeX(sizeX);
        playerBoundingBox.setSizeY(sizeY);
        playerBoundingBox.setSizeZ(sizeZ);
    }

    private boolean isPlayerAttached(Vector3d blockPos, BoundingBox playerBoundingBox, boolean onGround) {
        if (this.orientation.isVertical()) {
            return false;
        }
        return onGround && HONEY_BOUNDING_BOX.checkIntersection(blockPos, playerBoundingBox);
    }

    private void applySlimeBlockMotion(Vector3d blockPos, BoundingBox playerBoundingBox) {
        Vector3d playerPos = Vector3d.from((double)playerBoundingBox.getMiddleX(), (double)playerBoundingBox.getMiddleY(), (double)playerBoundingBox.getMiddleZ());
        Direction movementDirection = this.orientation;
        if (this.action == PistonValueType.PULLING) {
            movementDirection = movementDirection.reversed();
        }
        Vector3f movement = this.getMovement().toFloat();
        Vector3f motion = this.session.getPistonCache().getPlayerMotion();
        double motionX = motion.getX();
        double motionY = motion.getY();
        double motionZ = motion.getZ();
        blockPos = blockPos.add(0.5, 0.5, 0.5);
        switch (movementDirection) {
            case DOWN: {
                if (!(playerPos.getY() < blockPos.getY())) break;
                motionY = movement.getY();
                break;
            }
            case UP: {
                if (!(playerPos.getY() > blockPos.getY())) break;
                motionY = movement.getY();
                break;
            }
            case NORTH: {
                if (!(playerPos.getZ() < blockPos.getZ())) break;
                motionZ = movement.getZ();
                break;
            }
            case SOUTH: {
                if (!(playerPos.getZ() > blockPos.getZ())) break;
                motionZ = movement.getZ();
                break;
            }
            case WEST: {
                if (!(playerPos.getX() < blockPos.getX())) break;
                motionX = movement.getX();
                break;
            }
            case EAST: {
                if (!(playerPos.getX() > blockPos.getX())) break;
                motionX = movement.getX();
            }
        }
        this.session.getPistonCache().setPlayerMotion(Vector3f.from((double)motionX, (double)motionY, (double)motionZ));
    }

    private double getBlockIntersection(BlockCollision blockCollision, Vector3d blockPos, Vector3d extend, BoundingBox boundingBox, Direction direction) {
        Direction oppositeDirection = direction.reversed();
        double maxIntersection = 0.0;
        for (BoundingBox b : blockCollision.getBoundingBoxes()) {
            double oppositeIntersection;
            double intersection;
            b = b.clone();
            b.extend(extend);
            b.translate(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (!b.checkIntersection(Vector3d.ZERO, boundingBox) || !((intersection = boundingBox.getIntersectionSize(b, direction)) < (oppositeIntersection = boundingBox.getIntersectionSize(b, oppositeDirection)))) continue;
            maxIntersection = Math.max(intersection, maxIntersection);
        }
        return maxIntersection;
    }

    private void pushPlayerBlock(BlockState state, Vector3d startingPos, double blockMovement, BoundingBox playerBoundingBox, boolean onGround) {
        PistonCache pistonCache = this.session.getPistonCache();
        Vector3d movement = this.getMovement().toDouble();
        Vector3d finalBlockPos = startingPos.add(movement);
        if (SOLID_BOUNDING_BOX.checkIntersection(finalBlockPos, playerBoundingBox)) {
            pistonCache.setPlayerCollided(true);
            if (state.is(Blocks.SLIME_BLOCK)) {
                pistonCache.setPlayerSlimeCollision(true);
                this.applySlimeBlockMotion(finalBlockPos, playerBoundingBox);
            }
        }
        Vector3d blockPos = startingPos.add(movement.mul(blockMovement));
        if (state.is(Blocks.HONEY_BLOCK) && this.isPlayerAttached(blockPos, playerBoundingBox, onGround)) {
            pistonCache.setPlayerCollided(true);
            pistonCache.setPlayerAttachedToHoney(true);
            double delta = Math.abs(this.progress - this.lastProgress);
            pistonCache.displacePlayer(movement.mul(delta));
        } else {
            BlockCollision blockCollision = BlockRegistries.COLLISIONS.get(state.javaId());
            if (blockCollision != null) {
                double intersection;
                Vector3d extend = movement.mul(Math.min(1.0 - blockMovement, 0.5));
                Direction movementDirection = this.orientation;
                if (this.action == PistonValueType.PULLING) {
                    movementDirection = this.orientation.reversed();
                }
                if ((intersection = this.getBlockIntersection(blockCollision, blockPos, extend, playerBoundingBox, movementDirection)) > 0.0) {
                    pistonCache.setPlayerCollided(true);
                    pistonCache.displacePlayer(movement.mul(intersection + 0.01));
                    if (state.is(Blocks.SLIME_BLOCK)) {
                        pistonCache.setPlayerSlimeCollision(true);
                        this.applySlimeBlockMotion(blockPos, playerBoundingBox);
                    }
                }
            }
        }
    }

    private BlockCollision getCollision(Vector3i blockPos) {
        return BlockUtils.getCollision(this.getAttachedBlockId(blockPos).javaId());
    }

    public double computeCollisionOffset(Vector3i blockPos, BoundingBox boundingBox, Axis axis, double movement) {
        BlockCollision blockCollision = this.getCollision(blockPos);
        if (blockCollision != null) {
            double movementProgress = this.progress;
            if (this.action == PistonValueType.PULLING || this.action == PistonValueType.CANCELLED_MID_PUSH) {
                movementProgress = 1.0f - this.progress;
            }
            Vector3i movementVec = this.getMovement();
            double x = (double)blockPos.getX() + (double)movementVec.getX() * movementProgress;
            double y = (double)blockPos.getY() + (double)movementVec.getY() * movementProgress;
            double z = (double)blockPos.getZ() + (double)movementVec.getZ() * movementProgress;
            double adjustedMovement = blockCollision.computeCollisionOffset(x, y, z, boundingBox, axis, movement);
            if (this.getAttachedBlockId(blockPos).is(Blocks.SLIME_BLOCK) && adjustedMovement != movement) {
                this.session.getPistonCache().setPlayerSlimeCollision(true);
            }
            return adjustedMovement;
        }
        return movement;
    }

    public boolean checkCollision(Vector3i blockPos, BoundingBox boundingBox) {
        BlockCollision blockCollision = this.getCollision(blockPos);
        if (blockCollision != null) {
            double movementProgress = this.progress;
            if (this.action == PistonValueType.PULLING || this.action == PistonValueType.CANCELLED_MID_PUSH) {
                movementProgress = 1.0f - this.progress;
            }
            Vector3i movementVec = this.getMovement();
            double x = (double)blockPos.getX() + (double)movementVec.getX() * movementProgress;
            double y = (double)blockPos.getY() + (double)movementVec.getY() * movementProgress;
            double z = (double)blockPos.getZ() + (double)movementVec.getZ() * movementProgress;
            return blockCollision.checkIntersection(x, y, z, boundingBox);
        }
        return false;
    }

    private BlockState getAttachedBlockId(Vector3i blockPos) {
        if (blockPos.equals(this.getPistonHeadPos())) {
            return Blocks.PISTON_HEAD.defaultBlockState().withValue(Properties.SHORT, false).withValue(Properties.FACING, this.orientation);
        }
        return (BlockState)this.attachedBlocks.getOrDefault((Object)blockPos, (Object)Blocks.AIR.defaultBlockState());
    }

    private void createMovingBlocks() {
        Map<Vector3i, PistonBlockEntity> movingBlockMap = this.session.getPistonCache().getMovingBlocksMap();
        this.attachedBlocks.forEach((blockPos, javaId) -> movingBlockMap.put((Vector3i)blockPos, this));
        movingBlockMap.put(this.getPistonHeadPos(), this);
        Vector3i movement = this.getMovement();
        BoundingBox playerBoundingBox = this.session.getCollisionManager().getActiveBoundingBox().clone();
        if (this.orientation == Direction.UP) {
            playerBoundingBox.extend(0.0, -256.0, 0.0);
            playerBoundingBox.setSizeX(playerBoundingBox.getSizeX() + 0.5);
            playerBoundingBox.setSizeZ(playerBoundingBox.getSizeZ() + 0.5);
        }
        this.attachedBlocks.forEach((blockPos, state) -> {
            Vector3i newPos = blockPos.add(movement);
            if (SOLID_BOUNDING_BOX.checkIntersection(blockPos.toDouble(), playerBoundingBox) || SOLID_BOUNDING_BOX.checkIntersection(newPos.toDouble(), playerBoundingBox)) {
                this.session.getPistonCache().setPlayerCollided(true);
                if (state.is(Blocks.SLIME_BLOCK)) {
                    this.session.getPistonCache().setPlayerSlimeCollision(true);
                }
                return;
            }
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            updateBlockPacket.setBlockPosition(newPos);
            updateBlockPacket.setDefinition(this.session.getBlockMappings().getBedrockMovingBlock());
            updateBlockPacket.setDataLayer(0);
            this.session.sendUpstreamPacket(updateBlockPacket);
            BlockEntityUtils.updateBlockEntity(this.session, this.buildMovingBlockTag(newPos, (BlockState)state, this.position), newPos);
        });
    }

    private void placeFinalBlocks() {
        Vector3i pistonHeadPos;
        if (this.placedFinalBlocks) {
            return;
        }
        this.placedFinalBlocks = true;
        Vector3i movement = this.getMovement();
        BoundingBox playerBoundingBox = this.session.getCollisionManager().getActiveBoundingBox().clone();
        this.attachedBlocks.forEach((blockPos, state) -> {
            if (!SOLID_BOUNDING_BOX.checkIntersection((blockPos = blockPos.add(movement)).toDouble(), playerBoundingBox)) {
                ChunkUtils.updateBlock(this.session, state, blockPos);
            }
        });
        if (this.action == PistonValueType.PUSHING && !SOLID_BOUNDING_BOX.checkIntersection((pistonHeadPos = this.getPistonHeadPos().add(movement)).toDouble(), playerBoundingBox)) {
            ChunkUtils.updateBlock(this.session, Blocks.PISTON_HEAD.defaultBlockState().withValue(Properties.SHORT, false).withValue(Properties.FACING, this.orientation), pistonHeadPos);
        }
    }

    private void removeMovingBlocks() {
        Map<Vector3i, PistonBlockEntity> movingBlockMap = this.session.getPistonCache().getMovingBlocksMap();
        this.attachedBlocks.forEach((blockPos, javaId) -> movingBlockMap.remove(blockPos));
        this.attachedBlocks.clear();
        movingBlockMap.remove(this.getPistonHeadPos());
        this.flattenedAttachedBlocks = new int[0];
    }

    private void flattenPositions() {
        this.flattenedAttachedBlocks = new int[3 * this.attachedBlocks.size()];
        int i = 0;
        for (Vector3i position : this.attachedBlocks.keySet()) {
            this.flattenedAttachedBlocks[3 * i] = position.getX();
            this.flattenedAttachedBlocks[3 * i + 1] = position.getY();
            this.flattenedAttachedBlocks[3 * i + 2] = position.getZ();
            ++i;
        }
    }

    private byte getState() {
        switch (this.action) {
            case PUSHING: {
                return (byte)(this.isDone() ? 2 : 1);
            }
            case PULLING: {
                return (byte)(this.isDone() ? 0 : 3);
            }
        }
        if (this.progress == 1.0f) {
            return 2;
        }
        return (byte)(this.isDone() ? 0 : 2);
    }

    private Vector3i getPistonHeadPos() {
        if (this.action == PistonValueType.PUSHING) {
            return this.position;
        }
        return this.position.add(this.orientation.getUnitVector());
    }

    private void updateProgress() {
        switch (this.action) {
            case PUSHING: {
                this.lastProgress = this.progress;
                this.progress += 0.5f;
                if (!(this.progress >= 1.0f)) break;
                this.progress = 1.0f;
                break;
            }
            case PULLING: 
            case CANCELLED_MID_PUSH: {
                this.lastProgress = this.progress;
                this.progress -= 0.5f;
                if (!(this.progress <= 0.0f)) break;
                this.progress = 0.0f;
            }
        }
    }

    public boolean isDone() {
        return switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case PistonValueType.PUSHING -> {
                if (this.progress == 1.0f && this.lastProgress == 1.0f) {
                    yield true;
                }
                yield false;
            }
            case PistonValueType.PULLING, PistonValueType.CANCELLED_MID_PUSH -> this.progress == 0.0f && this.lastProgress == 0.0f;
        };
    }

    public boolean canBeRemoved() {
        return this.isDone() && this.timeSinceCompletion > 5L;
    }

    private NbtMap buildPistonTag() {
        NbtMapBuilder builder = BlockEntityTranslator.getConstantBedrockTag("PistonArm", this.position).putIntArray("AttachedBlocks", this.flattenedAttachedBlocks).putFloat("Progress", this.progress).putFloat("LastProgress", this.lastProgress).putByte("NewState", this.getState()).putByte("State", this.getState()).putBoolean("Sticky", this.sticky).putBoolean("isMovable", false);
        return builder.build();
    }

    public static NbtMap buildStaticPistonTag(Vector3i position, boolean extended, boolean sticky) {
        NbtMapBuilder builder = BlockEntityTranslator.getConstantBedrockTag("PistonArm", position).putFloat("Progress", extended ? 1.0f : 0.0f).putFloat("LastProgress", extended ? 1.0f : 0.0f).putByte("NewState", (byte)(extended ? 2 : 0)).putByte("State", (byte)(extended ? 2 : 0)).putBoolean("Sticky", sticky).putBoolean("isMovable", false);
        return builder.build();
    }

    private NbtMap buildMovingBlockTag(Vector3i position, BlockState state, Vector3i pistonPosition) {
        NbtMap movingBlock = this.session.getBlockMappings().getBedrockBlock(state).getState();
        NbtMapBuilder builder = BlockEntityTranslator.getConstantBedrockTag("MovingBlock", position).putBoolean("expanding", this.action == PistonValueType.PUSHING).putCompound("movingBlock", movingBlock).putBoolean("isMovable", true).putInt("pistonPosX", pistonPosition.getX()).putInt("pistonPosY", pistonPosition.getY()).putInt("pistonPosZ", pistonPosition.getZ());
        Block block = state.block();
        if (block instanceof PistonBlock) {
            PistonBlock piston = (PistonBlock)block;
            builder.putCompound("movingEntity", piston.createTag(this.session, position, state));
        }
        return builder.build();
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public PistonValueType getAction() {
        return this.action;
    }

    static {
        BlockCollision blockCollision = BlockRegistries.COLLISIONS.get(Blocks.HONEY_BLOCK.defaultBlockState().javaId());
        if (blockCollision == null) {
            throw new RuntimeException("Failed to find honey block collision");
        }
        BoundingBox blockBoundingBox = blockCollision.getBoundingBoxes()[0];
        double honeyHeight = blockBoundingBox.getMax().getY();
        double boundingBoxHeight = 1.5 - honeyHeight;
        HONEY_BOUNDING_BOX = new BoundingBox(0.5, honeyHeight + boundingBoxHeight / 2.0, 0.5, blockBoundingBox.getSizeX(), boundingBoxHeight, blockBoundingBox.getSizeZ());
    }
}

