/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.RakPing;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.RakServerChannel;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.config.RakServerChannelConfig;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.channel.raknet.config.RakServerMetrics;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.handler.codec.raknet.AdvancedChannelInboundHandler;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.util.RakUtils;
import org.geysermc.geyser.shaded.org.cloudburstmc.netty.util.SecureAlgorithmProvider;

public class RakServerOfflineHandler
extends AdvancedChannelInboundHandler<DatagramPacket> {
    public static final String NAME = "rak-offline-handler";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakServerOfflineHandler.class);
    private final ThreadLocal<SecureRandom> random = ThreadLocal.withInitial(() -> {
        try {
            return SecureRandom.getInstance(SecureAlgorithmProvider.getSecurityAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    });
    private final ExpiringMap<InetSocketAddress, PendingConnection> pendingConnections = ExpiringMap.builder().expiration(10L, TimeUnit.SECONDS).expirationPolicy(ExpirationPolicy.CREATED).expirationListener((key, value) -> ReferenceCountUtil.release((Object)value)).build();
    private final RakServerChannel channel;

    public RakServerOfflineHandler(RakServerChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean acceptInboundMessage(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!super.acceptInboundMessage(ctx, msg)) {
            return false;
        }
        DatagramPacket packet = (DatagramPacket)msg;
        ByteBuf buf = (ByteBuf)packet.content();
        if (!buf.isReadable()) {
            return false;
        }
        int startIndex = buf.readerIndex();
        try {
            short packetId = buf.readUnsignedByte();
            switch (packetId) {
                case 1: {
                    if (buf.isReadable(8)) {
                        buf.readLong();
                    }
                }
                case 5: 
                case 7: {
                    ByteBuf magicBuf = ((RakServerChannelConfig)ctx.channel().config()).getUnconnectedMagic();
                    boolean bl = buf.isReadable(magicBuf.readableBytes()) && ByteBufUtil.equals((ByteBuf)buf.readSlice(magicBuf.readableBytes()), (ByteBuf)magicBuf);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            buf.readerIndex(startIndex);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        short packetId = buf.readUnsignedByte();
        ByteBuf magicBuf = ((RakServerChannelConfig)ctx.channel().config()).getUnconnectedMagic();
        long guid = ((RakServerChannelConfig)ctx.channel().config()).getGuid();
        RakServerMetrics metrics = this.channel.config().getMetrics();
        switch (packetId) {
            case 1: {
                if (metrics != null) {
                    metrics.unconnectedPing((InetSocketAddress)packet.sender());
                }
                this.onUnconnectedPing(ctx, packet, magicBuf, guid);
                break;
            }
            case 5: {
                if (metrics != null) {
                    metrics.connectionInitPacket((InetSocketAddress)packet.sender(), 5);
                }
                this.onOpenConnectionRequest1(ctx, packet, magicBuf, guid);
                break;
            }
            case 7: {
                if (metrics != null) {
                    metrics.connectionInitPacket((InetSocketAddress)packet.sender(), 7);
                }
                this.onOpenConnectionRequest2(ctx, packet, magicBuf, guid);
            }
        }
    }

    private void onUnconnectedPing(ChannelHandlerContext ctx, DatagramPacket packet, ByteBuf magicBuf, long guid) {
        long pingTime = ((ByteBuf)packet.content()).readLong();
        boolean handlePing = ((RakServerChannelConfig)ctx.channel().config()).getHandlePing();
        if (handlePing) {
            ctx.fireChannelRead((Object)new RakPing(pingTime, (InetSocketAddress)packet.sender()));
            return;
        }
        ByteBuf advertisement = ((RakServerChannelConfig)ctx.channel().config()).getAdvertisement();
        int packetLength = 35 + (advertisement != null ? advertisement.readableBytes() : -2);
        ByteBuf out = ctx.alloc().ioBuffer(packetLength);
        out.writeByte(28);
        out.writeLong(pingTime);
        out.writeLong(guid);
        out.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        if (advertisement != null) {
            out.writeShort(advertisement.readableBytes());
            out.writeBytes(advertisement, advertisement.readerIndex(), advertisement.readableBytes());
        }
        ctx.writeAndFlush((Object)RakUtils.datagramReply(out, packet));
    }

    private void onOpenConnectionRequest1(ChannelHandlerContext ctx, DatagramPacket packet, ByteBuf magicBuf, long guid) {
        ByteBuf buffer = (ByteBuf)packet.content();
        InetSocketAddress sender = (InetSocketAddress)packet.sender();
        buffer.skipBytes(magicBuf.readableBytes());
        short protocolVersion = buffer.readUnsignedByte();
        int mtu = buffer.readableBytes() + 1 + magicBuf.readableBytes() + 1 + (sender.getAddress() instanceof Inet6Address ? 40 : 20) + 8;
        int[] supportedProtocols = ((RakServerChannelConfig)ctx.channel().config()).getSupportedProtocols();
        if (supportedProtocols != null && Arrays.binarySearch(supportedProtocols, (int)protocolVersion) < 0) {
            int latestVersion = supportedProtocols[supportedProtocols.length - 1];
            this.sendIncompatibleVersion(ctx, packet, latestVersion, magicBuf, guid);
            return;
        }
        boolean sendCookie = ((RakServerChannelConfig)ctx.channel().config()).getSendCookie();
        int cookie = sendCookie ? this.random.get().nextInt() : 0;
        PendingConnection connection = (PendingConnection)this.pendingConnections.putIfAbsent((Object)sender, (Object)new PendingConnection(protocolVersion, cookie));
        if (connection != null && log.isTraceEnabled()) {
            log.trace("Received duplicate open connection request 1 from {}", (Object)sender);
        }
        int bufferCapacity = sendCookie ? 32 : 28;
        ByteBuf replyBuffer = ctx.alloc().ioBuffer(bufferCapacity, bufferCapacity);
        replyBuffer.writeByte(6);
        replyBuffer.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        replyBuffer.writeLong(guid);
        replyBuffer.writeBoolean(sendCookie);
        if (sendCookie) {
            replyBuffer.writeInt(cookie);
        }
        replyBuffer.writeShort(RakUtils.clamp(mtu, ((RakServerChannelConfig)ctx.channel().config()).getMinMtu(), ((RakServerChannelConfig)ctx.channel().config()).getMaxMtu()));
        ctx.writeAndFlush((Object)RakUtils.datagramReply(replyBuffer, packet));
    }

    private void onOpenConnectionRequest2(ChannelHandlerContext ctx, DatagramPacket packet, ByteBuf magicBuf, long guid) {
        ByteBuf buffer = (ByteBuf)packet.content();
        InetSocketAddress sender = (InetSocketAddress)packet.sender();
        buffer.skipBytes(magicBuf.readableBytes());
        PendingConnection connection = (PendingConnection)this.pendingConnections.remove((Object)sender);
        if (connection == null) {
            if (log.isTraceEnabled()) {
                log.trace("[{}] Received ID_OPEN_CONNECTION_REQUEST_2 without open connection request 1", (Object)sender);
            }
            return;
        }
        boolean sendCookie = ((RakServerChannelConfig)ctx.channel().config()).getSendCookie();
        if (sendCookie) {
            int expectedCookie = connection.cookie;
            int cookie = buffer.readInt();
            if (expectedCookie != cookie) {
                if (log.isTraceEnabled()) {
                    log.trace("[{}] Received ID_OPEN_CONNECTION_REQUEST_2 with invalid cookie (expected {}, but received {})", new Object[]{sender, expectedCookie, cookie});
                }
                return;
            }
            buffer.readBoolean();
        }
        InetSocketAddress serverAddress = RakUtils.readAddress(buffer);
        int mtu = buffer.readUnsignedShort();
        long clientGuid = buffer.readLong();
        int minMtu = ((RakServerChannelConfig)ctx.channel().config()).getMinMtu();
        int maxMtu = ((RakServerChannelConfig)ctx.channel().config()).getMaxMtu();
        if (mtu < minMtu || mtu > maxMtu) {
            if (log.isTraceEnabled()) {
                log.trace("[{}] Received ID_OPEN_CONNECTION_REQUEST_2, but the MTU was {}. Expecting a value between {} - {}", new Object[]{sender, mtu, minMtu, maxMtu});
            }
            this.sendAlreadyConnected(ctx, packet, magicBuf, guid);
            return;
        }
        RakServerChannel serverChannel = (RakServerChannel)ctx.channel();
        RakChildChannel channel = serverChannel.createChildChannel(sender, (InetSocketAddress)packet.recipient(), clientGuid, connection.protocolVersion, mtu);
        if (channel == null) {
            if (log.isTraceEnabled()) {
                log.trace("[{}] Received ID_OPEN_CONNECTION_REQUEST_2, but a channel already exists for this socket address", (Object)sender);
            }
            this.sendAlreadyConnected(ctx, packet, magicBuf, guid);
            return;
        }
        ByteBuf replyBuffer = ctx.alloc().ioBuffer(31);
        replyBuffer.writeByte(8);
        replyBuffer.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        replyBuffer.writeLong(guid);
        RakUtils.writeAddress(replyBuffer, (InetSocketAddress)packet.sender());
        replyBuffer.writeShort(mtu);
        replyBuffer.writeBoolean(false);
        ctx.writeAndFlush((Object)RakUtils.datagramReply(replyBuffer, packet));
    }

    private void sendIncompatibleVersion(ChannelHandlerContext ctx, DatagramPacket request, int protocolVersion, ByteBuf magicBuf, long guid) {
        ByteBuf buffer = ctx.alloc().ioBuffer(26, 26);
        buffer.writeByte(25);
        buffer.writeByte(protocolVersion);
        buffer.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        buffer.writeLong(guid);
        ctx.writeAndFlush((Object)RakUtils.datagramReply(buffer, request));
    }

    private void sendAlreadyConnected(ChannelHandlerContext ctx, DatagramPacket request, ByteBuf magicBuf, long guid) {
        ByteBuf buffer = ctx.alloc().ioBuffer(25, 25);
        buffer.writeByte(18);
        buffer.writeBytes(magicBuf, magicBuf.readerIndex(), magicBuf.readableBytes());
        buffer.writeLong(guid);
        ctx.writeAndFlush((Object)RakUtils.datagramReply(buffer, request));
    }

    private static class PendingConnection {
        final int protocolVersion;
        final int cookie;

        public PendingConnection(int protocolVersion, int cookie) {
            this.protocolVersion = protocolVersion;
            this.cookie = cookie;
        }
    }
}

