/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression.BatchCompression;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Zlib;

public class ZlibCompression
implements BatchCompression {
    private static final int MAX_DECOMPRESSED_BYTES = Integer.getInteger("bedrock.maxDecompressedBytes", 0xA00000);
    private final Zlib zlib;
    private int level = 7;

    public ZlibCompression(Zlib zlib) {
        this.zlib = zlib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf outBuf = ctx.alloc().ioBuffer(msg.readableBytes() << 3);
        try {
            this.zlib.deflate(msg, outBuf, this.level);
            ByteBuf byteBuf = outBuf.retain();
            return byteBuf;
        }
        finally {
            outBuf.release();
        }
    }

    @Override
    public ByteBuf decode(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        return this.zlib.inflate(msg, MAX_DECOMPRESSED_BYTES);
    }

    @Override
    public CompressionAlgorithm getAlgorithm() {
        return PacketCompressionAlgorithm.ZLIB;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }
}

