/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.JukeboxSong;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.SoundMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SpawnParticleEffectPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.StopSoundPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.level.event.LevelEventTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.SoundUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.BonemealGrowEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.BreakBlockEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.BreakPotionEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.ComposterEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.DragonFireballEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEvent;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.LevelEventType;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.RecordEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.SculkBlockChargeEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.SmokeEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.TrialSpawnerDetectEventData;
import org.geysermc.mcprotocollib.protocol.data.game.level.event.UnknownLevelEventData;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundLevelEventPacket;

@Translator(packet=ClientboundLevelEventPacket.class)
public class JavaLevelEventTranslator
extends PacketTranslator<ClientboundLevelEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundLevelEventPacket packet) {
        LevelEvent levelEvent = packet.getEvent();
        if (!(levelEvent instanceof LevelEventType)) {
            return;
        }
        LevelEventType levelEvent2 = (LevelEventType)levelEvent;
        if (levelEvent2 == LevelEventType.SOUND_PLAY_JUKEBOX_SONG) {
            String bedrock;
            RecordEventData recordEventData = (RecordEventData)packet.getData();
            JukeboxSong jukeboxSong = session.getRegistryCache().registry(JavaRegistries.JUKEBOX_SONG).byId(recordEventData.getRecordId());
            if (jukeboxSong == null) {
                return;
            }
            Vector3i origin = packet.getPosition();
            Vector3f pos = Vector3f.from((float)((float)origin.getX() + 0.5f), (float)((float)origin.getY() + 0.5f), (float)((float)origin.getZ() + 0.5f));
            SoundMapping mapping = (SoundMapping)Registries.SOUNDS.get(jukeboxSong.soundEvent().replace("minecraft:", ""));
            SoundEvent soundEvent = null;
            if (mapping != null && (bedrock = mapping.bedrock()) != null && !bedrock.isEmpty()) {
                soundEvent = SoundUtils.toSoundEvent(bedrock);
            }
            if (soundEvent != null) {
                LevelSoundEventPacket levelSoundEvent = new LevelSoundEventPacket();
                levelSoundEvent.setIdentifier("");
                levelSoundEvent.setSound(soundEvent);
                levelSoundEvent.setPosition(pos);
                levelSoundEvent.setRelativeVolumeDisabled(packet.isBroadcast());
                levelSoundEvent.setExtraData(-1);
                levelSoundEvent.setBabySound(false);
                session.sendUpstreamPacket(levelSoundEvent);
            } else {
                String bedrockSound = SoundUtils.translatePlaySound(jukeboxSong.soundEvent());
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setPosition(pos);
                playSoundPacket.setSound(bedrockSound);
                playSoundPacket.setPitch(1.0f);
                playSoundPacket.setVolume(4.0f);
                session.sendUpstreamPacket(playSoundPacket);
                session.getWorldCache().addActiveRecord(origin, bedrockSound);
            }
            TextPacket textPacket = new TextPacket();
            textPacket.setType(TextPacket.Type.JUKEBOX_POPUP);
            textPacket.setNeedsTranslation(true);
            textPacket.setXuid("");
            textPacket.setPlatformChatId("");
            textPacket.setSourceName(null);
            textPacket.setMessage("record.nowPlaying");
            textPacket.setParameters(Collections.singletonList(MinecraftLocale.getLocaleString(jukeboxSong.description(), session.locale())));
            session.sendUpstreamPacket(textPacket);
            return;
        }
        LevelEventTranslator transformer = (LevelEventTranslator)Registries.SOUND_LEVEL_EVENTS.get(packet.getEvent());
        if (transformer != null) {
            transformer.translate(session, packet);
            return;
        }
        Vector3i origin = packet.getPosition();
        Vector3f pos = Vector3f.from((float)((float)origin.getX() + 0.5f), (float)((float)origin.getY() + 0.5f), (float)((float)origin.getZ() + 0.5f));
        LevelEventPacket effectPacket = new LevelEventPacket();
        effectPacket.setPosition(pos);
        effectPacket.setData(0);
        switch (levelEvent2) {
            case PARTICLES_AND_SOUND_BRUSH_BLOCK_COMPLETE: {
                effectPacket.setType(ParticleType.BRUSH_DUST);
                session.playSoundEvent(SoundEvent.BRUSH_COMPLETED, pos);
                break;
            }
            case COMPOSTER_FILL: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_CROP_GROWTH);
                ComposterEventData composterEventData = (ComposterEventData)packet.getData();
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                switch (composterEventData) {
                    case FILL: {
                        soundEventPacket.setSound(SoundEvent.COMPOSTER_FILL);
                        break;
                    }
                    case FILL_SUCCESS: {
                        soundEventPacket.setSound(SoundEvent.COMPOSTER_FILL_LAYER);
                    }
                }
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case LAVA_FIZZ: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.7f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXTINGUISH_FIRE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case REDSTONE_TORCH_BURNOUT: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.0f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXTINGUISH_FIRE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case END_PORTAL_FRAME_FILL: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EVAPORATE);
                effectPacket.setPosition(pos.add(-0.5f, 0.3125f, -0.5f));
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.BLOCK_END_PORTAL_FRAME_FILL);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case PARTICLES_SHOOT_SMOKE: 
            case PARTICLES_SHOOT_WHITE_SMOKE: {
                if (levelEvent2 == LevelEventType.PARTICLES_SHOOT_SMOKE) {
                    effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_SHOOT);
                } else {
                    effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_SHOOT_WHITE_SMOKE);
                }
                SmokeEventData smokeEventData = (SmokeEventData)packet.getData();
                int data = 0;
                switch (smokeEventData.getDirection()) {
                    case DOWN: {
                        data = 4;
                        pos = pos.add(0.0f, -0.9f, 0.0f);
                        break;
                    }
                    case UP: {
                        data = 4;
                        pos = pos.add(0.0f, 0.5f, 0.0f);
                        break;
                    }
                    case NORTH: {
                        data = 1;
                        pos = pos.add(0.0f, -0.2f, -0.7f);
                        break;
                    }
                    case SOUTH: {
                        data = 7;
                        pos = pos.add(0.0f, -0.2f, 0.7f);
                        break;
                    }
                    case WEST: {
                        data = 3;
                        pos = pos.add(-0.7f, -0.2f, 0.0f);
                        break;
                    }
                    case EAST: {
                        data = 5;
                        pos = pos.add(0.7f, -0.2f, 0.0f);
                    }
                }
                effectPacket.setPosition(pos);
                effectPacket.setData(data);
                break;
            }
            case PARTICLES_DESTROY_BLOCK: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_DESTROY_BLOCK);
                BreakBlockEventData breakBlockEventData = (BreakBlockEventData)packet.getData();
                effectPacket.setData(session.getBlockMappings().getBedrockBlockId(breakBlockEventData.getBlockState()));
                break;
            }
            case PARTICLES_SPELL_POTION_SPLASH: 
            case PARTICLES_INSTANT_POTION_SPLASH: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_POTION_SPLASH);
                effectPacket.setPosition(pos.add(0.0f, -0.5f, 0.0f));
                BreakPotionEventData splashPotionData = (BreakPotionEventData)packet.getData();
                effectPacket.setData(splashPotionData.getPotionId());
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.GLASS);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case PARTICLES_EYE_OF_ENDER_DEATH: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EYE_OF_ENDER_DEATH);
                break;
            }
            case PARTICLES_MOBBLOCK_SPAWN: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_MOB_BLOCK_SPAWN);
                break;
            }
            case PARTICLES_AND_SOUND_PLANT_GROWTH: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_CROP_GROWTH);
                BonemealGrowEventData growEventData = (BonemealGrowEventData)packet.getData();
                effectPacket.setData(growEventData.getParticleCount());
                break;
            }
            case PARTICLES_EGG_CRACK: {
                effectPacket.setType(ParticleType.VILLAGER_HAPPY);
                break;
            }
            case PARTICLES_DRAGON_FIREBALL_SPLASH: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EYE_OF_ENDER_DEATH);
                DragonFireballEventData fireballEventData = (DragonFireballEventData)packet.getData();
                if (fireballEventData != DragonFireballEventData.HAS_SOUND) break;
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXPLODE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case PARTICLES_DRAGON_BLOCK_BREAK: {
                effectPacket.setType(ParticleType.DRAGON_DESTROY_BLOCK);
                break;
            }
            case PARTICLES_WATER_EVAPORATING: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EVAPORATE_WATER);
                effectPacket.setPosition(pos.add(-0.5f, 0.5f, -0.5f));
                break;
            }
            case ANIMATION_END_GATEWAY_SPAWN: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_EXPLOSION);
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.EXPLODE);
                soundEventPacket.setPosition(pos);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                break;
            }
            case ANIMATION_SPAWN_COBWEB: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.ANIMATION_SPAWN_COBWEB);
                break;
            }
            case ANIMATION_VAULT_ACTIVATE: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.ANIMATION_VAULT_ACTIVATE);
                break;
            }
            case ANIMATION_VAULT_DEACTIVATE: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.ANIMATION_VAULT_DEACTIVATE);
                break;
            }
            case ANIMATION_VAULT_EJECT_ITEM: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.ANIMATION_VAULT_EJECT_ITEM);
                break;
            }
            case ANIMATION_TRIAL_SPAWNER_EJECT_ITEM: {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setSound("trial_spawner.eject_item");
                playSoundPacket.setPosition(pos);
                playSoundPacket.setVolume(1.0f);
                playSoundPacket.setPitch(0.8f + ((Random)random).nextFloat() * 0.3f);
                session.sendUpstreamPacket(playSoundPacket);
                return;
            }
            case DRIPSTONE_DRIP: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_DRIPSTONE_DRIP);
                break;
            }
            case PARTICLES_ELECTRIC_SPARK: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_ELECTRIC_SPARK);
                break;
            }
            case PARTICLES_AND_SOUND_WAX_ON: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_WAX_ON);
                break;
            }
            case PARTICLES_WAX_OFF: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_WAX_OFF);
                break;
            }
            case PARTICLES_SCRAPE: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_SCRAPE);
                break;
            }
            case PARTICLES_SCULK_CHARGE: {
                SculkBlockChargeEventData eventData = (SculkBlockChargeEventData)packet.getData();
                LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
                if (eventData.getCharge() > 0) {
                    levelEventPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.SCULK_CHARGE);
                    levelEventPacket.setTag(NbtMap.builder().putInt("x", packet.getPosition().getX()).putInt("y", packet.getPosition().getY()).putInt("z", packet.getPosition().getZ()).putShort("charge", (short)eventData.getCharge()).putShort("facing", this.encodeFacing(eventData.getBlockFaces())).build());
                } else {
                    levelEventPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.SCULK_CHARGE_POP);
                    levelEventPacket.setTag(NbtMap.builder().putInt("x", packet.getPosition().getX()).putInt("y", packet.getPosition().getY()).putInt("z", packet.getPosition().getZ()).build());
                }
                session.sendUpstreamPacket(levelEventPacket);
                return;
            }
            case PARTICLES_SCULK_SHRIEK: {
                LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
                levelEventPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_SCULK_SHRIEK);
                levelEventPacket.setTag(NbtMap.builder().putInt("originX", packet.getPosition().getX()).putInt("originY", packet.getPosition().getY()).putInt("originZ", packet.getPosition().getZ()).build());
                session.sendUpstreamPacket(levelEventPacket);
                LevelSoundEventPacket soundEventPacket = new LevelSoundEventPacket();
                soundEventPacket.setSound(SoundEvent.SCULK_SHRIEKER_SHRIEK);
                soundEventPacket.setPosition(packet.getPosition().toFloat());
                soundEventPacket.setExtraData(-1);
                soundEventPacket.setIdentifier("");
                soundEventPacket.setBabySound(false);
                soundEventPacket.setRelativeVolumeDisabled(false);
                session.sendUpstreamPacket(soundEventPacket);
                return;
            }
            case PARTICLES_TRIAL_SPAWNER_DETECT_PLAYER: {
                TrialSpawnerDetectEventData eventData = (TrialSpawnerDetectEventData)packet.getData();
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_DETECTION);
                effectPacket.setPosition(pos.sub(0.5f, 0.75f, 0.5f));
                effectPacket.setData(eventData.getDetectedPlayers());
                break;
            }
            case PARTICLES_TRIAL_SPAWNER_DETECT_PLAYER_OMINOUS: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_DETECTION_CHARGED);
                effectPacket.setPosition(pos.sub(0.5f, 0.75f, 0.5f));
                JavaLevelEventTranslator.spawnOminousTrialSpawnerParticles(session, pos);
                break;
            }
            case PARTICLES_TRIAL_SPAWNER_BECOME_OMINOUS: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_BECOME_CHARGED);
                effectPacket.setPosition(pos.sub(0.5f, 0.5f, 0.5f));
                JavaLevelEventTranslator.spawnOminousTrialSpawnerParticles(session, pos);
                break;
            }
            case PARTICLES_TRIAL_SPAWNER_SPAWN_MOB_AT: {
                UnknownLevelEventData eventData = (UnknownLevelEventData)packet.getData();
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_SPAWNING);
                effectPacket.setData(eventData.getData());
                break;
            }
            case PARTICLES_TRIAL_SPAWNER_SPAWN: {
                UnknownLevelEventData eventData = (UnknownLevelEventData)packet.getData();
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_SPAWNING);
                effectPacket.setData(eventData.getData());
                ThreadLocalRandom random = ThreadLocalRandom.current();
                PlaySoundPacket playSoundPacket = new PlaySoundPacket();
                playSoundPacket.setSound("trial_spawner.spawn_mob");
                playSoundPacket.setPosition(pos);
                playSoundPacket.setVolume(1.0f);
                playSoundPacket.setPitch(0.8f + ((Random)random).nextFloat() * 0.3f);
                session.sendUpstreamPacket(playSoundPacket);
                break;
            }
            case PARTICLES_TRIAL_SPAWNER_SPAWN_ITEM: {
                effectPacket.setType(org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent.PARTICLE_TRIAL_SPAWNER_EJECTING);
                break;
            }
            case SOUND_STOP_JUKEBOX_SONG: {
                String bedrockSound = session.getWorldCache().removeActiveRecord(origin);
                if (bedrockSound == null) {
                    LevelSoundEventPacket levelSoundEvent = new LevelSoundEventPacket();
                    levelSoundEvent.setIdentifier("");
                    levelSoundEvent.setSound(SoundEvent.STOP_RECORD);
                    levelSoundEvent.setPosition(pos);
                    levelSoundEvent.setRelativeVolumeDisabled(false);
                    levelSoundEvent.setExtraData(-1);
                    levelSoundEvent.setBabySound(false);
                    session.sendUpstreamPacket(levelSoundEvent);
                } else {
                    StopSoundPacket stopSound = new StopSoundPacket();
                    stopSound.setSoundName(bedrockSound);
                    session.sendUpstreamPacket(stopSound);
                }
                return;
            }
            default: {
                GeyserImpl.getInstance().getLogger().debug("Unhandled level event: " + String.valueOf(packet.getEvent()));
                return;
            }
        }
        session.sendUpstreamPacket(effectPacket);
    }

    private short encodeFacing(Set<Direction> blockFaces) {
        short facing = 0;
        if (blockFaces.contains(Direction.DOWN)) {
            facing = (short)(facing | 1);
        }
        if (blockFaces.contains(Direction.UP)) {
            facing = (short)(facing | 2);
        }
        if (blockFaces.contains(Direction.SOUTH)) {
            facing = (short)(facing | 4);
        }
        if (blockFaces.contains(Direction.WEST)) {
            facing = (short)(facing | 8);
        }
        if (blockFaces.contains(Direction.NORTH)) {
            facing = (short)(facing | 0x10);
        }
        if (blockFaces.contains(Direction.EAST)) {
            facing = (short)(facing | 0x20);
        }
        return facing;
    }

    private static void spawnOminousTrialSpawnerParticles(GeyserSession session, Vector3f pos) {
        int dimensionId = DimensionUtils.javaToBedrock(session);
        SpawnParticleEffectPacket stringPacket = new SpawnParticleEffectPacket();
        stringPacket.setIdentifier("minecraft:trial_spawner_detection_ominous");
        stringPacket.setDimensionId(dimensionId);
        stringPacket.setPosition(pos.sub(0.5f, 0.75f, 0.5f));
        stringPacket.setMolangVariablesJson(Optional.empty());
        stringPacket.setUniqueEntityId(-1L);
        session.sendUpstreamPacket(stringPacket);
    }
}

