/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import java.util.Collections;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class SkullBlock
extends Block {
    private final Type type;

    public SkullBlock(String javaIdentifier, Type type, Block.Builder builder) {
        super(javaIdentifier, builder);
        this.type = type;
    }

    @Override
    protected void sendBlockUpdatePacket(GeyserSession session, BlockState state, BlockDefinition definition, Vector3i position) {
        SkullCache.Skull skull;
        if (this.type == Type.PLAYER && (skull = session.getSkullCache().updateSkull(position, state)) != null && skull.getBlockDefinition() != null) {
            definition = skull.getBlockDefinition();
        }
        super.sendBlockUpdatePacket(session, state, definition, position);
    }

    @Override
    protected void checkForEmptySkull(GeyserSession session, BlockState state, Vector3i position) {
    }

    public ItemStack pickItem(GeyserSession session, BlockState state, Vector3i position) {
        SkullCache.Skull skull = session.getSkullCache().getSkulls().get(position);
        if (skull == null) {
            return new ItemStack(this.pickItem(state).getId());
        }
        GeyserItemStack itemStack = GeyserItemStack.of(this.pickItem(state).getId(), 1);
        NbtMapBuilder builder = NbtMap.builder().putString("id", "minecraft:skull").putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ());
        DataComponents components = itemStack.getOrCreateComponents();
        components.put(DataComponentTypes.BLOCK_ENTITY_DATA, (Object)builder.build());
        UUID uuid = skull.getUuid();
        String texturesProperty = skull.getTexturesProperty();
        GameProfile profile = new GameProfile(uuid, null);
        if (texturesProperty != null) {
            profile.setProperties(Collections.singletonList(new GameProfile.Property("textures", texturesProperty)));
        }
        components.put(DataComponentTypes.PROFILE, (Object)profile);
        return itemStack.getItemStack();
    }

    public Type skullType() {
        return this.type;
    }

    public static enum Type {
        SKELETON(0),
        WITHER_SKELETON(1),
        PLAYER(3),
        ZOMBIE(2),
        CREEPER(4),
        PIGLIN(6),
        DRAGON(5);

        private final int bedrockId;

        private Type(int bedrockId) {
            this.bedrockId = bedrockId;
        }

        public int bedrockId() {
            return this.bedrockId;
        }
    }
}

