/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomSkullsEvent;
import org.geysermc.geyser.configuration.GeyserCustomSkullConfiguration;
import org.geysermc.geyser.pack.SkullResourcePackManager;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class CustomSkullRegistryPopulator {
    public static void populate() {
        GeyserCustomSkullConfiguration skullConfig;
        SkullResourcePackManager.SKULL_SKINS.clear();
        BlockRegistries.CUSTOM_SKULLS.set(Object2ObjectMaps.emptyMap());
        if (!GeyserImpl.getInstance().getConfig().isAddNonBedrockItems()) {
            return;
        }
        try {
            GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
            Path skullConfigPath = bootstrap.getConfigFolder().resolve("custom-skulls.yml");
            File skullConfigFile = FileUtils.fileOrCopiedFromResource(skullConfigPath.toFile(), "custom-skulls.yml", Function.identity(), bootstrap);
            skullConfig = FileUtils.loadConfig(skullConfigFile, GeyserCustomSkullConfiguration.class);
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.config.failed"), e);
            return;
        }
        BlockRegistries.CUSTOM_SKULLS.set(new Object2ObjectOpenHashMap());
        final ArrayList<String> profiles = new ArrayList<String>(skullConfig.getPlayerProfiles());
        final ArrayList<String> usernames = new ArrayList<String>(skullConfig.getPlayerUsernames());
        final ArrayList<String> uuids = new ArrayList<String>(skullConfig.getPlayerUUIDs());
        final ArrayList<String> skinHashes = new ArrayList<String>(skullConfig.getPlayerSkinHashes());
        GeyserImpl.getInstance().getEventBus().fire(new GeyserDefineCustomSkullsEvent(){

            @Override
            public void register(@NonNull String texture, @NonNull GeyserDefineCustomSkullsEvent.SkullTextureType type) {
                switch (type) {
                    case USERNAME: {
                        usernames.add(texture);
                        break;
                    }
                    case UUID: {
                        uuids.add(texture);
                        break;
                    }
                    case PROFILE: {
                        profiles.add(texture);
                        break;
                    }
                    case SKIN_HASH: {
                        skinHashes.add(texture);
                    }
                }
            }
        });
        usernames.forEach(username -> {
            String skinHash;
            String profile = CustomSkullRegistryPopulator.getProfileFromUsername(username);
            if (profile != null && (skinHash = CustomSkullRegistryPopulator.getSkinHash(profile)) != null) {
                skinHashes.add(skinHash);
            }
        });
        uuids.forEach(uuid -> {
            String skinHash;
            String profile = CustomSkullRegistryPopulator.getProfileFromUuid(uuid);
            if (profile != null && (skinHash = CustomSkullRegistryPopulator.getSkinHash(profile)) != null) {
                skinHashes.add(skinHash);
            }
        });
        profiles.forEach(profile -> {
            String skinHash = CustomSkullRegistryPopulator.getSkinHash(profile);
            if (skinHash != null) {
                skinHashes.add(skinHash);
            }
        });
        skinHashes.forEach(skinHash -> {
            if (!skinHash.matches("^[a-fA-F0-9]+$")) {
                GeyserImpl.getInstance().getLogger().error("Skin hash " + skinHash + " does not match required format ^[a-fA-F0-9]{64}$ and will not be added as a custom block.");
                return;
            }
            try {
                SkullResourcePackManager.cacheSkullSkin(skinHash);
                BlockRegistries.CUSTOM_SKULLS.register((String)skinHash, new CustomSkull((String)skinHash));
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error("Failed to cache skin for skull texture " + skinHash + " This skull will not be added as a custom block.", e);
            }
        });
        if (!((Map)BlockRegistries.CUSTOM_SKULLS.get()).isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + ((Map)BlockRegistries.CUSTOM_SKULLS.get()).size() + " custom skulls as custom blocks.");
        }
    }

    private static @Nullable String getSkinHash(String profile) {
        try {
            SkinManager.GameProfileData profileData = SkinManager.GameProfileData.loadFromJson(profile);
            if (profileData == null) {
                GeyserImpl.getInstance().getLogger().warning("Skull texture " + profile + " contained no skins and will not be added as a custom block.");
                return null;
            }
            String skinUrl = profileData.skinUrl();
            return skinUrl.substring(skinUrl.lastIndexOf("/") + 1);
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().error("Skull texture " + profile + " is invalid and will not be added as a custom block.", e);
            return null;
        }
    }

    private static @Nullable String getProfileFromUsername(String username) {
        try {
            return SkinProvider.requestTexturesFromUsername(username).get();
        }
        catch (InterruptedException | ExecutionException e) {
            GeyserImpl.getInstance().getLogger().error("Unable to request skull textures for " + username + " This skull will not be added as a custom block.", e);
            return null;
        }
    }

    private static @Nullable String getProfileFromUuid(String uuid) {
        try {
            String uuidDigits = uuid.replace("-", "");
            if (uuidDigits.length() != 32) {
                GeyserImpl.getInstance().getLogger().error("Invalid skull uuid " + uuid + " This skull will not be added as a custom block.");
                return null;
            }
            return SkinProvider.requestTexturesFromUUID(uuid).get();
        }
        catch (InterruptedException | ExecutionException e) {
            GeyserImpl.getInstance().getLogger().error("Unable to request skull textures for " + uuid + " This skull will not be added as a custom block.", e);
            return null;
        }
    }
}

