/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.tags;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.IntArrays;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public final class GeyserHolderSet<T> {
    private final JavaRegistryKey<T> registry;
    private final @Nullable Tag<T> tag;
    private final int @Nullable [] holders;

    public GeyserHolderSet(JavaRegistryKey<T> registry, int @NonNull [] holders) {
        this(registry, null, holders);
    }

    public GeyserHolderSet(JavaRegistryKey<T> registry, @NonNull Tag<T> tagId) {
        this(registry, tagId, null);
    }

    private GeyserHolderSet(JavaRegistryKey<T> registry, @Nullable Tag<T> tag, int @Nullable [] holders) {
        this.registry = registry;
        this.tag = tag;
        this.holders = holders;
    }

    public static <T> GeyserHolderSet<T> fromHolderSet(JavaRegistryKey<T> registry, @NonNull HolderSet holderSet) {
        Tag<T> tag = holderSet.getLocation() == null ? null : new Tag<T>(registry, holderSet.getLocation());
        return new GeyserHolderSet<T>(registry, tag, holderSet.getHolders());
    }

    public List<T> resolve(GeyserSession session) {
        return TagCache.mapRawArray(session, this.resolveRaw(session.getTagCache()), this.registry);
    }

    public int[] resolveRaw(TagCache tagCache) {
        if (this.holders != null) {
            return this.holders;
        }
        return tagCache.getRaw(Objects.requireNonNull(this.tag, "HolderSet must have a tag if it doesn't have a list of IDs"));
    }

    public static <T> GeyserHolderSet<T> readHolderSet(GeyserSession session, JavaRegistryKey<T> registry, @Nullable Object holderSet, ToIntFunction<Key> keyIdMapping) {
        if (holderSet == null) {
            return new GeyserHolderSet<T>(registry, IntArrays.EMPTY_ARRAY);
        }
        if (holderSet instanceof String) {
            String stringTag = (String)holderSet;
            if (stringTag.startsWith("#")) {
                return new GeyserHolderSet<T>(registry, new Tag<T>(registry, Key.key(stringTag.substring(1))));
            }
            if (stringTag.isEmpty()) {
                return new GeyserHolderSet<T>(registry, IntArrays.EMPTY_ARRAY);
            }
            return new GeyserHolderSet<T>(registry, new int[]{keyIdMapping.applyAsInt(Key.key(stringTag))});
        }
        if (holderSet instanceof List) {
            List list = (List)holderSet;
            return new GeyserHolderSet<T>(registry, list.stream().map(o -> (String)o).map(Key::key).mapToInt(keyIdMapping).toArray());
        }
        session.getGeyser().getLogger().warning("Failed parsing HolderSet for registry + " + String.valueOf(registry) + "! Expected either a tag, a string ID or a list of string IDs, found " + String.valueOf(holderSet));
        return new GeyserHolderSet<T>(registry, IntArrays.EMPTY_ARRAY);
    }

    public JavaRegistryKey<T> getRegistry() {
        return this.registry;
    }

    public @Nullable Tag<T> getTag() {
        return this.tag;
    }

    public int @Nullable [] getHolders() {
        return this.holders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserHolderSet)) {
            return false;
        }
        GeyserHolderSet other = (GeyserHolderSet)o;
        JavaRegistryKey<T> this$registry = this.getRegistry();
        JavaRegistryKey<T> other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry)) {
            return false;
        }
        Tag<T> this$tag = this.getTag();
        Tag<T> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        return Arrays.equals(this.getHolders(), other.getHolders());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaRegistryKey<T> $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        Tag<T> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHolders());
        return result;
    }

    public String toString() {
        return "GeyserHolderSet(registry=" + String.valueOf(this.getRegistry()) + ", tag=" + String.valueOf(this.getTag()) + ", holders=" + Arrays.toString(this.getHolders()) + ")";
    }
}

