/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class ClientboundUpdateMobEffectPacket
implements MinecraftPacket {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_SHOW_PARTICLES = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private static final int FLAG_BLEND = 8;
    private final int entityId;
    @lombok.NonNull
    private final Effect effect;
    private final int amplifier;
    private final int duration;
    private final boolean ambient;
    private final boolean showParticles;
    private final boolean showIcon;
    private final boolean blend;

    public ClientboundUpdateMobEffectPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.effect = MinecraftTypes.readEffect(in);
        this.amplifier = MinecraftTypes.readVarInt(in);
        this.duration = MinecraftTypes.readVarInt(in);
        byte flags = in.readByte();
        this.ambient = (flags & 1) != 0;
        this.showParticles = (flags & 2) != 0;
        this.showIcon = (flags & 4) != 0;
        this.blend = (flags & 8) != 0;
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeEffect(out, this.effect);
        MinecraftTypes.writeVarInt(out, this.amplifier);
        MinecraftTypes.writeVarInt(out, this.duration);
        int flags = 0;
        if (this.ambient) {
            flags |= 1;
        }
        if (this.showParticles) {
            flags |= 2;
        }
        if (this.showIcon) {
            flags |= 4;
        }
        if (this.blend) {
            flags |= 8;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public boolean isBlend() {
        return this.blend;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateMobEffectPacket)) {
            return false;
        }
        ClientboundUpdateMobEffectPacket other = (ClientboundUpdateMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getAmplifier() != other.getAmplifier()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isAmbient() != other.isAmbient()) {
            return false;
        }
        if (this.isShowParticles() != other.isShowParticles()) {
            return false;
        }
        if (this.isShowIcon() != other.isShowIcon()) {
            return false;
        }
        if (this.isBlend() != other.isBlend()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        return !(this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateMobEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getAmplifier();
        result = result * 59 + this.getDuration();
        result = result * 59 + (this.isAmbient() ? 79 : 97);
        result = result * 59 + (this.isShowParticles() ? 79 : 97);
        result = result * 59 + (this.isShowIcon() ? 79 : 97);
        result = result * 59 + (this.isBlend() ? 79 : 97);
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateMobEffectPacket(entityId=" + this.getEntityId() + ", effect=" + String.valueOf((Object)this.getEffect()) + ", amplifier=" + this.getAmplifier() + ", duration=" + this.getDuration() + ", ambient=" + this.isAmbient() + ", showParticles=" + this.isShowParticles() + ", showIcon=" + this.isShowIcon() + ", blend=" + this.isBlend() + ")";
    }

    public @NonNull ClientboundUpdateMobEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundUpdateMobEffectPacket(entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withEffect(@lombok.NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ClientboundUpdateMobEffectPacket(this.entityId, effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withAmplifier(int amplifier) {
        return this.amplifier == amplifier ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, amplifier, this.duration, this.ambient, this.showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withDuration(int duration) {
        return this.duration == duration ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, duration, this.ambient, this.showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withAmbient(boolean ambient) {
        return this.ambient == ambient ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, ambient, this.showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withShowParticles(boolean showParticles) {
        return this.showParticles == showParticles ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, showParticles, this.showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withShowIcon(boolean showIcon) {
        return this.showIcon == showIcon ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, showIcon, this.blend);
    }

    public @NonNull ClientboundUpdateMobEffectPacket withBlend(boolean blend) {
        return this.blend == blend ? this : new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.showIcon, blend);
    }

    public ClientboundUpdateMobEffectPacket(int entityId, @lombok.NonNull Effect effect, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, boolean blend) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.showParticles = showParticles;
        this.showIcon = showIcon;
        this.blend = blend;
    }
}

