/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreType;

public final class Objective {
    private final Scoreboard scoreboard;
    private final List<DisplaySlot> activeSlots = new ArrayList<DisplaySlot>();
    private final String objectiveName;
    private final Map<String, ScoreReference> scores = new ConcurrentHashMap<String, ScoreReference>();
    private String displayName;
    private NumberFormat numberFormat;
    private ScoreType type;

    public Objective(Scoreboard scoreboard, String objectiveName) {
        this.scoreboard = scoreboard;
        this.objectiveName = objectiveName;
    }

    public void registerScore(String id, int score, Component displayName, NumberFormat numberFormat) {
        if (this.scores.containsKey(id)) {
            return;
        }
        ScoreReference reference = new ScoreReference(this.scoreboard, id, score, displayName, numberFormat);
        this.scores.put(id, reference);
        for (DisplaySlot slot : this.activeSlots) {
            slot.addScore(reference);
        }
    }

    public void setScore(String id, int score, Component displayName, NumberFormat numberFormat) {
        ScoreReference stored = this.scores.get(id);
        if (stored != null) {
            stored.updateProperties(this.scoreboard, score, displayName, numberFormat);
            return;
        }
        this.registerScore(id, score, displayName, numberFormat);
    }

    public void removeScore(String id) {
        ScoreReference stored = this.scores.remove(id);
        if (stored != null) {
            stored.markDeleted();
        }
    }

    public void updateProperties(Component displayNameComponent, ScoreType type, NumberFormat format) {
        String displayName = MessageTranslator.convertMessageRaw(displayNameComponent, this.scoreboard.session().locale());
        boolean changed = !Objects.equals(this.displayName, displayName) || this.type != type;
        this.displayName = displayName;
        this.type = type;
        if (!Objects.equals(this.numberFormat, format)) {
            this.numberFormat = format;
            if (!changed) {
                for (ScoreReference score : this.scores.values()) {
                    if (score.numberFormat() != null) continue;
                    score.markChanged();
                }
            }
        }
        if (changed) {
            for (DisplaySlot slot : this.activeSlots) {
                slot.markNeedsUpdate();
            }
        }
    }

    public boolean hasDisplaySlot() {
        return !this.activeSlots.isEmpty();
    }

    public void addDisplaySlot(DisplaySlot slot) {
        this.activeSlots.add(slot);
    }

    public void removeDisplaySlot(DisplaySlot slot) {
        this.activeSlots.remove(slot);
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public List<DisplaySlot> getActiveSlots() {
        return this.activeSlots;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public Map<String, ScoreReference> getScores() {
        return this.scores;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public ScoreType getType() {
        return this.type;
    }
}

