/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.type.living.animal.horse.CamelEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class CamelVehicleComponent
extends VehicleComponent<CamelEntity> {
    private static final int STANDING_TICKS = 52;
    private static final int DASH_TICKS = 55;
    private float horseJumpStrength = 0.42f;
    private long lastPoseTick;
    private int dashTick;
    private int effectJumpBoost;

    public CamelVehicleComponent(CamelEntity vehicle) {
        super(vehicle, 1.5f);
    }

    public void startDashCooldown() {
        this.dashTick = ((CamelEntity)this.vehicle).getSession().getTicks() + 55;
    }

    @Override
    public void tickVehicle() {
        if (this.dashTick != 0) {
            if (((CamelEntity)this.vehicle).getSession().getTicks() > this.dashTick) {
                ((CamelEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, false);
                this.dashTick = 0;
            } else {
                ((CamelEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, true);
            }
        }
        ((CamelEntity)this.vehicle).setFlag(EntityFlag.CAN_DASH, ((CamelEntity)this.vehicle).getFlag(EntityFlag.SADDLED) && !this.isStationary());
        ((CamelEntity)this.vehicle).updateBedrockMetadata();
        super.tickVehicle();
    }

    @Override
    public void onDismount() {
        ((CamelEntity)this.vehicle).setFlag(EntityFlag.HAS_DASH_COOLDOWN, false);
        ((CamelEntity)this.vehicle).updateBedrockMetadata();
        super.onDismount();
    }

    @Override
    protected boolean travel(VehicleComponent.VehicleContext ctx, float speed) {
        if (((CamelEntity)this.vehicle).isOnGround() && this.isStationary()) {
            ((CamelEntity)this.vehicle).setMotion(((CamelEntity)this.vehicle).getMotion().mul(0.0f, 1.0f, 0.0f));
        }
        return super.travel(ctx, speed);
    }

    @Override
    protected Vector3f getInputVelocity(VehicleComponent.VehicleContext ctx, float speed) {
        if (this.isStationary()) {
            return Vector3f.ZERO;
        }
        SessionPlayerEntity player = ((CamelEntity)this.vehicle).getSession().getPlayerEntity();
        Vector3f inputVelocity = super.getInputVelocity(ctx, speed);
        float jumpStrength = player.getVehicleJumpStrength();
        if (jumpStrength > 0.0f) {
            player.setVehicleJumpStrength(0);
            jumpStrength = jumpStrength >= 90.0f ? 1.0f : 0.4f + 0.4f * jumpStrength / 90.0f;
            return inputVelocity.add(Vector3f.createDirectionDeg(0.0f, -player.getYaw()).mul(22.2222f * jumpStrength * this.moveSpeed * this.getVelocityMultiplier(ctx)).up(1.4285f * jumpStrength * (this.horseJumpStrength * this.getJumpVelocityMultiplier(ctx) + (float)this.effectJumpBoost * 0.1f)));
        }
        return inputVelocity;
    }

    @Override
    protected Vector2f getVehicleRotation() {
        if (this.isStationary()) {
            return Vector2f.from(((CamelEntity)this.vehicle).getYaw(), ((CamelEntity)this.vehicle).getPitch());
        }
        return super.getVehicleRotation();
    }

    private boolean isStationary() {
        return this.lastPoseTick < 0L || ((CamelEntity)this.vehicle).getSession().getWorldTicks() < this.lastPoseTick + 52L;
    }

    @Override
    public void setEffect(Effect effect, int effectAmplifier) {
        if (effect == Effect.JUMP_BOOST) {
            this.effectJumpBoost = effectAmplifier + 1;
        } else {
            super.setEffect(effect, effectAmplifier);
        }
    }

    @Override
    public void removeEffect(Effect effect) {
        if (effect == Effect.JUMP_BOOST) {
            this.effectJumpBoost = 0;
        } else {
            super.removeEffect(effect);
        }
    }

    public void setHorseJumpStrength(float horseJumpStrength) {
        this.horseJumpStrength = horseJumpStrength;
    }

    public void setLastPoseTick(long lastPoseTick) {
        this.lastPoseTick = lastPoseTick;
    }
}

