/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Map;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.GeyserChunkSection;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.translator.level.block.entity.BedrockChunkWantsBlockEntityTag;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.SkullBlockEntityTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.BitStorage;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.ChunkSection;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.GlobalPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.SingletonPalette;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundLevelChunkWithLightPacket;

@Translator(packet=ClientboundLevelChunkWithLightPacket.class)
public class JavaLevelChunkWithLightTranslator
extends PacketTranslator<ClientboundLevelChunkWithLightPacket> {
    private static final ThreadLocal<ExtendedCollisionsStorage> EXTENDED_COLLISIONS_STORAGE = ThreadLocal.withInitial(ExtendedCollisionsStorage::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translate(GeyserSession session, ClientboundLevelChunkWithLightPacket packet) {
        byte[] payload;
        int sectionCount;
        boolean useExtendedCollisions;
        boolean bl = useExtendedCollisions = !session.getBlockMappings().getExtendedCollisionBoxes().isEmpty();
        if (session.isSpawned()) {
            ChunkUtils.updateChunkPosition(session, session.getPlayerEntity().getPosition().toInt());
        }
        int yOffset = session.getChunkCache().getChunkMinY();
        int chunkSize = session.getChunkCache().getChunkHeightY();
        DataPalette[] javaChunks = new DataPalette[chunkSize];
        DataPalette[] javaBiomes = new DataPalette[chunkSize];
        BlockEntityInfo[] blockEntities = packet.getBlockEntities();
        ObjectArrayList bedrockBlockEntities = new ObjectArrayList(blockEntities.length);
        BitSet waterloggedPaletteIds = new BitSet();
        BitSet bedrockOnlyBlockEntityIds = new BitSet();
        BedrockDimension bedrockDimension = session.getBedrockDimension();
        int maxBedrockSectionY = (bedrockDimension.height() >> 4) - 1;
        ByteBuf byteBuf = null;
        GeyserChunkSection[] sections = new GeyserChunkSection[javaChunks.length - (yOffset + (bedrockDimension.minY() >> 4))];
        try {
            int i;
            ByteBuf in = Unpooled.wrappedBuffer((byte[])packet.getChunkData());
            int extendedCollisionNextSection = 0;
            for (int sectionY = 0; sectionY < chunkSize; ++sectionY) {
                BlockStorage[] layers;
                ChunkSection javaSection = MinecraftTypes.readChunkSection(in);
                javaChunks[sectionY] = javaSection.getChunkData();
                javaBiomes[sectionY] = javaSection.getBiomeData();
                int extendedCollision = extendedCollisionNextSection;
                int thisExtendedCollisionNextSection = 0;
                int bedrockSectionY = sectionY + (yOffset - (bedrockDimension.minY() >> 4));
                int subChunkIndex = sectionY + yOffset;
                if (bedrockSectionY < 0 || maxBedrockSectionY < bedrockSectionY) {
                    if (useExtendedCollisions) {
                        EXTENDED_COLLISIONS_STORAGE.get().clear();
                    }
                    extendedCollisionNextSection = 0;
                    continue;
                }
                if (javaSection.isBlockCountEmpty()) {
                    if (!useExtendedCollisions) continue;
                    if (extendedCollision != 0) {
                        int blocks = EXTENDED_COLLISIONS_STORAGE.get().bottomLayerCollisions() + 1;
                        BitArray bedrockData = BitArrayVersion.forBitsCeil(32 - Integer.numberOfLeadingZeros(blocks)).createArray(4096);
                        BlockStorage layer0 = new BlockStorage(bedrockData, new IntArrayList(blocks));
                        layer0.idFor(session.getBlockMappings().getBedrockAir().getRuntimeId());
                        for (int yzx = 0; yzx < 256; ++yzx) {
                            if (EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY) == 0) continue;
                            bedrockData.set(ChunkUtils.indexYZXtoXZY(yzx), layer0.idFor(EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY)));
                            EXTENDED_COLLISIONS_STORAGE.get().set(yzx, 0, sectionY);
                        }
                        BlockStorage[] layers2 = new BlockStorage[]{layer0};
                        sections[bedrockSectionY] = new GeyserChunkSection(layers2, subChunkIndex);
                    }
                    EXTENDED_COLLISIONS_STORAGE.get().clear();
                    extendedCollisionNextSection = 0;
                    continue;
                }
                Palette javaPalette = javaSection.getChunkData().getPalette();
                BitStorage javaData = javaSection.getChunkData().getStorage();
                if (javaPalette instanceof GlobalPalette) {
                    GeyserChunkSection section = new GeyserChunkSection(session.getBlockMappings().getBedrockAir().getRuntimeId(), subChunkIndex);
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        Block block;
                        int javaId = javaData.get(yzx);
                        BlockState state = BlockState.of(javaId);
                        int bedrockId = session.getBlockMappings().getBedrockBlockId(javaId);
                        int xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        section.getBlockStorageArray()[0].setFullBlock(xzy, bedrockId);
                        if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(javaId)) {
                            section.getBlockStorageArray()[1].setFullBlock(xzy, session.getBlockMappings().getBedrockWater().getRuntimeId());
                        }
                        if (useExtendedCollisions) {
                            if (EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY) != 0) {
                                if (javaId == 0) {
                                    section.getBlockStorageArray()[0].setFullBlock(xzy, EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY));
                                }
                                EXTENDED_COLLISIONS_STORAGE.get().set(yzx, 0, sectionY);
                                continue;
                            }
                            BlockDefinition aboveBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(javaId);
                            if (aboveBedrockExtendedCollisionDefinition != null) {
                                EXTENDED_COLLISIONS_STORAGE.get().set(yzx + 256 & 0xFFF, aboveBedrockExtendedCollisionDefinition.getRuntimeId(), sectionY);
                                if ((xzy & 0xF) == 15) {
                                    thisExtendedCollisionNextSection = 1;
                                }
                            }
                        }
                        if (!((block = state.block()) instanceof BedrockChunkWantsBlockEntityTag)) continue;
                        BedrockChunkWantsBlockEntityTag blockEntity = (BedrockChunkWantsBlockEntityTag)((Object)block);
                        bedrockBlockEntities.add(blockEntity.createTag(session, Vector3i.from((packet.getX() << 4) + (yzx & 0xF), (sectionY + yOffset << 4) + (yzx >> 8 & 0xF), (packet.getZ() << 4) + (yzx >> 4 & 0xF)), state));
                    }
                    sections[bedrockSectionY] = section;
                    extendedCollisionNextSection = thisExtendedCollisionNextSection;
                    continue;
                }
                if (javaPalette instanceof SingletonPalette) {
                    int javaId = javaPalette.idToState(0);
                    int bedrockId = session.getBlockMappings().getBedrockBlockId(javaId);
                    BlockStorage blockStorage = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton(bedrockId));
                    if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(javaId)) {
                        BlockStorage waterlogged = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton(session.getBlockMappings().getBedrockWater().getRuntimeId()));
                        sections[bedrockSectionY] = new GeyserChunkSection(new BlockStorage[]{blockStorage, waterlogged}, subChunkIndex);
                    } else {
                        sections[bedrockSectionY] = new GeyserChunkSection(new BlockStorage[]{blockStorage}, subChunkIndex);
                    }
                    if (!useExtendedCollisions) continue;
                    EXTENDED_COLLISIONS_STORAGE.get().clear();
                    extendedCollisionNextSection = 0;
                    continue;
                }
                IntArrayList bedrockPalette = new IntArrayList(javaPalette.size());
                int airPaletteId = -1;
                waterloggedPaletteIds.clear();
                bedrockOnlyBlockEntityIds.clear();
                int extendedCollisionsInPalette = 0;
                for (int i2 = 0; i2 < javaPalette.size(); ++i2) {
                    BlockState state;
                    int javaId = javaPalette.idToState(i2);
                    bedrockPalette.add(session.getBlockMappings().getBedrockBlockId(javaId));
                    if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(javaId)) {
                        waterloggedPaletteIds.set(i2);
                    }
                    if (javaId == 0) {
                        airPaletteId = i2;
                    }
                    if (useExtendedCollisions && session.getBlockMappings().getExtendedCollisionBoxes().get(javaId) != null) {
                        extendedCollision = 1;
                        ++extendedCollisionsInPalette;
                    }
                    if (!((state = BlockState.of(javaId)).block() instanceof BedrockChunkWantsBlockEntityTag)) continue;
                    bedrockOnlyBlockEntityIds.set(i2);
                }
                if (!bedrockOnlyBlockEntityIds.isEmpty()) {
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int paletteId = javaData.get(yzx);
                        if (!bedrockOnlyBlockEntityIds.get(paletteId)) continue;
                        BlockState state = BlockState.of(javaPalette.idToState(paletteId));
                        bedrockBlockEntities.add(((BedrockChunkWantsBlockEntityTag)((Object)state.block())).createTag(session, Vector3i.from((packet.getX() << 4) + (yzx & 0xF), (sectionY + yOffset << 4) + (yzx >> 8 & 0xF), (packet.getZ() << 4) + (yzx >> 4 & 0xF)), state));
                    }
                }
                int sectionCollisionBlocks = 0;
                if (useExtendedCollisions) {
                    int bottomLayerCollisions = extendedCollision != 0 ? EXTENDED_COLLISIONS_STORAGE.get().bottomLayerCollisions() : 0;
                    sectionCollisionBlocks = bottomLayerCollisions + extendedCollisionsInPalette;
                }
                int bedrockDataBits = 32 - Integer.numberOfLeadingZeros(javaPalette.size() + sectionCollisionBlocks);
                BitArray bedrockData = BitArrayVersion.forBitsCeil(bedrockDataBits).createArray(4096);
                BlockStorage layer0 = new BlockStorage(bedrockData, bedrockPalette);
                if (waterloggedPaletteIds.isEmpty() && extendedCollision == 0) {
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int paletteId = javaData.get(yzx);
                        xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        bedrockData.set(xzy, paletteId);
                    }
                    layers = new BlockStorage[]{layer0};
                } else if (!waterloggedPaletteIds.isEmpty() && extendedCollision == 0) {
                    int[] layer1Data = new int[128];
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        paletteId = javaData.get(yzx);
                        int xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        bedrockData.set(xzy, paletteId);
                        if (!waterloggedPaletteIds.get(paletteId)) continue;
                        int n = xzy >> 5;
                        layer1Data[n] = layer1Data[n] | 1 << (xzy & 0x1F);
                    }
                    IntList layer1Palette = IntList.of(session.getBlockMappings().getBedrockAir().getRuntimeId(), session.getBlockMappings().getBedrockWater().getRuntimeId());
                    layers = new BlockStorage[]{layer0, new BlockStorage(BitArrayVersion.V1.createArray(4096, layer1Data), layer1Palette)};
                } else if (waterloggedPaletteIds.isEmpty()) {
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        int paletteId = javaData.get(yzx);
                        xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        bedrockData.set(xzy, paletteId);
                        if (EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY) != 0) {
                            if (paletteId == airPaletteId) {
                                bedrockData.set(xzy, layer0.idFor(EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY)));
                            }
                            EXTENDED_COLLISIONS_STORAGE.get().set(yzx, 0, sectionY);
                            continue;
                        }
                        BlockDefinition aboveBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(javaPalette.idToState(paletteId));
                        if (aboveBedrockExtendedCollisionDefinition == null) continue;
                        EXTENDED_COLLISIONS_STORAGE.get().set(yzx + 256 & 0xFFF, aboveBedrockExtendedCollisionDefinition.getRuntimeId(), sectionY);
                        if ((xzy & 0xF) != 15) continue;
                        thisExtendedCollisionNextSection = 1;
                    }
                    layers = new BlockStorage[]{layer0};
                } else {
                    int[] layer1Data = new int[128];
                    for (int yzx = 0; yzx < 4096; ++yzx) {
                        paletteId = javaData.get(yzx);
                        int xzy = ChunkUtils.indexYZXtoXZY(yzx);
                        bedrockData.set(xzy, paletteId);
                        if (waterloggedPaletteIds.get(paletteId)) {
                            int n = xzy >> 5;
                            layer1Data[n] = layer1Data[n] | 1 << (xzy & 0x1F);
                        }
                        if (EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY) != 0) {
                            if (paletteId == airPaletteId) {
                                bedrockData.set(xzy, layer0.idFor(EXTENDED_COLLISIONS_STORAGE.get().get(yzx, sectionY)));
                            }
                            EXTENDED_COLLISIONS_STORAGE.get().set(yzx, 0, sectionY);
                            continue;
                        }
                        BlockDefinition aboveBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(javaPalette.idToState(paletteId));
                        if (aboveBedrockExtendedCollisionDefinition == null) continue;
                        EXTENDED_COLLISIONS_STORAGE.get().set(yzx + 256 & 0xFFF, aboveBedrockExtendedCollisionDefinition.getRuntimeId(), sectionY);
                        if ((xzy & 0xF) != 15) continue;
                        thisExtendedCollisionNextSection = 1;
                    }
                    IntList layer1Palette = IntList.of(session.getBlockMappings().getBedrockAir().getRuntimeId(), session.getBlockMappings().getBedrockWater().getRuntimeId());
                    layers = new BlockStorage[]{layer0, new BlockStorage(BitArrayVersion.V1.createArray(4096, layer1Data), layer1Palette)};
                }
                sections[bedrockSectionY] = new GeyserChunkSection(layers, subChunkIndex);
                extendedCollisionNextSection = thisExtendedCollisionNextSection;
            }
            if (!session.getErosionHandler().isActive()) {
                session.getChunkCache().addToCache(packet.getX(), packet.getZ(), javaChunks);
            }
            int chunkBlockX = packet.getX() << 4;
            int chunkBlockZ = packet.getZ() << 4;
            for (BlockEntityInfo blockEntity : blockEntities) {
                BlockDefinition blockDefinition;
                BlockEntityType type = blockEntity.getType();
                NbtMap tag = blockEntity.getNbt();
                if (type == null) continue;
                int x = blockEntity.getX();
                int y = blockEntity.getY();
                int z = blockEntity.getZ();
                DataPalette section = javaChunks[(y >> 4) - yOffset];
                BlockState blockState = BlockState.of(section.get(x, y & 0xF, z));
                BlockEntityTranslator blockEntityTranslator = BlockEntityUtils.getBlockEntityTranslator(type);
                if (type != blockState.block().blockEntityType()) continue;
                bedrockBlockEntities.add(blockEntityTranslator.getBlockEntityTag(session, type, x + chunkBlockX, y, z + chunkBlockZ, tag, blockState));
                if (!session.getPreferencesCache().showCustomSkulls() || type != BlockEntityType.SKULL || tag == null || !tag.containsKey("profile") || (blockDefinition = SkullBlockEntityTranslator.translateSkull(session, tag, Vector3i.from(x + chunkBlockX, y, z + chunkBlockZ), blockState)) == null) continue;
                int bedrockSectionY = (y >> 4) - (bedrockDimension.minY() >> 4);
                int subChunkIndex = (y >> 4) + (bedrockDimension.minY() >> 4);
                if (0 > bedrockSectionY || bedrockSectionY >= maxBedrockSectionY) continue;
                GeyserChunkSection bedrockSection = sections[bedrockSectionY];
                IntList palette = bedrockSection.getBlockStorageArray()[0].getPalette();
                if (palette instanceof IntImmutableList || palette instanceof IntLists.Singleton) {
                    sections[bedrockSectionY] = bedrockSection = bedrockSection.copy(subChunkIndex);
                }
                bedrockSection.setFullBlock(x, y & 0xF, z, 0, blockDefinition.getRuntimeId());
            }
            for (sectionCount = sections.length - 1; sectionCount >= 0 && sections[sectionCount] == null; --sectionCount) {
            }
            ++sectionCount;
            int biomeCount = bedrockDimension.height() >> 4;
            int size = 0;
            for (i = 0; i < sectionCount; ++i) {
                GeyserChunkSection section = sections[i];
                if (section != null) {
                    size += section.estimateNetworkSize();
                    continue;
                }
                size += ChunkUtils.EMPTY_CHUNK_SECTION_SIZE;
            }
            size += ChunkUtils.EMPTY_BIOME_DATA.length * biomeCount;
            ++size;
            byteBuf = ByteBufAllocator.DEFAULT.ioBuffer(size += bedrockBlockEntities.size() * 64);
            for (i = 0; i < sectionCount; ++i) {
                GeyserChunkSection section = sections[i];
                if (section != null) {
                    section.writeToNetwork(byteBuf);
                    continue;
                }
                int subChunkIndex = i + (bedrockDimension.minY() >> 4);
                new GeyserChunkSection(ChunkUtils.EMPTY_BLOCK_STORAGE, subChunkIndex).writeToNetwork(byteBuf);
            }
            int dimensionOffset = bedrockDimension.minY() >> 4;
            for (int i3 = 0; i3 < biomeCount; ++i3) {
                int biomeYOffset = dimensionOffset + i3;
                if (biomeYOffset < yOffset) {
                    byteBuf.writeBytes(ChunkUtils.EMPTY_BIOME_DATA);
                    continue;
                }
                if (biomeYOffset >= chunkSize + yOffset) {
                    byteBuf.writeByte(255);
                    continue;
                }
                BiomeTranslator.toNewBedrockBiome(session, javaBiomes[i3 + (dimensionOffset - yOffset)]).writeToNetwork(byteBuf);
            }
            byteBuf.writeByte(0);
            NBTOutputStream nbtStream = NbtUtils.createNetworkWriter((OutputStream)new ByteBufOutputStream(byteBuf));
            for (NbtMap blockEntity : bedrockBlockEntities) {
                nbtStream.writeTag(blockEntity);
            }
            payload = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(payload);
        }
        catch (IOException e) {
            session.getGeyser().getLogger().error("IO error while encoding chunk", e);
            return;
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        LevelChunkPacket levelChunkPacket = new LevelChunkPacket();
        levelChunkPacket.setSubChunksLength(sectionCount);
        levelChunkPacket.setCachingEnabled(false);
        levelChunkPacket.setChunkX(packet.getX());
        levelChunkPacket.setChunkZ(packet.getZ());
        levelChunkPacket.setData(Unpooled.wrappedBuffer((byte[])payload));
        levelChunkPacket.setDimension(session.getBedrockDimension().bedrockId());
        session.sendUpstreamPacket(levelChunkPacket);
        for (Map.Entry<Vector3i, ItemFrameEntity> entry : session.getItemFrameCache().entrySet()) {
            Vector3i position = entry.getKey();
            if (position.getX() >> 4 != packet.getX() || position.getZ() >> 4 != packet.getZ()) continue;
            entry.getValue().updateBlock(true);
        }
    }

    static final class ExtendedCollisionsStorage {
        private int[] data;
        private int sectionY;

        ExtendedCollisionsStorage() {
        }

        int get(int index, int sY) {
            if (this.data == null) {
                return 0;
            }
            if (sY != this.sectionY && sY != this.sectionY + 1) {
                this.data = null;
                return 0;
            }
            return this.data[index];
        }

        void set(int index, int value, int sY) {
            this.ensureDataExists();
            this.data[index] = value;
            this.sectionY = sY;
        }

        void clear() {
            this.data = null;
        }

        int bottomLayerCollisions() {
            if (this.data == null) {
                return 0;
            }
            IntOpenHashSet uniqueNonZeroSet = new IntOpenHashSet();
            for (int i = 0; i < 256; ++i) {
                if (this.data[i] == 0) continue;
                uniqueNonZeroSet.add(this.data[i]);
            }
            return uniqueNonZeroSet.size();
        }

        private void ensureDataExists() {
            if (this.data == null) {
                this.data = new int[4096];
            }
        }
    }
}

