/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.CommandSourceConverter;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeConfiguration;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeDumpInfo;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeInjector;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeLogger;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeePingPassthrough;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeUpdateListener;
import org.geysermc.geyser.platform.bungeecord.command.BungeeCommandSource;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.bungee.BungeeCommandManager;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.execution.ExecutionCoordinator;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class GeyserBungeePlugin
extends Plugin
implements GeyserBootstrap {
    private CommandRegistry commandRegistry;
    private GeyserBungeeConfiguration geyserConfig;
    private GeyserBungeeInjector geyserInjector;
    private final GeyserBungeeLogger geyserLogger = new GeyserBungeeLogger(this.getLogger());
    private IGeyserPingPassthrough geyserBungeePingPassthrough;
    private GeyserImpl geyser;

    public void onLoad() {
        this.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        GeyserLocale.init(this);
        try {
            List supportedProtocols = ProtocolConstants.SUPPORTED_VERSION_IDS;
            if (!supportedProtocols.contains(GameProtocol.getJavaProtocolVersion())) {
                this.geyserLogger.error("      / \\");
                this.geyserLogger.error("     /   \\");
                this.geyserLogger.error("    /  |  \\");
                this.geyserLogger.error("   /   |   \\    " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_proxy", this.getProxy().getName()));
                this.geyserLogger.error("  /         \\   " + GeyserLocale.getLocaleStringLog("geyser.may_not_work_as_intended_all_caps"));
                this.geyserLogger.error(" /     o     \\");
                this.geyserLogger.error("/_____________\\");
            }
        }
        catch (Throwable e) {
            this.geyserLogger.warning("Unable to check the versions supported by this proxy! " + e.getMessage());
        }
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.geyser = GeyserImpl.load(PlatformType.BUNGEECORD, this);
        this.geyserInjector = new GeyserBungeeInjector(this);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new GeyserBungeeUpdateListener());
    }

    public void onEnable() {
        if (this.geyser == null) {
            return;
        }
        CommandSourceConverter<CommandSender> sourceConverter = new CommandSourceConverter<CommandSender>(CommandSender.class, id -> this.getProxy().getPlayer(id), () -> this.getProxy().getConsole(), BungeeCommandSource::new);
        BungeeCommandManager<GeyserCommandSource> cloud = new BungeeCommandManager<GeyserCommandSource>(this, ExecutionCoordinator.simpleCoordinator(), sourceConverter);
        this.commandRegistry = new CommandRegistry(this.geyser, cloud, false);
        this.awaitStartupCompletion(0);
    }

    private void awaitStartupCompletion(int tries) {
        if (tries >= 20) {
            this.geyserLogger.warning("BungeeCord plugin startup is taking abnormally long, so Geyser is starting now. If all your plugins are loaded properly, this is a bug! If not, consider cutting down the amount of plugins on your proxy as it is causing abnormally slow starting times.");
            this.onGeyserEnable();
            return;
        }
        try {
            Field listenersField = BungeeCord.getInstance().getClass().getDeclaredField("listeners");
            listenersField.setAccessible(true);
            Collection listeners = (Collection)listenersField.get(BungeeCord.getInstance());
            if (listeners.isEmpty()) {
                this.getProxy().getScheduler().schedule((Plugin)this, this::onGeyserEnable, (long)tries, TimeUnit.SECONDS);
            } else {
                this.awaitStartupCompletion(++tries);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onGeyserEnable() {
        if (GeyserImpl.getInstance().isReloading()) {
            if (!this.loadConfig()) {
                return;
            }
            this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
            GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        }
        for (ListenerInfo info : this.getProxy().getConfig().getListeners()) {
            if (!info.isQueryEnabled() || info.getQueryPort() != this.geyserConfig.getBedrock().port()) continue;
            try {
                Field queryField = ListenerInfo.class.getDeclaredField("queryEnabled");
                queryField.setAccessible(true);
                queryField.setBoolean(info, false);
                this.geyserLogger.warning("We force-disabled query on port " + info.getQueryPort() + " in order for Geyser to boot up successfully. To remove this message, disable query in your proxy's config.");
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.geyserLogger.warning("Could not force-disable query. Geyser may not start correctly!");
                if (!this.geyserLogger.isDebug()) continue;
                e.printStackTrace();
            }
        }
        GeyserImpl.start();
        this.geyserBungeePingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : new GeyserBungeePingPassthrough(this.getProxy());
        if (GeyserImpl.getInstance().isReloading()) {
            return;
        }
        this.geyserInjector.initializeLocalChannel(this);
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
        }
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @Override
    public GeyserBungeeConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserBungeeLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserBungeePingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserBungeeDumpInfo(this.getProxy());
    }

    @Override
    public Path getLogsPath() {
        return Paths.get(this.getProxy().getName().equals("BungeeCord") ? "proxy.log.0" : "logs/latest.log", new String[0]);
    }

    @Override
    public @Nullable SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        return this.findCompatibleListener().map(InetSocketAddress::getHostString).orElse("");
    }

    @Override
    public int getServerPort() {
        return this.findCompatibleListener().stream().mapToInt(InetSocketAddress::getPort).findFirst().orElse(-1);
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        if (this.getProxy().getPluginManager().getPlugin("floodgate") != null) {
            this.geyserConfig.loadFloodgate(this);
            return true;
        }
        return false;
    }

    private Optional<InetSocketAddress> findCompatibleListener() {
        return this.getProxy().getConfig().getListeners().stream().filter(info -> info.getSocketAddress() instanceof InetSocketAddress).map(info -> (InetSocketAddress)info.getSocketAddress()).findFirst();
    }

    private boolean loadConfig() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(new File(this.getDataFolder(), "config.yml"), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserBungeeConfiguration.class);
        }
        catch (IOException ex) {
            this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

