/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.VectorNi;
import org.cloudburstmc.math.vector.Vectori;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector3i
implements Vectori,
Comparable<Vector3i>,
Serializable,
Cloneable {
    public static final Vector3i ZERO = Vector3i.from(0, 0, 0);
    public static final Vector3i UNIT_X = Vector3i.from(1, 0, 0);
    public static final Vector3i UNIT_Y = Vector3i.from(0, 1, 0);
    public static final Vector3i UNIT_Z = Vector3i.from(0, 0, 1);
    public static final Vector3i ONE = Vector3i.from(1, 1, 1);
    public static final Vector3i RIGHT = UNIT_X;
    public static final Vector3i UP = UNIT_Y;
    public static final Vector3i FORWARD = UNIT_Z;

    public abstract int getX();

    public abstract int getY();

    public abstract int getZ();

    @Nonnull
    public Vector3i add(Vector3i v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i add(double x, double y, double z) {
        return this.add(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i add(int var1, int var2, int var3);

    @Nonnull
    public Vector3i sub(Vector3i v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i sub(double x, double y, double z) {
        return this.sub(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i sub(int var1, int var2, int var3);

    @Nonnull
    public Vector3i mul(double a) {
        return this.mul(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector3i mul(int a) {
        return this.mul(a, a, a);
    }

    @Nonnull
    public Vector3i mul(Vector3i v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i mul(double x, double y, double z) {
        return this.mul(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i mul(int var1, int var2, int var3);

    @Nonnull
    public Vector3i div(double a) {
        return this.div(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector3i div(int a) {
        return this.div(a, a, a);
    }

    @Nonnull
    public Vector3i div(Vector3i v) {
        return this.div(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i div(double x, double y, double z) {
        return this.div(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i div(int var1, int var2, int var3);

    public int dot(Vector3i v) {
        return this.dot(v.getX(), v.getY(), v.getZ());
    }

    public int dot(double x, double y, double z) {
        return this.dot(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    public int dot(int x, int y, int z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    @Nonnull
    public Vector3i project(Vector3i v) {
        return this.project(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i project(double x, double y, double z) {
        return this.project(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i project(int var1, int var2, int var3);

    @Nonnull
    public Vector3i cross(Vector3i v) {
        return this.cross(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i cross(double x, double y, double z) {
        return this.cross(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i cross(int var1, int var2, int var3);

    @Nonnull
    public Vector3i pow(double pow) {
        return this.pow(GenericMath.floor(pow));
    }

    @Override
    @Nonnull
    public abstract Vector3i pow(int var1);

    @Override
    @Nonnull
    public abstract Vector3i abs();

    @Override
    @Nonnull
    public abstract Vector3i negate();

    @Nonnull
    public Vector3i min(Vector3i v) {
        return this.min(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i min(double x, double y, double z) {
        return this.min(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i min(int var1, int var2, int var3);

    @Nonnull
    public Vector3i max(Vector3i v) {
        return this.max(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3i max(double x, double y, double z) {
        return this.max(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public abstract Vector3i max(int var1, int var2, int var3);

    public int distanceSquared(Vector3i v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ());
    }

    public int distanceSquared(double x, double y, double z) {
        return this.distanceSquared(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    public int distanceSquared(int x, int y, int z) {
        int dx = this.getX() - x;
        int dy = this.getY() - y;
        int dz = this.getZ() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distance(Vector3i v) {
        return this.distance(v.getX(), v.getY(), v.getZ());
    }

    public float distance(double x, double y, double z) {
        return this.distance(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    public float distance(int x, int y, int z) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Nonnull
    public Vector3i up() {
        return this.up(1);
    }

    @Nonnull
    public abstract Vector3i up(int var1);

    @Nonnull
    public Vector3i down() {
        return this.down(1);
    }

    @Nonnull
    public abstract Vector3i down(int var1);

    @Nonnull
    public Vector3i north() {
        return this.north(1);
    }

    @Nonnull
    public abstract Vector3i north(int var1);

    @Nonnull
    public Vector3i south() {
        return this.south(1);
    }

    @Nonnull
    public abstract Vector3i south(int var1);

    @Nonnull
    public Vector3i east() {
        return this.east(1);
    }

    @Nonnull
    public abstract Vector3i east(int var1);

    @Nonnull
    public Vector3i west() {
        return this.west(1);
    }

    @Nonnull
    public abstract Vector3i west(int var1);

    @Override
    public int lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? (this.getX() < this.getZ() ? 0 : 2) : (this.getY() < this.getZ() ? 1 : 2);
    }

    @Override
    public int getMaxAxis() {
        return this.getX() < this.getY() ? (this.getY() < this.getZ() ? 2 : 1) : (this.getX() < this.getZ() ? 2 : 0);
    }

    @Nonnull
    public Vector2i toVector2() {
        return Vector2i.from(this);
    }

    @Nonnull
    public Vector2i toVector2(boolean useZ) {
        return Vector2i.from(this.getX(), useZ ? this.getZ() : this.getY());
    }

    @Nonnull
    public Vector4i toVector4() {
        return this.toVector4(0);
    }

    @Nonnull
    public Vector4i toVector4(double w) {
        return this.toVector4(GenericMath.floor(w));
    }

    @Nonnull
    public Vector4i toVector4(int w) {
        return Vector4i.from(this, w);
    }

    @Nonnull
    public VectorNi toVectorN() {
        return VectorNi.from(this);
    }

    @Override
    @Nonnull
    public int[] toArray() {
        return new int[]{this.getX(), this.getY(), this.getZ()};
    }

    @Override
    @Nonnull
    public Vector3i toInt() {
        return Vector3i.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3l toLong() {
        return Vector3l.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f toFloat() {
        return Vector3f.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d toDouble() {
        return Vector3d.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int compareTo(Vector3i v) {
        return this.lengthSquared() - v.lengthSquared();
    }

    @Nonnull
    public Vector3i clone() {
        return Vector3i.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    @Nonnull
    public static Vector3i from(int n) {
        return Vectors.createVector3i(n, n, n);
    }

    @Nonnull
    public static Vector3i from(Vector2i v) {
        return Vector3i.from(v, 0);
    }

    @Nonnull
    public static Vector3i from(Vector2i v, double z) {
        return Vector3i.from(v, GenericMath.floor(z));
    }

    @Nonnull
    public static Vector3i from(Vector2i v, int z) {
        return Vector3i.from(v.getX(), v.getY(), z);
    }

    @Nonnull
    public static Vector3i from(Vector3i v) {
        return Vector3i.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3i from(Vector4i v) {
        return Vector3i.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3i from(VectorNi v) {
        return Vector3i.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0);
    }

    @Nonnull
    public static Vector3i from(double x, double y, double z) {
        return Vector3i.from(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z));
    }

    @Nonnull
    public static Vector3i from(int x, int y, int z) {
        return Vectors.createVector3i(x, y, z);
    }
}

