/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.versions;

import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;

public abstract class MappingsReader {
    public abstract void readItemMappings(Path var1, JsonNode var2, BiConsumer<String, CustomItemData> var3);

    public abstract void readBlockMappings(Path var1, JsonNode var2, BiConsumer<String, CustomBlockMapping> var3);

    public abstract CustomItemData readItemMappingEntry(JsonNode var1) throws InvalidCustomMappingsFileException;

    public abstract CustomBlockMapping readBlockMappingEntry(String var1, JsonNode var2) throws InvalidCustomMappingsFileException;

    protected @Nullable CustomRenderOffsets fromJsonNode(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        return new CustomRenderOffsets(this.getHandOffsets(node, "main_hand"), this.getHandOffsets(node, "off_hand"));
    }

    protected @Nullable CustomRenderOffsets.Hand getHandOffsets(JsonNode node, String hand) {
        JsonNode tmpNode = node.get(hand);
        if (tmpNode == null || !tmpNode.isObject()) {
            return null;
        }
        return new CustomRenderOffsets.Hand(this.getPerspectiveOffsets(tmpNode, "first_person"), this.getPerspectiveOffsets(tmpNode, "third_person"));
    }

    protected @Nullable CustomRenderOffsets.Offset getPerspectiveOffsets(JsonNode node, String perspective) {
        JsonNode tmpNode = node.get(perspective);
        if (tmpNode == null || !tmpNode.isObject()) {
            return null;
        }
        return new CustomRenderOffsets.Offset(this.getOffsetXYZ(tmpNode, "position"), this.getOffsetXYZ(tmpNode, "rotation"), this.getOffsetXYZ(tmpNode, "scale"));
    }

    protected @Nullable CustomRenderOffsets.OffsetXYZ getOffsetXYZ(JsonNode node, String offsetType) {
        JsonNode tmpNode = node.get(offsetType);
        if (tmpNode == null || !tmpNode.isObject()) {
            return null;
        }
        if (!(tmpNode.has("x") && tmpNode.has("y") && tmpNode.has("z"))) {
            return null;
        }
        return new CustomRenderOffsets.OffsetXYZ(tmpNode.get("x").floatValue(), tmpNode.get("y").floatValue(), tmpNode.get("z").floatValue());
    }
}

