/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.sound;

import java.util.Map;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.sound.SoundInteractionTranslator;
import org.geysermc.geyser.translator.sound.SoundTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public interface BlockSoundInteractionTranslator
extends SoundInteractionTranslator<BlockState> {
    public static void handleBlockInteraction(GeyserSession session, Vector3f position, BlockState state) {
        String handIdentifier = null;
        for (Map.Entry interactionEntry : ((Map)Registries.SOUND_TRANSLATORS.get()).entrySet()) {
            if (!(interactionEntry.getValue() instanceof BlockSoundInteractionTranslator)) continue;
            if (((SoundTranslator)interactionEntry.getKey()).blocks().length != 0) {
                boolean contains = false;
                for (String blockIdentifier : ((SoundTranslator)interactionEntry.getKey()).blocks()) {
                    if (!state.toString().contains(blockIdentifier)) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
            }
            GeyserItemStack itemInHand = session.getPlayerInventory().getItemInHand();
            if (((SoundTranslator)interactionEntry.getKey()).items().length != 0) {
                if (itemInHand.isEmpty()) continue;
                if (handIdentifier == null) {
                    handIdentifier = itemInHand.asItem().javaIdentifier();
                }
                boolean contains = false;
                for (String itemIdentifier : ((SoundTranslator)interactionEntry.getKey()).items()) {
                    if (!handIdentifier.contains(itemIdentifier)) continue;
                    contains = true;
                    break;
                }
                if (!contains) continue;
            }
            if (session.isSneaking() && !((SoundTranslator)interactionEntry.getKey()).ignoreSneakingWhileHolding() && !itemInHand.isEmpty()) continue;
            ((BlockSoundInteractionTranslator)interactionEntry.getValue()).translate(session, position, state);
        }
    }

    public static boolean canInteract(GeyserSession session, GeyserItemStack itemInHand, String blockIdentifier) {
        if (session.getGameMode() != GameMode.ADVENTURE) {
            return true;
        }
        AdventureModePredicate canPlaceOn = itemInHand.getComponent(DataComponentTypes.CAN_PLACE_ON);
        if (canPlaceOn == null || canPlaceOn.getPredicates().isEmpty()) {
            return true;
        }
        for (AdventureModePredicate.BlockPredicate blockPredicate : canPlaceOn.getPredicates()) {
        }
        return false;
    }
}

