/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.raphimc.minecraftauth.responsehandler.exception.MinecraftRequestException;
import net.raphimc.minecraftauth.step.BiMergeStep;
import net.raphimc.minecraftauth.step.java.StepMCProfile;
import net.raphimc.minecraftauth.step.java.StepMCToken;
import net.raphimc.minecraftauth.step.java.session.StepFullJavaSession;
import net.raphimc.minecraftauth.util.logging.ILogger;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.AbilityLayer;
import org.cloudburstmc.protocol.bedrock.data.AuthoritativeMovementMode;
import org.cloudburstmc.protocol.bedrock.data.ChatRestrictionLevel;
import org.cloudburstmc.protocol.bedrock.data.ExperimentData;
import org.cloudburstmc.protocol.bedrock.data.GamePublishSetting;
import org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.SpawnBiomeType;
import org.cloudburstmc.protocol.bedrock.data.biome.BiomeDefinitions;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.cloudburstmc.protocol.bedrock.data.command.SoftEnumUpdateType;
import org.cloudburstmc.protocol.bedrock.data.definitions.DimensionDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.CraftingRecipeData;
import org.cloudburstmc.protocol.bedrock.packet.AvailableEntityIdentifiersPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BiomeDefinitionListPacket;
import org.cloudburstmc.protocol.bedrock.packet.CameraPresetsPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundCloseFormPacket;
import org.cloudburstmc.protocol.bedrock.packet.CreativeContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.DimensionDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.EmoteListPacket;
import org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemComponentPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetCommandsEnabledPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTimePacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.bedrock.packet.SyncEntityPropertyPacket;
import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.cloudburstmc.protocol.bedrock.packet.TransferPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAbilitiesPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAdventureSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateClientInputLocksPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateSoftEnumPacket;
import org.cloudburstmc.protocol.common.DefinitionRegistry;
import org.cloudburstmc.protocol.common.util.OptionalBoolean;
import org.geysermc.api.util.BedrockPlatform;
import org.geysermc.api.util.InputMode;
import org.geysermc.api.util.UiProfile;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.bedrock.camera.CameraData;
import org.geysermc.geyser.api.bedrock.camera.CameraShake;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.entity.EntityData;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.GeyserEntityData;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.erosion.AbstractGeyserboundPacketHandler;
import org.geysermc.geyser.erosion.ErosionCancellationException;
import org.geysermc.geyser.erosion.GeyserboundHandshakePacketHandler;
import org.geysermc.geyser.event.type.SessionDisconnectEventImpl;
import org.geysermc.geyser.impl.camera.CameraDefinitions;
import org.geysermc.geyser.impl.camera.GeyserCameraData;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserSmithingRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.physics.CollisionManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.DownstreamSession;
import org.geysermc.geyser.session.GeyserSessionAdapter;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.UpstreamSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.session.cache.AdvancementsCache;
import org.geysermc.geyser.session.cache.BookEditCache;
import org.geysermc.geyser.session.cache.BundleCache;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.session.cache.EntityCache;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.session.cache.FormCache;
import org.geysermc.geyser.session.cache.InputCache;
import org.geysermc.geyser.session.cache.LodestoneCache;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.session.cache.PreferencesCache;
import org.geysermc.geyser.session.cache.RegistryCache;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.session.cache.StructureBlockCache;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.session.cache.WorldBorder;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.geyser.util.MinecraftAuthLogger;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.ClientSession;
import org.geysermc.mcprotocollib.network.event.session.SessionListener;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.session.ClientNetworkSession;
import org.geysermc.mcprotocollib.protocol.ClientListener;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.HandPreference;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.setting.ChatVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.setting.ParticleStatus;
import org.geysermc.mcprotocollib.protocol.data.game.setting.SkinPart;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CustomStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.Statistic;
import org.geysermc.mcprotocollib.protocol.data.handshake.HandshakeIntent;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundClientInformationPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundChatCommandSignedPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundChatPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundClientTickEndPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundCustomQueryAnswerPacket;

public class GeyserSession
implements GeyserConnection,
GeyserCommandSource {
    private static final Gson GSON = new Gson();
    private final GeyserImpl geyser;
    private final UpstreamSession upstream;
    private DownstreamSession downstream;
    private final EventLoop tickEventLoop;
    private AuthData authData;
    private BedrockClientData clientData;
    private List<String> certChainData;
    private volatile @NonNull AbstractGeyserboundPacketHandler erosionHandler;
    private RemoteServer remoteServer;
    private final SessionPlayerEntity playerEntity;
    private final AdvancementsCache advancementsCache;
    private final BookEditCache bookEditCache;
    private final BundleCache bundleCache;
    private final ChunkCache chunkCache;
    private final EntityCache entityCache;
    private final EntityEffectCache effectCache;
    private final FormCache formCache;
    private final InputCache inputCache;
    private final LodestoneCache lodestoneCache;
    private final PistonCache pistonCache;
    private final PreferencesCache preferencesCache;
    private final RegistryCache registryCache;
    private final SkullCache skullCache;
    private final StructureBlockCache structureBlockCache;
    private final TagCache tagCache;
    private final WorldCache worldCache;
    private TeleportCache unconfirmedTeleport;
    private final WorldBorder worldBorder;
    private boolean isInWorldBorderWarningArea = false;
    private final InventoryHolder<PlayerInventory> playerInventoryHolder;
    private @Nullable InventoryHolder<? extends Inventory> inventoryHolder;
    private boolean closingInventory;
    private int pendingOrCurrentBedrockInventoryId = -1;
    private final AtomicInteger itemNetId = new AtomicInteger(2);
    private ScheduledFuture<?> containerOutputFuture;
    private final CollisionManager collisionManager;
    private BlockMappings blockMappings;
    private ItemMappings itemMappings;
    private final Map<Vector3i, ItemFrameEntity> itemFrameCache = new Object2ObjectOpenHashMap();
    private final Map<UUID, GameProfile> playerWithCustomHeads = new Object2ObjectOpenHashMap();
    private boolean droppingLecternBook;
    private Vector2i lastChunkPosition = null;
    private int clientRenderDistance = -1;
    private int serverRenderDistance = -1;
    protected boolean sentSpawnPacket;
    boolean loggedIn;
    boolean loggingIn;
    private boolean spawned;
    private volatile boolean closed;
    private GameMode gameMode = GameMode.SURVIVAL;
    private Key worldName = null;
    private String[] levels;
    private boolean sneaking;
    private Pose pose = Pose.STANDING;
    private boolean sprinting;
    private BedrockDimension bedrockOverworldDimension = BedrockDimension.OVERWORLD;
    private @MonotonicNonNull JavaDimension dimensionType = null;
    private BedrockDimension bedrockDimension = this.bedrockOverworldDimension;
    private int breakingBlock;
    private Vector3i lastBlockPlacePosition;
    private BlockItem lastBlockPlaced;
    private boolean interacting;
    private Vector3i lastInteractionBlockPosition = Vector3i.ZERO;
    private Vector3f lastInteractionPlayerPosition = Vector3f.ZERO;
    private Entity mouseoverEntity;
    private final Int2ObjectMap<List<String>> javaToBedrockRecipeIds;
    private final Int2ObjectMap<GeyserRecipe> craftingRecipes;
    private Pair<CraftingRecipeData, GeyserRecipe> lastCreatedRecipe = null;
    private final AtomicInteger lastRecipeNetId;
    private Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes;
    private final List<GeyserSmithingRecipe> smithingRecipes = new ArrayList<GeyserSmithingRecipe>();
    private boolean emulatePost1_13Logic = true;
    private boolean emulatePost1_16Logic = true;
    private boolean emulatePost1_18Logic = true;
    private boolean oldSmithingTable = false;
    private boolean isUsingExperimentalMinecartLogic = false;
    private double attackSpeed = 4.0;
    private long lastHitTime;
    private boolean steeringLeft;
    private boolean steeringRight;
    private long lastInteractionTime;
    private long blockBreakStartTime;
    private boolean placedBucket;
    private int armAnimationTicks = -1;
    private int lastAirHitTick;
    private boolean daylightCycle = true;
    private boolean reducedDebugInfo = false;
    private int opPermissionLevel = 0;
    private boolean canFly = false;
    private boolean flying = false;
    private boolean instabuild = false;
    private float flySpeed;
    private float walkSpeed;
    private float rainStrength = 0.0f;
    private float thunderStrength = 0.0f;
    private final Object2IntMap<Statistic> statistics = new Object2IntOpenHashMap(0);
    private boolean waitingForStatistics = false;
    private final Set<UUID> emotes;
    private boolean advancedTooltips = false;
    private ScheduledFuture<?> tickThread = null;
    private int ticks;
    private long worldTicks;
    private ScheduledFuture<?> lookBackScheduledFuture = null;
    private ScheduledFuture<?> mountVehicleScheduledFuture = null;
    private final Queue<Long> keepAliveCache = new ConcurrentLinkedQueue<Long>();
    private @Nullable ItemData currentBook = null;
    private Map<String, byte[]> cookies = new Object2ObjectOpenHashMap();
    private final GeyserCameraData cameraData;
    private final GeyserEntityData entityData;
    private MinecraftProtocol protocol;
    private int nanosecondsPerTick = 50000000;
    private float millisecondsPerTick = 50.0f;
    private boolean tickingFrozen = false;
    private int stepTicks = 0;
    private static final Ability[] USED_ABILITIES = Ability.values();
    private static final List<SkinPart> SKIN_PARTS = Arrays.asList(SkinPart.values());

    public GeyserSession(GeyserImpl geyser, BedrockServerSession bedrockServerSession, EventLoop tickEventLoop) {
        this.geyser = geyser;
        this.upstream = new UpstreamSession(bedrockServerSession);
        this.tickEventLoop = tickEventLoop;
        this.erosionHandler = new GeyserboundHandshakePacketHandler(this);
        this.advancementsCache = new AdvancementsCache(this);
        this.bookEditCache = new BookEditCache(this);
        this.bundleCache = new BundleCache(this);
        this.chunkCache = new ChunkCache(this);
        this.entityCache = new EntityCache(this);
        this.effectCache = new EntityEffectCache();
        this.formCache = new FormCache(this);
        this.inputCache = new InputCache(this);
        this.lodestoneCache = new LodestoneCache();
        this.pistonCache = new PistonCache(this);
        this.preferencesCache = new PreferencesCache(this);
        this.registryCache = new RegistryCache(this);
        this.skullCache = new SkullCache(this);
        this.structureBlockCache = new StructureBlockCache();
        this.tagCache = new TagCache(this);
        this.worldCache = new WorldCache(this);
        this.cameraData = new GeyserCameraData(this);
        this.entityData = new GeyserEntityData(this);
        this.worldBorder = new WorldBorder(this);
        this.collisionManager = new CollisionManager(this);
        this.playerEntity = new SessionPlayerEntity(this);
        this.collisionManager.updatePlayerBoundingBox(this.playerEntity.getPosition());
        this.playerInventoryHolder = new InventoryHolder(this, new PlayerInventory(this), InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
        this.inventoryHolder = null;
        this.craftingRecipes = new Int2ObjectOpenHashMap();
        this.javaToBedrockRecipeIds = new Int2ObjectOpenHashMap();
        this.lastRecipeNetId = new AtomicInteger(InventoryUtils.LAST_RECIPE_NET_ID + 1);
        this.spawned = false;
        this.loggedIn = false;
        if (geyser.getConfig().getEmoteOffhandWorkaround() != EmoteOffhandWorkaroundOption.NO_EMOTES) {
            this.emotes = new HashSet<UUID>();
            geyser.getSessionManager().getSessions().values().forEach(player -> this.emotes.addAll(player.getEmotes()));
        } else {
            this.emotes = null;
        }
        this.remoteServer = geyser.defaultRemoteServer();
    }

    public void connect() {
        int minY = BedrockDimension.OVERWORLD.minY();
        int maxY = BedrockDimension.OVERWORLD.maxY();
        for (JavaDimension javaDimension : this.registryCache.registry(JavaRegistries.DIMENSION_TYPE).values()) {
            if (javaDimension.bedrockId() != 0) continue;
            minY = Math.min(minY, javaDimension.minY());
            maxY = Math.max(maxY, javaDimension.minY() + javaDimension.height());
        }
        minY = Math.max(minY, -512);
        maxY = Math.min(maxY, 512);
        if (minY < BedrockDimension.OVERWORLD.minY() || maxY > BedrockDimension.OVERWORLD.maxY()) {
            boolean isInOverworld = this.bedrockDimension == this.bedrockOverworldDimension;
            this.bedrockOverworldDimension = new BedrockDimension(minY, maxY - minY, true, 0);
            if (isInOverworld) {
                this.bedrockDimension = this.bedrockOverworldDimension;
            }
            this.geyser.getLogger().debug("Extending overworld dimension to " + minY + " - " + maxY);
            DimensionDataPacket dimensionDataPacket = new DimensionDataPacket();
            dimensionDataPacket.getDefinitions().add(new DimensionDefinition("minecraft:overworld", maxY, minY, 5));
            this.upstream.sendPacket((BedrockPacket)dimensionDataPacket);
        }
        this.startGame();
        this.sentSpawnPacket = true;
        this.syncEntityProperties();
        if (GameProtocol.isPreCreativeInventoryRewrite(this.protocolVersion())) {
            componentPacket = new ItemComponentPacket();
            componentPacket.getItems().addAll(this.itemMappings.getComponentItemData());
            this.upstream.sendPacket((BedrockPacket)componentPacket);
        } else {
            componentPacket = new ItemComponentPacket();
            componentPacket.getItems().addAll(this.itemMappings.getItemDefinitions().values());
            this.upstream.sendPacket((BedrockPacket)componentPacket);
        }
        ChunkUtils.sendEmptyChunks(this, this.playerEntity.getPosition().toInt(), 0, false);
        if (GameProtocol.is1_21_80orHigher(this)) {
            biomeDefinitionListPacket = new BiomeDefinitionListPacket();
            biomeDefinitionListPacket.setBiomes((BiomeDefinitions)Registries.BIOMES.get());
            this.upstream.sendPacket((BedrockPacket)biomeDefinitionListPacket);
        } else {
            biomeDefinitionListPacket = new BiomeDefinitionListPacket();
            biomeDefinitionListPacket.setDefinitions((NbtMap)Registries.BIOMES_NBT.get());
            this.upstream.sendPacket((BedrockPacket)biomeDefinitionListPacket);
        }
        AvailableEntityIdentifiersPacket entityPacket = new AvailableEntityIdentifiersPacket();
        entityPacket.setIdentifiers((NbtMap)Registries.BEDROCK_ENTITY_IDENTIFIERS.get());
        this.upstream.sendPacket((BedrockPacket)entityPacket);
        CameraPresetsPacket cameraPresetsPacket = new CameraPresetsPacket();
        cameraPresetsPacket.getPresets().addAll(CameraDefinitions.CAMERA_PRESETS);
        this.upstream.sendPacket((BedrockPacket)cameraPresetsPacket);
        CreativeContentPacket creativePacket = new CreativeContentPacket();
        creativePacket.getContents().addAll(this.itemMappings.getCreativeItems());
        creativePacket.getGroups().addAll(this.itemMappings.getCreativeItemGroups());
        this.upstream.sendPacket((BedrockPacket)creativePacket);
        PlayStatusPacket playStatusPacket = new PlayStatusPacket();
        playStatusPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
        this.upstream.sendPacket((BedrockPacket)playStatusPacket);
        SetCommandsEnabledPacket setCommandsEnabledPacket = new SetCommandsEnabledPacket();
        setCommandsEnabledPacket.setCommandsEnabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        this.upstream.sendPacket((BedrockPacket)setCommandsEnabledPacket);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.getPlayerEntity().getGeyserId());
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.MOVEMENT_SPEED.getAttribute()));
        this.upstream.sendPacket((BedrockPacket)attributesPacket);
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData("naturalregeneration", (Object)false));
        gamerulePacket.getGameRules().add(new GameRuleData("keepinventory", (Object)true));
        gamerulePacket.getGameRules().add(new GameRuleData("spawnradius", (Object)0));
        gamerulePacket.getGameRules().add(new GameRuleData("recipesunlock", (Object)true));
        this.upstream.sendPacket((BedrockPacket)gamerulePacket);
    }

    public void authenticate(String username) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", username));
            return;
        }
        this.loggingIn = true;
        this.protocol = new MinecraftProtocol(username.replace(' ', '_'));
        try {
            this.connectDownstream();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void authenticateWithAuthChain(String authChain) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        CompletableFuture.supplyAsync(() -> {
            StepFullJavaSession.FullJavaSession response;
            StepFullJavaSession step = PendingMicrosoftAuthentication.AUTH_FLOW.apply(true, 30);
            try {
                response = (StepFullJavaSession.FullJavaSession)step.refresh((ILogger)MinecraftAuthLogger.INSTANCE, PendingMicrosoftAuthentication.AUTH_CLIENT, (BiMergeStep.StepResult)((StepFullJavaSession.FullJavaSession)step.fromJson((JsonObject)GSON.fromJson(authChain, JsonObject.class))));
            }
            catch (Exception e) {
                this.geyser.getLogger().error("Error while attempting to use auth chain for " + this.bedrockUsername() + "!", e);
                return Boolean.FALSE;
            }
            StepMCProfile.MCProfile mcProfile = response.getMcProfile();
            StepMCToken.MCToken mcToken = mcProfile.getMcToken();
            this.protocol = new MinecraftProtocol(new GameProfile(mcProfile.getId(), mcProfile.getName()), mcToken.getAccessToken());
            this.geyser.saveAuthChain(this.bedrockUsername(), GSON.toJson((JsonElement)step.toJson((BiMergeStep.StepResult)response)));
            return Boolean.TRUE;
        }).whenComplete((successful, ex) -> {
            if (this.closed) {
                return;
            }
            if (successful == Boolean.FALSE) {
                this.connect();
                LoginEncryptionUtils.buildAndShowTokenExpiredWindow(this);
                return;
            }
            try {
                this.connectDownstream();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public void authenticateWithMicrosoftCode() {
        this.authenticateWithMicrosoftCode(false);
    }

    public void authenticateWithMicrosoftCode(boolean offlineAccess) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        SetTimePacket packet = new SetTimePacket();
        packet.setTime(16000);
        this.sendUpstreamPacket((BedrockPacket)packet);
        PendingMicrosoftAuthentication.AuthenticationTask task = this.geyser.getPendingMicrosoftAuthentication().getOrCreateTask(this.getAuthData().xuid());
        if (task.getAuthentication() != null && task.getAuthentication().isDone()) {
            this.onMicrosoftLoginComplete(task);
        } else {
            task.resetRunningFlow();
            task.performLoginAttempt(offlineAccess, code -> {
                if (!this.closed) {
                    LoginEncryptionUtils.buildAndShowMicrosoftCodeWindow(this, code);
                }
            }).handle((r, e) -> this.onMicrosoftLoginComplete(task));
        }
    }

    public boolean onMicrosoftLoginComplete(PendingMicrosoftAuthentication.AuthenticationTask task) {
        if (this.closed) {
            return false;
        }
        task.cleanup();
        return ((CompletableFuture)task.getAuthentication().handle((result, ex) -> {
            if (ex != null) {
                MinecraftRequestException mre;
                CompletionException ce;
                Throwable patt39499$temp;
                this.geyser.getLogger().error("Failed to log in with Microsoft code!", (Throwable)ex);
                if (ex instanceof CompletionException && (patt39499$temp = (ce = (CompletionException)ex).getCause()) instanceof MinecraftRequestException && (mre = (MinecraftRequestException)patt39499$temp).getResponse().getStatusCode() == 404) {
                    this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.network.remote.invalid_account", this.locale()));
                } else {
                    this.disconnect(ex.toString());
                }
                return false;
            }
            StepMCProfile.MCProfile mcProfile = result.session().getMcProfile();
            StepMCToken.MCToken mcToken = mcProfile.getMcToken();
            this.protocol = new MinecraftProtocol(new GameProfile(mcProfile.getId(), mcProfile.getName()), mcToken.getAccessToken());
            try {
                this.connectDownstream();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
            this.geyser.saveAuthChain(this.bedrockUsername(), GSON.toJson((JsonElement)result.step().toJson((BiMergeStep.StepResult)result.session())));
            return true;
        })).getNow(false);
    }

    private void connectDownstream() {
        LocalSession downstream;
        SessionLoginEvent loginEvent = new SessionLoginEvent(this, this.remoteServer, (Map<String, byte[]>)new Object2ObjectOpenHashMap());
        GeyserImpl.getInstance().eventBus().fire(loginEvent);
        if (loginEvent.isCancelled()) {
            String disconnectReason = loginEvent.disconnectReason() == null ? "disconnect.disconnected" : loginEvent.disconnectReason();
            this.disconnect(disconnectReason);
            return;
        }
        this.cookies = loginEvent.cookies();
        this.remoteServer = loginEvent.remoteServer();
        this.tickThread = this.tickEventLoop.scheduleAtFixedRate(this::tick, (long)this.nanosecondsPerTick, (long)this.nanosecondsPerTick, TimeUnit.NANOSECONDS);
        if (this.geyser.getBootstrap().getSocketAddress() != null) {
            downstream = new LocalSession(this.geyser.getBootstrap().getSocketAddress(), this.upstream.getAddress().getAddress().getHostAddress(), this.protocol, (Executor)this.tickEventLoop);
            downstream.setFlag(MinecraftConstants.CLIENT_HOST, this.remoteServer.address());
            downstream.setFlag(MinecraftConstants.CLIENT_PORT, this.remoteServer.port());
            this.downstream = new DownstreamSession((ClientSession)downstream);
        } else {
            downstream = new ClientNetworkSession((SocketAddress)new InetSocketAddress(this.remoteServer.address(), this.remoteServer.port()), this.protocol, (Executor)this.tickEventLoop, null, null);
            this.downstream = new DownstreamSession((ClientSession)downstream);
            boolean resolveSrv = false;
            try {
                resolveSrv = this.remoteServer.resolveSrv();
            }
            catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {
                // empty catch block
            }
            this.downstream.getSession().setFlag(BuiltinFlags.ATTEMPT_SRV_RESOLVE, (Object)resolveSrv);
        }
        this.downstream.getSession().setFlag(MinecraftConstants.FOLLOW_TRANSFERS, (Object)false);
        if (this.geyser.getConfig().getRemote().isUseProxyProtocol()) {
            downstream.setFlag(BuiltinFlags.CLIENT_PROXIED_ADDRESS, this.upstream.getAddress());
        }
        if (this.geyser.getConfig().isForwardPlayerPing()) {
            downstream.setFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, false);
        }
        downstream.setFlag(MinecraftConstants.SEND_BLANK_KNOWN_PACKS_RESPONSE, false);
        this.protocol.setUseDefaultListeners(false);
        downstream.addListener((SessionListener)new ClientListener(HandshakeIntent.LOGIN));
        downstream.addListener((SessionListener)new GeyserSessionAdapter(this));
        downstream.setFlag(BuiltinFlags.CLIENT_TRANSFERRING, loginEvent.transferring());
        downstream.connect(false);
        if (!this.daylightCycle) {
            this.setDaylightCycle(true);
        }
    }

    public void disconnect(String reason) {
        this.disconnect((Component)Component.text((String)reason));
    }

    public void disconnect(Component reason) {
        if (!this.closed) {
            PendingMicrosoftAuthentication.AuthenticationTask task;
            this.loggedIn = false;
            SessionDisconnectEventImpl disconnectEvent = new SessionDisconnectEventImpl(this, reason);
            if (this.authData != null && this.clientData != null) {
                this.geyser.getEventBus().fire(disconnectEvent);
            }
            if (this.downstream != null) {
                if (!this.downstream.isClosed()) {
                    this.downstream.disconnect(reason);
                }
            } else {
                String address = this.geyser.getConfig().isLogPlayerIpAddresses() ? this.upstream.getAddress().getAddress().toString() : "<IP address withheld>";
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.disconnect", address, MessageTranslator.convertMessage(reason)));
            }
            if (!this.upstream.isClosed()) {
                this.upstream.disconnect(disconnectEvent.disconnectReason());
            }
            this.geyser.getSessionManager().removeSession(this);
            if (this.authData != null && (task = this.geyser.getPendingMicrosoftAuthentication().getTask(this.authData.xuid())) != null) {
                task.resetRunningFlow();
            }
        }
        if (this.tickThread != null) {
            this.tickThread.cancel(false);
        }
        this.closed = true;
        this.erosionHandler.close();
    }

    public void ensureInEventLoop(Runnable runnable) {
        if (this.tickEventLoop.inEventLoop()) {
            this.executeRunnable(runnable);
            return;
        }
        this.executeInEventLoop(runnable);
    }

    public void executeInEventLoop(Runnable runnable) {
        this.tickEventLoop.execute(() -> this.executeRunnable(runnable));
    }

    public ScheduledFuture<?> scheduleInEventLoop(Runnable runnable, long duration, TimeUnit timeUnit) {
        return this.tickEventLoop.schedule(() -> this.executeRunnable(() -> {
            if (!this.closed) {
                runnable.run();
            }
        }), duration, timeUnit);
    }

    public void updateTickingState(float tickRate, boolean frozen) {
        this.tickThread.cancel(false);
        this.tickingFrozen = frozen;
        tickRate = MathUtils.clamp(tickRate, 1.0f, 10000.0f);
        this.millisecondsPerTick = 1000.0f / tickRate;
        this.nanosecondsPerTick = MathUtils.ceil(1.0E9f / tickRate);
        this.tickThread = this.tickEventLoop.scheduleAtFixedRate(this::tick, (long)this.nanosecondsPerTick, (long)this.nanosecondsPerTick, TimeUnit.NANOSECONDS);
    }

    private void executeRunnable(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ErosionCancellationException e) {
            this.geyser.getLogger().debug("Caught ErosionCancellationException");
        }
        catch (Throwable e) {
            this.geyser.getLogger().error("Error thrown in " + this.bedrockUsername() + "'s event loop!", e);
        }
    }

    protected void tick() {
        try {
            int miningFatigueLevel;
            int hasteLevel;
            int swingTotalDuration;
            Entity vehicle;
            boolean gameShouldUpdate;
            boolean shouldShowFog;
            this.pistonCache.tick();
            if (this.worldBorder.isResizing()) {
                this.worldBorder.resize();
            }
            boolean bl = shouldShowFog = !this.worldBorder.isWithinWarningBoundaries();
            if (shouldShowFog || this.worldBorder.isCloseToBorderBoundaries()) {
                this.worldBorder.drawWall();
                if (shouldShowFog && !this.isInWorldBorderWarningArea) {
                    this.isInWorldBorderWarningArea = true;
                    this.camera().sendFog("minecraft:fog_crimson_forest");
                }
            }
            if (!shouldShowFog && this.isInWorldBorderWarningArea) {
                this.camera().removeFog("minecraft:fog_crimson_forest");
                this.isInWorldBorderWarningArea = false;
            }
            boolean bl2 = gameShouldUpdate = !this.tickingFrozen || this.stepTicks > 0;
            if (this.stepTicks > 0) {
                --this.stepTicks;
            }
            if ((vehicle = this.playerEntity.getVehicle()) instanceof ClientVehicle) {
                ClientVehicle clientVehicle = (ClientVehicle)((Object)vehicle);
                if (vehicle.isValid()) {
                    clientVehicle.getVehicleComponent().tickVehicle();
                }
            }
            for (Tickable entity : this.entityCache.getTickableEntities()) {
                entity.drawTick();
                if (!gameShouldUpdate) continue;
                entity.tick();
            }
            if (this.armAnimationTicks >= 0 && ++this.armAnimationTicks >= (swingTotalDuration = (hasteLevel = Math.max(this.effectCache.getHaste(), this.effectCache.getConduitPower())) > 0 ? 6 - hasteLevel : ((miningFatigueLevel = this.effectCache.getMiningFatigue()) > 0 ? 6 + miningFatigueLevel * 2 : 6))) {
                if (this.sneaking && this.attemptToBlock()) {
                    this.playerEntity.updateBedrockMetadata();
                }
                this.armAnimationTicks = -1;
            }
            this.bundleCache.tick();
            if (this.spawned && this.protocol.getOutboundState() == ProtocolState.GAME) {
                this.sendDownstreamGamePacket((Packet)ServerboundClientTickEndPacket.INSTANCE);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ++this.ticks;
        ++this.worldTicks;
    }

    public void startSneaking() {
        if (this.armAnimationTicks < 0) {
            this.attemptToBlock();
        }
        this.setSneaking(true);
    }

    public void stopSneaking() {
        this.disableBlocking();
        this.setSneaking(false);
    }

    public void setSpinAttack(boolean spinAttack) {
        this.switchPose(spinAttack, EntityFlag.DAMAGE_NEARBY_MOBS, Pose.SPIN_ATTACK);
    }

    public void setGliding(boolean gliding) {
        this.switchPose(gliding, EntityFlag.GLIDING, Pose.FALL_FLYING);
    }

    private void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
        if (!this.flying) {
            this.setSneakingPose(sneaking);
        }
        this.collisionManager.updateScaffoldingFlags(false);
        this.playerEntity.updateBedrockMetadata();
        if (this.mouseoverEntity != null) {
            this.mouseoverEntity.updateInteractiveTag();
        }
    }

    private void setSneakingPose(boolean sneaking) {
        if (this.pose == Pose.SNEAKING && !sneaking) {
            this.pose = Pose.STANDING;
            this.playerEntity.setBoundingBoxHeight(this.playerEntity.getDefinition().height());
        } else if (sneaking) {
            this.pose = Pose.SNEAKING;
            this.playerEntity.setBoundingBoxHeight(1.5f);
        }
        this.playerEntity.setFlag(EntityFlag.SNEAKING, sneaking);
    }

    public void setSwimming(boolean swimming) {
        if (!swimming && this.playerEntity.getFlag(EntityFlag.CRAWLING)) {
            this.playerEntity.setFlag(EntityFlag.SWIMMING, false);
            this.playerEntity.updateBedrockMetadata();
            return;
        }
        this.switchPose(swimming, EntityFlag.SWIMMING, Pose.SWIMMING);
    }

    public void setCrawling(boolean crawling) {
        this.switchPose(crawling, EntityFlag.CRAWLING, Pose.SWIMMING);
    }

    private void switchPose(boolean value, EntityFlag flag, Pose pose) {
        this.pose = value ? pose : Pose.STANDING;
        this.playerEntity.setDimensionsFromPose(this.pose);
        this.playerEntity.setFlag(flag, value);
        this.playerEntity.updateBedrockMetadata();
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
        if (this.sneaking) {
            this.setSneakingPose(!flying);
            this.playerEntity.updateBedrockMetadata();
        }
    }

    public void setGameMode(GameMode newGamemode) {
        boolean currentlySpectator = this.gameMode == GameMode.SPECTATOR;
        this.gameMode = newGamemode;
        this.cameraData.handleGameModeChange(currentlySpectator, newGamemode);
    }

    public void setClientData(BedrockClientData data) {
        this.clientData = data;
        this.inputCache.setInputMode(org.cloudburstmc.protocol.bedrock.data.InputMode.values()[data.getCurrentInputMode().ordinal()]);
    }

    public void useItem(Hand hand) {
        if (this.playerEntity.getFlag(EntityFlag.USING_ITEM)) {
            return;
        }
        this.sendDownstreamGamePacket((Packet)new ServerboundUseItemPacket(hand, this.worldCache.nextPredictionSequence(), this.playerEntity.getYaw(), this.playerEntity.getPitch()));
    }

    public void releaseItem() {
        ServerboundPlayerActionPacket releaseItemPacket = new ServerboundPlayerActionPacket(PlayerAction.RELEASE_USE_ITEM, Vector3i.ZERO, Direction.DOWN, 0);
        this.sendDownstreamGamePacket((Packet)releaseItemPacket);
    }

    private boolean attemptToBlock() {
        if (this.playerEntity.isInsideScaffolding()) {
            return false;
        }
        if (this.playerInventoryHolder.inventory().getItemInHand().asItem() == Items.SHIELD) {
            this.useItem(Hand.MAIN_HAND);
        } else if (this.playerInventoryHolder.inventory().getOffhand().asItem() == Items.SHIELD) {
            this.useItem(Hand.OFF_HAND);
        } else {
            return false;
        }
        this.playerEntity.setFlag(EntityFlag.BLOCKING, true);
        return true;
    }

    public void activateArmAnimationTicking() {
        this.armAnimationTicks = 0;
        if (this.disableBlocking()) {
            this.playerEntity.updateBedrockMetadata();
        }
    }

    public boolean isHandsBusy() {
        return this.playerEntity.getVehicle() instanceof BoatEntity && (this.steeringRight || this.steeringLeft);
    }

    private boolean disableBlocking() {
        if (this.playerEntity.getFlag(EntityFlag.BLOCKING)) {
            ServerboundPlayerActionPacket releaseItemPacket = new ServerboundPlayerActionPacket(PlayerAction.RELEASE_USE_ITEM, Vector3i.ZERO, Direction.DOWN, 0);
            this.sendDownstreamGamePacket((Packet)releaseItemPacket);
            this.playerEntity.setFlag(EntityFlag.BLOCKING, false);
            return true;
        }
        return false;
    }

    public void requestOffhandSwap() {
        ServerboundPlayerActionPacket swapHandsPacket = new ServerboundPlayerActionPacket(PlayerAction.SWAP_HANDS, Vector3i.ZERO, Direction.DOWN, 0);
        this.sendDownstreamGamePacket((Packet)swapHandsPacket);
    }

    @Override
    public String name() {
        return this.playerEntity != null ? this.javaUsername() : this.bedrockUsername();
    }

    @Override
    public void sendMessage(@NonNull String message) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid("");
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        textPacket.setMessage(message);
        this.upstream.sendPacket((BedrockPacket)textPacket);
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public UUID playerUuid() {
        return this.javaUuid();
    }

    @Override
    public GeyserSession connection() {
        return this;
    }

    @Override
    public String locale() {
        return this.clientData != null ? this.clientData.getLanguageCode() : GeyserLocale.getDefaultLocale();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.geyser.commandRegistry().hasPermission(this, permission);
    }

    public void sendChat(String message) {
        this.sendDownstreamGamePacket((Packet)new ServerboundChatPacket(message, Instant.now().toEpochMilli(), 0L, null, 0, new BitSet(), 0));
    }

    public void sendCommand(String command) {
        this.sendDownstreamGamePacket((Packet)new ServerboundChatCommandSignedPacket(command, Instant.now().toEpochMilli(), 0L, Collections.emptyList(), 0, new BitSet(), 0));
    }

    public void setClientRenderDistance(int clientRenderDistance) {
        boolean newSquareToCircle;
        boolean oldSquareToCircle = this.clientRenderDistance < this.serverRenderDistance;
        this.clientRenderDistance = clientRenderDistance;
        boolean bl = newSquareToCircle = this.clientRenderDistance < this.serverRenderDistance;
        if (this.serverRenderDistance != -1 && oldSquareToCircle != newSquareToCircle) {
            this.recalculateBedrockRenderDistance();
        }
    }

    public void setServerRenderDistance(int renderDistance) {
        this.serverRenderDistance = renderDistance = Math.min(renderDistance, 96);
        this.recalculateBedrockRenderDistance();
    }

    private void recalculateBedrockRenderDistance() {
        int renderDistance = ChunkUtils.squareToCircle(this.serverRenderDistance);
        ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
        chunkRadiusUpdatedPacket.setRadius(renderDistance);
        this.upstream.sendPacket((BedrockPacket)chunkRadiusUpdatedPacket);
    }

    public InetSocketAddress getSocketAddress() {
        return this.upstream.getAddress();
    }

    public boolean sendForm(@NonNull Form form) {
        this.formCache.showForm(form);
        return true;
    }

    public @NonNull PlayerInventory getPlayerInventory() {
        return this.playerInventoryHolder.inventory();
    }

    public @Nullable Inventory getOpenInventory() {
        if (this.inventoryHolder == null) {
            return null;
        }
        return this.inventoryHolder.inventory();
    }

    public boolean sendForm(@NonNull org.geysermc.cumulus.form.util.FormBuilder<?, ?, ?> formBuilder) {
        this.formCache.showForm(formBuilder.build());
        return true;
    }

    @Deprecated
    public void sendForm(org.geysermc.cumulus.Form<?> form) {
        this.sendForm(form.newForm());
    }

    @Deprecated
    public void sendForm(FormBuilder<?, ?> formBuilder) {
        this.sendForm(formBuilder.build());
    }

    private void startGame() {
        this.upstream.getCodecHelper().setItemDefinitions((DefinitionRegistry)this.itemMappings);
        this.upstream.getCodecHelper().setBlockDefinitions((DefinitionRegistry)this.blockMappings);
        this.upstream.getCodecHelper().setCameraPresetDefinitions(CameraDefinitions.CAMERA_DEFINITIONS);
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.setUniqueEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setRuntimeEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setPlayerGameType(EntityUtils.toBedrockGamemode(this.gameMode));
        startGamePacket.setPlayerPosition(Vector3f.from((float)0.0f, (float)69.0f, (float)0.0f));
        startGamePacket.setRotation(Vector2f.from((float)1.0f, (float)1.0f));
        startGamePacket.setSeed(-1L);
        startGamePacket.setDimensionId(this.bedrockDimension.bedrockId());
        startGamePacket.setGeneratorId(1);
        startGamePacket.setLevelGameType(GameType.SURVIVAL);
        startGamePacket.setDifficulty(1);
        startGamePacket.setDefaultSpawn(Vector3i.ZERO);
        startGamePacket.setAchievementsDisabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setCurrentTick(-1L);
        startGamePacket.setEduEditionOffers(0);
        startGamePacket.setEduFeaturesEnabled(false);
        startGamePacket.setRainLevel(0.0f);
        startGamePacket.setLightningLevel(0.0f);
        startGamePacket.setMultiplayerGame(true);
        startGamePacket.setBroadcastingToLan(true);
        startGamePacket.setPlatformBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setXblBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setCommandsEnabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setTexturePacksRequired(false);
        startGamePacket.setBonusChestEnabled(false);
        startGamePacket.setStartingWithMap(false);
        startGamePacket.setTrustingPlayers(true);
        startGamePacket.setDefaultPlayerPermission(PlayerPermission.MEMBER);
        startGamePacket.setServerChunkTickRange(4);
        startGamePacket.setBehaviorPackLocked(false);
        startGamePacket.setResourcePackLocked(false);
        startGamePacket.setFromLockedWorldTemplate(false);
        startGamePacket.setUsingMsaGamertagsOnly(false);
        startGamePacket.setFromWorldTemplate(false);
        startGamePacket.setWorldTemplateOptionLocked(false);
        startGamePacket.setSpawnBiomeType(SpawnBiomeType.DEFAULT);
        startGamePacket.setCustomBiomeName("");
        startGamePacket.setEducationProductionId("");
        startGamePacket.setForceExperimentalGameplay(OptionalBoolean.empty());
        String serverName = this.geyser.getConfig().getBedrock().serverName();
        startGamePacket.setLevelId(serverName);
        startGamePacket.setLevelName(serverName);
        startGamePacket.setPremiumWorldTemplateId("00000000-0000-0000-0000-000000000000");
        startGamePacket.setEnchantmentSeed(0);
        startGamePacket.setMultiplayerCorrelationId("");
        startGamePacket.getItemDefinitions().addAll(this.itemMappings.getItemDefinitions().values());
        startGamePacket.getBlockProperties().addAll(this.blockMappings.getBlockProperties());
        startGamePacket.getExperiments().add(new ExperimentData("data_driven_items", true));
        startGamePacket.getExperiments().add(new ExperimentData("upcoming_creator_features", true));
        startGamePacket.getExperiments().add(new ExperimentData("experimental_molang_features", true));
        startGamePacket.getExperiments().add(new ExperimentData("experimental_graphics", true));
        startGamePacket.setVanillaVersion("*");
        startGamePacket.setInventoriesServerAuthoritative(true);
        startGamePacket.setServerEngine("");
        startGamePacket.setPlayerPropertyData(NbtMap.EMPTY);
        startGamePacket.setWorldTemplateId(UUID.randomUUID());
        startGamePacket.setChatRestrictionLevel(ChatRestrictionLevel.NONE);
        startGamePacket.setAuthoritativeMovementMode(AuthoritativeMovementMode.SERVER);
        startGamePacket.setRewindHistorySize(0);
        startGamePacket.setServerAuthoritativeBlockBreaking(false);
        startGamePacket.setServerId("");
        startGamePacket.setWorldId("");
        startGamePacket.setScenarioId("");
        this.upstream.sendPacket((BedrockPacket)startGamePacket);
    }

    private void syncEntityProperties() {
        for (NbtMap nbtMap : (Set)Registries.BEDROCK_ENTITY_PROPERTIES.get()) {
            SyncEntityPropertyPacket syncEntityPropertyPacket = new SyncEntityPropertyPacket();
            syncEntityPropertyPacket.setData(nbtMap);
            this.upstream.sendPacket((BedrockPacket)syncEntityPropertyPacket);
        }
    }

    public int getNextItemNetId() {
        return this.itemNetId.getAndIncrement();
    }

    public void confirmTeleport(Vector3d position) {
        if (this.unconfirmedTeleport == null) {
            return;
        }
        if (this.unconfirmedTeleport.canConfirm(position)) {
            this.unconfirmedTeleport = null;
            return;
        }
        this.unconfirmedTeleport.incrementUnconfirmedFor();
        if (this.unconfirmedTeleport.shouldResend()) {
            this.unconfirmedTeleport.resetUnconfirmedFor();
            this.geyser.getLogger().debug("Resending teleport " + this.unconfirmedTeleport.getTeleportConfirmId());
            this.getPlayerEntity().moveAbsolute(Vector3f.from((double)this.unconfirmedTeleport.getX(), (double)this.unconfirmedTeleport.getY(), (double)this.unconfirmedTeleport.getZ()), this.unconfirmedTeleport.getYaw(), this.unconfirmedTeleport.getPitch(), this.playerEntity.isOnGround(), true);
        }
    }

    public void sendUpstreamPacket(BedrockPacket packet) {
        this.upstream.sendPacket(packet);
    }

    public void sendUpstreamPacketImmediately(BedrockPacket packet) {
        this.upstream.sendPacketImmediately(packet);
    }

    public void sendDownstreamGamePacket(Packet packet) {
        this.sendDownstreamPacket(packet, ProtocolState.GAME);
    }

    public void sendDownstreamLoginPacket(Packet packet) {
        this.sendDownstreamPacket(packet, ProtocolState.LOGIN);
    }

    public void sendDownstreamPacket(Packet packet, ProtocolState intendedState) {
        if (this.protocol == null) {
            if (this.geyser.getConfig().isDebugMode()) {
                this.geyser.getLogger().debug("Tried to send downstream packet with no downstream session!");
                Thread.dumpStack();
            }
            return;
        }
        if (this.protocol.getOutboundState() != intendedState) {
            this.geyser.getLogger().debug("Tried to send " + packet.getClass().getSimpleName() + " packet while not in " + intendedState.name() + " outbound state. Current state: " + this.protocol.getOutboundState().name());
            return;
        }
        this.sendDownstreamPacket(packet);
    }

    public void sendDownstreamPacket(Packet packet) {
        if (!this.closed && this.downstream != null) {
            Channel channel = this.downstream.getSession().getChannel();
            if (channel == null) {
                this.geyser.getLogger().warning("Tried to send a packet to the Java server too early!");
                if (this.geyser.getConfig().isDebugMode()) {
                    Thread.dumpStack();
                }
                return;
            }
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.sendDownstreamPacket0(packet);
            } else {
                eventLoop.execute(() -> this.sendDownstreamPacket0(packet));
            }
        }
    }

    private void sendDownstreamPacket0(Packet packet) {
        ProtocolState state = this.protocol.getOutboundState();
        if (state == ProtocolState.GAME || state == ProtocolState.CONFIGURATION || packet.getClass() == ServerboundCustomQueryAnswerPacket.class) {
            this.downstream.sendPacket(packet);
        } else {
            this.geyser.getLogger().debug("Tried to send downstream packet " + packet.getClass().getSimpleName() + " before connected to the server");
        }
    }

    public void setReducedDebugInfo(boolean value) {
        this.reducedDebugInfo = value;
        this.preferencesCache.updateShowCoordinates();
    }

    public void setDaylightCycle(boolean doCycle) {
        this.sendGameRule("dodaylightcycle", doCycle);
        this.daylightCycle = doCycle;
    }

    public void sendGameRule(String gameRule, Object value) {
        GameRulesChangedPacket gameRulesChangedPacket = new GameRulesChangedPacket();
        gameRulesChangedPacket.getGameRules().add(new GameRuleData(gameRule, value));
        this.upstream.sendPacket((BedrockPacket)gameRulesChangedPacket);
    }

    public void sendAdventureSettings() {
        long bedrockId = this.playerEntity.getGeyserId();
        CommandPermission commandPermission = this.opPermissionLevel >= 2 ? CommandPermission.GAME_DIRECTORS : CommandPermission.ANY;
        PlayerPermission playerPermission = this.opPermissionLevel >= 2 ? PlayerPermission.OPERATOR : PlayerPermission.MEMBER;
        boolean spectator = this.gameMode == GameMode.SPECTATOR;
        boolean worldImmutable = this.gameMode == GameMode.ADVENTURE || spectator;
        UpdateAdventureSettingsPacket adventureSettingsPacket = new UpdateAdventureSettingsPacket();
        adventureSettingsPacket.setNoMvP(false);
        adventureSettingsPacket.setNoPvM(false);
        adventureSettingsPacket.setImmutableWorld(worldImmutable);
        adventureSettingsPacket.setShowNameTags(false);
        adventureSettingsPacket.setAutoJump(true);
        this.sendUpstreamPacket((BedrockPacket)adventureSettingsPacket);
        UpdateAbilitiesPacket updateAbilitiesPacket = new UpdateAbilitiesPacket();
        updateAbilitiesPacket.setUniqueEntityId(bedrockId);
        updateAbilitiesPacket.setCommandPermission(commandPermission);
        updateAbilitiesPacket.setPlayerPermission(playerPermission);
        AbilityLayer abilityLayer = new AbilityLayer();
        Set abilities = abilityLayer.getAbilityValues();
        if (this.canFly) {
            abilities.add(Ability.MAY_FLY);
        }
        abilities.add(Ability.BUILD);
        abilities.add(Ability.MINE);
        abilities.add(Ability.DOORS_AND_SWITCHES);
        abilities.add(Ability.OPEN_CONTAINERS);
        if (this.gameMode == GameMode.CREATIVE) {
            abilities.add(Ability.INSTABUILD);
        }
        if (commandPermission == CommandPermission.GAME_DIRECTORS) {
            abilities.add(Ability.OPERATOR_COMMANDS);
        }
        if (this.flying || spectator) {
            if (spectator && !this.flying) {
                this.flying = true;
                ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(true);
                this.sendDownstreamGamePacket((Packet)abilitiesPacket);
            }
            abilities.add(Ability.FLYING);
        }
        if (spectator) {
            AbilityLayer spectatorLayer = new AbilityLayer();
            spectatorLayer.setLayerType(AbilityLayer.Type.SPECTATOR);
            Set abilitySet = spectatorLayer.getAbilitiesSet();
            abilitySet.add(Ability.BUILD);
            abilitySet.add(Ability.MINE);
            abilitySet.add(Ability.DOORS_AND_SWITCHES);
            abilitySet.add(Ability.OPEN_CONTAINERS);
            abilitySet.add(Ability.ATTACK_PLAYERS);
            abilitySet.add(Ability.ATTACK_MOBS);
            abilitySet.add(Ability.INVULNERABLE);
            abilitySet.add(Ability.FLYING);
            abilitySet.add(Ability.MAY_FLY);
            abilitySet.add(Ability.INSTABUILD);
            abilitySet.add(Ability.NO_CLIP);
            Set abilityValues = spectatorLayer.getAbilityValues();
            abilityValues.add(Ability.INVULNERABLE);
            abilityValues.add(Ability.FLYING);
            abilityValues.add(Ability.NO_CLIP);
            updateAbilitiesPacket.getAbilityLayers().add(spectatorLayer);
        }
        abilityLayer.setLayerType(AbilityLayer.Type.BASE);
        abilityLayer.setFlySpeed(this.flySpeed);
        abilityLayer.setWalkSpeed(this.walkSpeed == 0.0f ? 0.01f : this.walkSpeed);
        abilityLayer.setVerticalFlySpeed(1.0f);
        Collections.addAll(abilityLayer.getAbilitiesSet(), USED_ABILITIES);
        updateAbilitiesPacket.getAbilityLayers().add(abilityLayer);
        this.sendUpstreamPacket((BedrockPacket)updateAbilitiesPacket);
    }

    private int getRenderDistance() {
        if (this.clientRenderDistance != -1) {
            return this.clientRenderDistance;
        }
        if (this.serverRenderDistance != -1) {
            return this.serverRenderDistance;
        }
        return 2;
    }

    public void sendJavaClientSettings() {
        ServerboundClientInformationPacket clientSettingsPacket = new ServerboundClientInformationPacket(this.locale().toLowerCase(Locale.ROOT), this.getRenderDistance(), ChatVisibility.FULL, true, SKIN_PARTS, HandPreference.RIGHT_HAND, false, true, ParticleStatus.ALL);
        this.sendDownstreamPacket((Packet)clientSettingsPacket);
    }

    public void updateStatistics(@NonNull Object2IntMap<Statistic> statistics) {
        if (this.statistics.isEmpty()) {
            for (CustomStatistic customStatistic : CustomStatistic.values()) {
                this.statistics.put((Object)customStatistic, 0);
            }
        }
        this.statistics.putAll(statistics);
    }

    public void refreshEmotes(List<UUID> emotes) {
        this.emotes.addAll(emotes);
        for (GeyserSession player : this.geyser.getSessionManager().getSessions().values()) {
            ArrayList<UUID> pieces = new ArrayList<UUID>();
            for (UUID piece : emotes) {
                if (!player.getEmotes().contains(piece)) {
                    pieces.add(piece);
                }
                player.getEmotes().add(piece);
            }
            EmoteListPacket emoteList = new EmoteListPacket();
            emoteList.setRuntimeEntityId(player.getPlayerEntity().getGeyserId());
            emoteList.getPieceIds().addAll(pieces);
            player.sendUpstreamPacket((BedrockPacket)emoteList);
        }
    }

    public boolean canUseCommandBlocks() {
        return this.instabuild && this.opPermissionLevel >= 2;
    }

    public void playSoundEvent(SoundEvent sound, Vector3f position) {
        LevelSoundEventPacket packet = new LevelSoundEventPacket();
        packet.setPosition(position);
        packet.setSound(sound);
        packet.setIdentifier(":");
        packet.setExtraData(-1);
        this.sendUpstreamPacket((BedrockPacket)packet);
    }

    public float getEyeHeight() {
        return switch (this.pose) {
            case Pose.SNEAKING -> 1.27f;
            case Pose.SWIMMING, Pose.FALL_FLYING, Pose.SPIN_ATTACK -> 0.4f;
            case Pose.SLEEPING -> 0.2f;
            default -> EntityDefinitions.PLAYER.offset();
        };
    }

    public void updateRain(float strength) {
        boolean wasRaining = this.isRaining();
        this.rainStrength = strength;
        LevelEventPacket rainPacket = new LevelEventPacket();
        rainPacket.setType((LevelEventType)(this.isRaining() ? LevelEvent.START_RAINING : LevelEvent.STOP_RAINING));
        rainPacket.setData((int)(strength * 65535.0f));
        rainPacket.setPosition(Vector3f.ZERO);
        this.sendUpstreamPacket((BedrockPacket)rainPacket);
        if (wasRaining != this.isRaining() && this.isThunder()) {
            if (this.isRaining()) {
                LevelEventPacket thunderPacket = new LevelEventPacket();
                thunderPacket.setType((LevelEventType)LevelEvent.START_THUNDERSTORM);
                thunderPacket.setData((int)(this.thunderStrength * 65535.0f));
                thunderPacket.setPosition(Vector3f.ZERO);
                this.sendUpstreamPacket((BedrockPacket)thunderPacket);
            } else {
                LevelEventPacket thunderPacket = new LevelEventPacket();
                thunderPacket.setType((LevelEventType)LevelEvent.STOP_THUNDERSTORM);
                thunderPacket.setData(0);
                thunderPacket.setPosition(Vector3f.ZERO);
                this.sendUpstreamPacket((BedrockPacket)thunderPacket);
            }
        }
    }

    public void updateThunder(float strength) {
        this.thunderStrength = strength;
        if (!this.isRaining()) {
            return;
        }
        LevelEventPacket thunderPacket = new LevelEventPacket();
        thunderPacket.setType((LevelEventType)(this.isThunder() ? LevelEvent.START_THUNDERSTORM : LevelEvent.STOP_THUNDERSTORM));
        thunderPacket.setData((int)(strength * 65535.0f));
        thunderPacket.setPosition(Vector3f.ZERO);
        this.sendUpstreamPacket((BedrockPacket)thunderPacket);
    }

    public boolean isRaining() {
        return this.rainStrength > 0.0f;
    }

    public boolean isThunder() {
        return this.thunderStrength > 0.0f;
    }

    public @NonNull String bedrockUsername() {
        return this.authData.name();
    }

    public @MonotonicNonNull String javaUsername() {
        return this.playerEntity != null ? this.playerEntity.getUsername() : null;
    }

    public UUID javaUuid() {
        return this.playerEntity != null ? this.playerEntity.getUuid() : null;
    }

    public @NonNull String xuid() {
        return this.authData.xuid();
    }

    public @NonNull String version() {
        return this.clientData.getGameVersion();
    }

    public @NonNull BedrockPlatform platform() {
        return BedrockPlatform.values()[this.clientData.getDeviceOs().ordinal()];
    }

    public @NonNull String languageCode() {
        return this.locale();
    }

    public @NonNull UiProfile uiProfile() {
        return UiProfile.values()[this.clientData.getUiProfile().ordinal()];
    }

    public @NonNull InputMode inputMode() {
        return InputMode.values()[this.inputCache.getInputMode().ordinal()];
    }

    public boolean isLinked() {
        return false;
    }

    public boolean transfer(@NonNull String address, @IntRange(from=0L, to=65535L) int port) {
        if (address == null || address.isBlank()) {
            throw new IllegalArgumentException("Server address cannot be null or blank");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Server port must be between 0 and 65535, was " + port);
        }
        TransferPacket transferPacket = new TransferPacket();
        transferPacket.setAddress(address);
        transferPacket.setPort(port);
        this.sendUpstreamPacket((BedrockPacket)transferPacket);
        return true;
    }

    @Override
    public @NonNull CompletableFuture<@Nullable GeyserEntity> entityByJavaId(@NonNegative int javaId) {
        return this.entities().entityByJavaId(javaId);
    }

    @Override
    public void showEmote(@NonNull GeyserPlayerEntity emoter, @NonNull String emoteId) {
        this.entities().showEmote(emoter, emoteId);
    }

    public void lockInputs(boolean camera, boolean movement) {
        UpdateClientInputLocksPacket packet = new UpdateClientInputLocksPacket();
        int cameraOffset = 2;
        int movementOffset = 4;
        int result = 0;
        if (camera) {
            result |= 2;
        }
        if (movement) {
            result |= 4;
        }
        packet.setLockComponentData(result);
        packet.setServerPosition(this.playerEntity.getPosition());
        this.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public @NonNull CameraData camera() {
        return this.cameraData;
    }

    @Override
    public @NonNull EntityData entities() {
        return this.entityData;
    }

    @Override
    public void shakeCamera(float intensity, float duration, @NonNull CameraShake type) {
        this.cameraData.shakeCamera(intensity, duration, type);
    }

    @Override
    public void stopCameraShake() {
        this.cameraData.stopCameraShake();
    }

    @Override
    public void sendFog(String ... fogNameSpaces) {
        this.cameraData.sendFog(fogNameSpaces);
    }

    @Override
    public void removeFog(String ... fogNameSpaces) {
        this.cameraData.removeFog(fogNameSpaces);
    }

    @Override
    public @NonNull Set<String> fogEffects() {
        return this.cameraData.fogEffects();
    }

    @Override
    public int ping() {
        if (!this.getUpstream().isInitialized() || this.getUpstream().isClosed()) {
            return 0;
        }
        RakSessionCodec rakSessionCodec = (RakSessionCodec)((RakChildChannel)this.getUpstream().getSession().getPeer().getChannel()).rakPipeline().get(RakSessionCodec.class);
        return (int)Math.floor(rakSessionCodec.getPing());
    }

    @Override
    public int protocolVersion() {
        return this.upstream.getProtocolVersion();
    }

    @Override
    public void closeForm() {
        this.sendUpstreamPacket((BedrockPacket)new ClientboundCloseFormPacket());
    }

    public void addCommandEnum(String name, String enums) {
        this.softEnumPacket(name, SoftEnumUpdateType.ADD, enums);
    }

    public void removeCommandEnum(String name, String enums) {
        this.softEnumPacket(name, SoftEnumUpdateType.REMOVE, enums);
    }

    private void softEnumPacket(String name, SoftEnumUpdateType type, String enums) {
        if (!this.geyser.getConfig().isCommandSuggestions()) {
            return;
        }
        UpdateSoftEnumPacket packet = new UpdateSoftEnumPacket();
        packet.setType(type);
        packet.setSoftEnum(new CommandEnumData(name, Collections.singletonMap(enums, Collections.emptySet()), true));
        this.sendUpstreamPacket((BedrockPacket)packet);
    }

    public GeyserImpl getGeyser() {
        return this.geyser;
    }

    public UpstreamSession getUpstream() {
        return this.upstream;
    }

    public DownstreamSession getDownstream() {
        return this.downstream;
    }

    public EventLoop getTickEventLoop() {
        return this.tickEventLoop;
    }

    public AuthData getAuthData() {
        return this.authData;
    }

    public BedrockClientData getClientData() {
        return this.clientData;
    }

    public List<String> getCertChainData() {
        return this.certChainData;
    }

    public @NonNull AbstractGeyserboundPacketHandler getErosionHandler() {
        return this.erosionHandler;
    }

    public RemoteServer remoteServer() {
        return this.remoteServer;
    }

    public SessionPlayerEntity getPlayerEntity() {
        return this.playerEntity;
    }

    public AdvancementsCache getAdvancementsCache() {
        return this.advancementsCache;
    }

    public BookEditCache getBookEditCache() {
        return this.bookEditCache;
    }

    public BundleCache getBundleCache() {
        return this.bundleCache;
    }

    public ChunkCache getChunkCache() {
        return this.chunkCache;
    }

    public EntityCache getEntityCache() {
        return this.entityCache;
    }

    public EntityEffectCache getEffectCache() {
        return this.effectCache;
    }

    public FormCache getFormCache() {
        return this.formCache;
    }

    public InputCache getInputCache() {
        return this.inputCache;
    }

    public LodestoneCache getLodestoneCache() {
        return this.lodestoneCache;
    }

    public PistonCache getPistonCache() {
        return this.pistonCache;
    }

    public PreferencesCache getPreferencesCache() {
        return this.preferencesCache;
    }

    public RegistryCache getRegistryCache() {
        return this.registryCache;
    }

    public SkullCache getSkullCache() {
        return this.skullCache;
    }

    public StructureBlockCache getStructureBlockCache() {
        return this.structureBlockCache;
    }

    public TagCache getTagCache() {
        return this.tagCache;
    }

    public WorldCache getWorldCache() {
        return this.worldCache;
    }

    public TeleportCache getUnconfirmedTeleport() {
        return this.unconfirmedTeleport;
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public boolean isInWorldBorderWarningArea() {
        return this.isInWorldBorderWarningArea;
    }

    public InventoryHolder<PlayerInventory> getPlayerInventoryHolder() {
        return this.playerInventoryHolder;
    }

    public @Nullable InventoryHolder<? extends Inventory> getInventoryHolder() {
        return this.inventoryHolder;
    }

    public boolean isClosingInventory() {
        return this.closingInventory;
    }

    public int getPendingOrCurrentBedrockInventoryId() {
        return this.pendingOrCurrentBedrockInventoryId;
    }

    public ScheduledFuture<?> getContainerOutputFuture() {
        return this.containerOutputFuture;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public BlockMappings getBlockMappings() {
        return this.blockMappings;
    }

    public ItemMappings getItemMappings() {
        return this.itemMappings;
    }

    public Map<Vector3i, ItemFrameEntity> getItemFrameCache() {
        return this.itemFrameCache;
    }

    public Map<UUID, GameProfile> getPlayerWithCustomHeads() {
        return this.playerWithCustomHeads;
    }

    public boolean isDroppingLecternBook() {
        return this.droppingLecternBook;
    }

    public Vector2i getLastChunkPosition() {
        return this.lastChunkPosition;
    }

    public int getClientRenderDistance() {
        return this.clientRenderDistance;
    }

    public int getServerRenderDistance() {
        return this.serverRenderDistance;
    }

    public boolean isSentSpawnPacket() {
        return this.sentSpawnPacket;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isLoggingIn() {
        return this.loggingIn;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Key getWorldName() {
        return this.worldName;
    }

    public String[] getLevels() {
        return this.levels;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public Pose getPose() {
        return this.pose;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public BedrockDimension getBedrockOverworldDimension() {
        return this.bedrockOverworldDimension;
    }

    public @MonotonicNonNull JavaDimension getDimensionType() {
        return this.dimensionType;
    }

    public BedrockDimension getBedrockDimension() {
        return this.bedrockDimension;
    }

    public int getBreakingBlock() {
        return this.breakingBlock;
    }

    public Vector3i getLastBlockPlacePosition() {
        return this.lastBlockPlacePosition;
    }

    public BlockItem getLastBlockPlaced() {
        return this.lastBlockPlaced;
    }

    public boolean isInteracting() {
        return this.interacting;
    }

    public Vector3i getLastInteractionBlockPosition() {
        return this.lastInteractionBlockPosition;
    }

    public Vector3f getLastInteractionPlayerPosition() {
        return this.lastInteractionPlayerPosition;
    }

    public Entity getMouseoverEntity() {
        return this.mouseoverEntity;
    }

    public Int2ObjectMap<List<String>> getJavaToBedrockRecipeIds() {
        return this.javaToBedrockRecipeIds;
    }

    public Int2ObjectMap<GeyserRecipe> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public Pair<CraftingRecipeData, GeyserRecipe> getLastCreatedRecipe() {
        return this.lastCreatedRecipe;
    }

    public AtomicInteger getLastRecipeNetId() {
        return this.lastRecipeNetId;
    }

    public Int2ObjectMap<GeyserStonecutterData> getStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public List<GeyserSmithingRecipe> getSmithingRecipes() {
        return this.smithingRecipes;
    }

    public boolean isEmulatePost1_13Logic() {
        return this.emulatePost1_13Logic;
    }

    public boolean isEmulatePost1_16Logic() {
        return this.emulatePost1_16Logic;
    }

    public boolean isEmulatePost1_18Logic() {
        return this.emulatePost1_18Logic;
    }

    public boolean isOldSmithingTable() {
        return this.oldSmithingTable;
    }

    public boolean isUsingExperimentalMinecartLogic() {
        return this.isUsingExperimentalMinecartLogic;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public boolean isSteeringLeft() {
        return this.steeringLeft;
    }

    public boolean isSteeringRight() {
        return this.steeringRight;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }

    public long getBlockBreakStartTime() {
        return this.blockBreakStartTime;
    }

    public boolean isPlacedBucket() {
        return this.placedBucket;
    }

    public int getArmAnimationTicks() {
        return this.armAnimationTicks;
    }

    public int getLastAirHitTick() {
        return this.lastAirHitTick;
    }

    public boolean isDaylightCycle() {
        return this.daylightCycle;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public int getOpPermissionLevel() {
        return this.opPermissionLevel;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean isInstabuild() {
        return this.instabuild;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public float getRainStrength() {
        return this.rainStrength;
    }

    public float getThunderStrength() {
        return this.thunderStrength;
    }

    public Object2IntMap<Statistic> getStatistics() {
        return this.statistics;
    }

    public boolean isWaitingForStatistics() {
        return this.waitingForStatistics;
    }

    public Set<UUID> getEmotes() {
        return this.emotes;
    }

    public boolean isAdvancedTooltips() {
        return this.advancedTooltips;
    }

    public ScheduledFuture<?> getTickThread() {
        return this.tickThread;
    }

    public int getTicks() {
        return this.ticks;
    }

    public long getWorldTicks() {
        return this.worldTicks;
    }

    public ScheduledFuture<?> getLookBackScheduledFuture() {
        return this.lookBackScheduledFuture;
    }

    public ScheduledFuture<?> getMountVehicleScheduledFuture() {
        return this.mountVehicleScheduledFuture;
    }

    public Queue<Long> getKeepAliveCache() {
        return this.keepAliveCache;
    }

    public @Nullable ItemData getCurrentBook() {
        return this.currentBook;
    }

    public Map<String, byte[]> getCookies() {
        return this.cookies;
    }

    public GeyserCameraData getCameraData() {
        return this.cameraData;
    }

    public GeyserEntityData getEntityData() {
        return this.entityData;
    }

    public int getNanosecondsPerTick() {
        return this.nanosecondsPerTick;
    }

    public float getMillisecondsPerTick() {
        return this.millisecondsPerTick;
    }

    public boolean isTickingFrozen() {
        return this.tickingFrozen;
    }

    public int getStepTicks() {
        return this.stepTicks;
    }

    public void setAuthData(AuthData authData) {
        this.authData = authData;
    }

    public void setCertChainData(List<String> certChainData) {
        this.certChainData = certChainData;
    }

    public void setErosionHandler(@NonNull AbstractGeyserboundPacketHandler erosionHandler) {
        if (erosionHandler == null) {
            throw new NullPointerException("erosionHandler is marked non-null but is null");
        }
        this.erosionHandler = erosionHandler;
    }

    public GeyserSession remoteServer(RemoteServer remoteServer) {
        this.remoteServer = remoteServer;
        return this;
    }

    public void setUnconfirmedTeleport(TeleportCache unconfirmedTeleport) {
        this.unconfirmedTeleport = unconfirmedTeleport;
    }

    public void setInventoryHolder(@Nullable InventoryHolder<? extends Inventory> inventoryHolder) {
        this.inventoryHolder = inventoryHolder;
    }

    public void setClosingInventory(boolean closingInventory) {
        this.closingInventory = closingInventory;
    }

    public void setPendingOrCurrentBedrockInventoryId(int pendingOrCurrentBedrockInventoryId) {
        this.pendingOrCurrentBedrockInventoryId = pendingOrCurrentBedrockInventoryId;
    }

    public void setContainerOutputFuture(ScheduledFuture<?> containerOutputFuture) {
        this.containerOutputFuture = containerOutputFuture;
    }

    public void setBlockMappings(BlockMappings blockMappings) {
        this.blockMappings = blockMappings;
    }

    public void setItemMappings(ItemMappings itemMappings) {
        this.itemMappings = itemMappings;
    }

    public void setDroppingLecternBook(boolean droppingLecternBook) {
        this.droppingLecternBook = droppingLecternBook;
    }

    public void setLastChunkPosition(Vector2i lastChunkPosition) {
        this.lastChunkPosition = lastChunkPosition;
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public void setWorldName(Key worldName) {
        this.worldName = worldName;
    }

    public void setLevels(String[] levels) {
        this.levels = levels;
    }

    public void setPose(Pose pose) {
        this.pose = pose;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    public void setDimensionType(@MonotonicNonNull JavaDimension dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setBedrockDimension(BedrockDimension bedrockDimension) {
        this.bedrockDimension = bedrockDimension;
    }

    public void setBreakingBlock(int breakingBlock) {
        this.breakingBlock = breakingBlock;
    }

    public void setLastBlockPlacePosition(Vector3i lastBlockPlacePosition) {
        this.lastBlockPlacePosition = lastBlockPlacePosition;
    }

    public void setLastBlockPlaced(BlockItem lastBlockPlaced) {
        this.lastBlockPlaced = lastBlockPlaced;
    }

    public void setInteracting(boolean interacting) {
        this.interacting = interacting;
    }

    public void setLastInteractionBlockPosition(Vector3i lastInteractionBlockPosition) {
        this.lastInteractionBlockPosition = lastInteractionBlockPosition;
    }

    public void setLastInteractionPlayerPosition(Vector3f lastInteractionPlayerPosition) {
        this.lastInteractionPlayerPosition = lastInteractionPlayerPosition;
    }

    public void setMouseoverEntity(Entity mouseoverEntity) {
        this.mouseoverEntity = mouseoverEntity;
    }

    public void setLastCreatedRecipe(Pair<CraftingRecipeData, GeyserRecipe> lastCreatedRecipe) {
        this.lastCreatedRecipe = lastCreatedRecipe;
    }

    public void setStonecutterRecipes(Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes) {
        this.stonecutterRecipes = stonecutterRecipes;
    }

    public void setEmulatePost1_13Logic(boolean emulatePost1_13Logic) {
        this.emulatePost1_13Logic = emulatePost1_13Logic;
    }

    public void setEmulatePost1_16Logic(boolean emulatePost1_16Logic) {
        this.emulatePost1_16Logic = emulatePost1_16Logic;
    }

    public void setEmulatePost1_18Logic(boolean emulatePost1_18Logic) {
        this.emulatePost1_18Logic = emulatePost1_18Logic;
    }

    public void setOldSmithingTable(boolean oldSmithingTable) {
        this.oldSmithingTable = oldSmithingTable;
    }

    public void setUsingExperimentalMinecartLogic(boolean isUsingExperimentalMinecartLogic) {
        this.isUsingExperimentalMinecartLogic = isUsingExperimentalMinecartLogic;
    }

    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public void setSteeringLeft(boolean steeringLeft) {
        this.steeringLeft = steeringLeft;
    }

    public void setSteeringRight(boolean steeringRight) {
        this.steeringRight = steeringRight;
    }

    public void setLastInteractionTime(long lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
    }

    public void setBlockBreakStartTime(long blockBreakStartTime) {
        this.blockBreakStartTime = blockBreakStartTime;
    }

    public void setPlacedBucket(boolean placedBucket) {
        this.placedBucket = placedBucket;
    }

    public void setLastAirHitTick(int lastAirHitTick) {
        this.lastAirHitTick = lastAirHitTick;
    }

    public void setOpPermissionLevel(int opPermissionLevel) {
        this.opPermissionLevel = opPermissionLevel;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public void setInstabuild(boolean instabuild) {
        this.instabuild = instabuild;
    }

    public void setFlySpeed(float flySpeed) {
        this.flySpeed = flySpeed;
    }

    public void setWalkSpeed(float walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public void setWaitingForStatistics(boolean waitingForStatistics) {
        this.waitingForStatistics = waitingForStatistics;
    }

    public void setAdvancedTooltips(boolean advancedTooltips) {
        this.advancedTooltips = advancedTooltips;
    }

    public void setWorldTicks(long worldTicks) {
        this.worldTicks = worldTicks;
    }

    public void setLookBackScheduledFuture(ScheduledFuture<?> lookBackScheduledFuture) {
        this.lookBackScheduledFuture = lookBackScheduledFuture;
    }

    public void setMountVehicleScheduledFuture(ScheduledFuture<?> mountVehicleScheduledFuture) {
        this.mountVehicleScheduledFuture = mountVehicleScheduledFuture;
    }

    public void setCurrentBook(@Nullable ItemData currentBook) {
        this.currentBook = currentBook;
    }

    public void setCookies(Map<String, byte[]> cookies) {
        this.cookies = cookies;
    }

    MinecraftProtocol getProtocol() {
        return this.protocol;
    }

    public void setStepTicks(int stepTicks) {
        this.stepTicks = stepTicks;
    }
}

