/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class PlayerHeadItem
extends BlockItem {
    public PlayerHeadItem(Item.Builder builder, Block block, Block ... otherBlocks) {
        super(builder, block, otherBlocks);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        char rarity = Rarity.fromId((Integer)components.get((DataComponentType)DataComponentTypes.RARITY)).getColor();
        GameProfile profile = (GameProfile)components.get(DataComponentTypes.PROFILE);
        if (profile != null) {
            String name = profile.getName();
            if (name != null) {
                String displayName = "\u00a7r\u00a7" + rarity + MinecraftLocale.getLocaleString("block.minecraft.player_head.named", session.locale()).replace("%s", name);
                builder.setCustomName(displayName);
            } else {
                builder.setCustomName("\u00a7r\u00a7" + rarity + MinecraftLocale.getLocaleString("block.minecraft.player_head", session.locale()));
            }
        }
    }
}

