/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^scaffolding$", usesParams=true, passDefaultBoxes=true)
public class ScaffoldingCollision
extends BlockCollision {
    public ScaffoldingCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        playerCollision.setSizeY(playerCollision.getSizeY() - 0.001);
        playerCollision.setMiddleY(playerCollision.getMiddleY() + 0.002);
        boolean intersected = this.checkIntersection(x, y, z, playerCollision);
        playerCollision.setSizeY(playerCollision.getSizeY() + 0.001);
        playerCollision.setMiddleY(playerCollision.getMiddleY() - 0.002);
        if (intersected) {
            session.getCollisionManager().setTouchingScaffolding(true);
            session.getCollisionManager().setOnScaffolding(true);
        } else {
            playerCollision.setSizeY(playerCollision.getSizeY() + 0.001);
            playerCollision.setMiddleY(playerCollision.getMiddleY() - 0.002);
            if (this.checkIntersection(x, y, z, playerCollision)) {
                session.getCollisionManager().setOnScaffolding(true);
            }
            playerCollision.setSizeY(playerCollision.getSizeY() - 0.001);
            playerCollision.setMiddleY(playerCollision.getMiddleY() + 0.002);
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaffoldingCollision)) {
            return false;
        }
        ScaffoldingCollision other = (ScaffoldingCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScaffoldingCollision;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

