/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class TurtleEntity
extends AnimalEntity {
    public TurtleEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setPregnant(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.IS_PREGNANT, entityMetadata.getPrimitiveValue());
    }

    public void setLayingEgg(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.LAYING_EGG, entityMetadata.getPrimitiveValue());
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.TURTLE_FOOD;
    }

    @Override
    protected float getAdultSize() {
        return super.getAdultSize() * 0.7f;
    }

    @Override
    protected float getBabySize() {
        return 0.15f;
    }

    @Override
    public boolean canBeLeashed() {
        return false;
    }
}

