/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.event;

import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.event.EventData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.event.EventDataType;

public final class RaidUpdateEventData
implements EventData {
    private final int currentWave;
    private final int totalWaves;
    private final boolean winner;

    @Override
    public EventDataType getType() {
        return EventDataType.RAID_UPDATE;
    }

    public RaidUpdateEventData(int currentWave, int totalWaves, boolean winner) {
        this.currentWave = currentWave;
        this.totalWaves = totalWaves;
        this.winner = winner;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getTotalWaves() {
        return this.totalWaves;
    }

    public boolean isWinner() {
        return this.winner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RaidUpdateEventData)) {
            return false;
        }
        RaidUpdateEventData other = (RaidUpdateEventData)o;
        if (this.getCurrentWave() != other.getCurrentWave()) {
            return false;
        }
        if (this.getTotalWaves() != other.getTotalWaves()) {
            return false;
        }
        return this.isWinner() == other.isWinner();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentWave();
        result = result * 59 + this.getTotalWaves();
        result = result * 59 + (this.isWinner() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RaidUpdateEventData(currentWave=" + this.getCurrentWave() + ", totalWaves=" + this.getTotalWaves() + ", winner=" + this.isWinner() + ")";
    }
}

