/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ObjectiveAction;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreType;

public class ClientboundSetObjectivePacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final ObjectiveAction action;
    private final @Nullable Component displayName;
    private final @Nullable ScoreType type;
    private final @Nullable NumberFormat numberFormat;

    public ClientboundSetObjectivePacket(@lombok.NonNull String name) {
        this(name, ObjectiveAction.REMOVE, null, null, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public ClientboundSetObjectivePacket(@lombok.NonNull String name, @lombok.NonNull ObjectiveAction action, @Nullable Component displayName, @Nullable ScoreType type, @Nullable NumberFormat numberFormat) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (!(action != ObjectiveAction.ADD && action != ObjectiveAction.UPDATE || displayName != null && type != null)) {
            throw new IllegalArgumentException("ADD and UPDATE actions require display name and type.");
        }
        this.name = name;
        this.action = action;
        this.displayName = displayName;
        this.type = type;
        this.numberFormat = numberFormat;
    }

    public ClientboundSetObjectivePacket(ByteBuf in) {
        this.name = MinecraftTypes.readString(in);
        this.action = ObjectiveAction.from(in.readByte());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            this.displayName = MinecraftTypes.readComponent(in);
            this.type = ScoreType.from(MinecraftTypes.readVarInt(in));
            this.numberFormat = MinecraftTypes.readNullable(in, MinecraftTypes::readNumberFormat);
        } else {
            this.displayName = null;
            this.type = ScoreType.INTEGER;
            this.numberFormat = null;
        }
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeString(out, this.name);
        out.writeByte(this.action.ordinal());
        if (this.action == ObjectiveAction.ADD || this.action == ObjectiveAction.UPDATE) {
            MinecraftTypes.writeComponent(out, this.displayName);
            MinecraftTypes.writeVarInt(out, this.type.ordinal());
            MinecraftTypes.writeNullable(out, this.numberFormat, MinecraftTypes::writeNumberFormat);
        }
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public String getName() {
        return this.name;
    }

    @lombok.NonNull
    public ObjectiveAction getAction() {
        return this.action;
    }

    public @Nullable Component getDisplayName() {
        return this.displayName;
    }

    public @Nullable ScoreType getType() {
        return this.type;
    }

    public @Nullable NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetObjectivePacket)) {
            return false;
        }
        ClientboundSetObjectivePacket other = (ClientboundSetObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectiveAction this$action = this.getAction();
        ObjectiveAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Component this$displayName = this.getDisplayName();
        Component other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        ScoreType this$type = this.getType();
        ScoreType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        NumberFormat this$numberFormat = this.getNumberFormat();
        NumberFormat other$numberFormat = other.getNumberFormat();
        return !(this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetObjectivePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectiveAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Component $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        ScoreType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        NumberFormat $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetObjectivePacket(name=" + this.getName() + ", action=" + String.valueOf((Object)this.getAction()) + ", displayName=" + String.valueOf(this.getDisplayName()) + ", type=" + String.valueOf((Object)this.getType()) + ", numberFormat=" + String.valueOf(this.getNumberFormat()) + ")";
    }

    public @NonNull ClientboundSetObjectivePacket withName(@lombok.NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new ClientboundSetObjectivePacket(name, this.action, this.displayName, this.type, this.numberFormat);
    }

    public @NonNull ClientboundSetObjectivePacket withAction(@lombok.NonNull ObjectiveAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.action == action ? this : new ClientboundSetObjectivePacket(this.name, action, this.displayName, this.type, this.numberFormat);
    }

    public @NonNull ClientboundSetObjectivePacket withDisplayName(@Nullable Component displayName) {
        return this.displayName == displayName ? this : new ClientboundSetObjectivePacket(this.name, this.action, displayName, this.type, this.numberFormat);
    }

    public @NonNull ClientboundSetObjectivePacket withType(@Nullable ScoreType type) {
        return this.type == type ? this : new ClientboundSetObjectivePacket(this.name, this.action, this.displayName, type, this.numberFormat);
    }

    public @NonNull ClientboundSetObjectivePacket withNumberFormat(@Nullable NumberFormat numberFormat) {
        return this.numberFormat == numberFormat ? this : new ClientboundSetObjectivePacket(this.name, this.action, this.displayName, this.type, numberFormat);
    }
}

