/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.TransferPacket;
import org.cloudburstmc.protocol.bedrock.packet.UnknownPacket;
import org.geysermc.cumulus.Forms;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.util.FormType;
import org.geysermc.erosion.packet.ErosionPacket;
import org.geysermc.erosion.packet.ErosionPacketHandler;
import org.geysermc.erosion.packet.Packets;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundCustomPayloadPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;

@Translator(packet=ClientboundCustomPayloadPacket.class)
public class JavaCustomPayloadTranslator
extends PacketTranslator<ClientboundCustomPayloadPacket> {
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundCustomPayloadPacket packet) {
        String channel = packet.getChannel().asString();
        if (channel.equals("erosion:msg")) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])packet.getData());
            ErosionPacket erosionPacket = Packets.decode((ByteBuf)buf);
            ((GeyserboundPacket)erosionPacket).handle((ErosionPacketHandler)session.getErosionHandler());
            return;
        }
        if (channel.equals("floodgate:form")) {
            session.ensureInEventLoop(() -> {
                byte[] data = packet.getData();
                if (data.length == 0) {
                    session.closeForm();
                    return;
                }
                FormType type = FormType.fromOrdinal((int)data[0]);
                if (type == null) {
                    throw new NullPointerException("Got type " + data[0] + " which isn't a valid form type!");
                }
                String dataString = new String(data, 3, data.length - 3, Charsets.UTF_8);
                Form form = Forms.fromJson((String)dataString, (FormType)type, (ignored, response) -> {
                    byte[] finalData;
                    if (response == null) {
                        finalData = new byte[]{data[1], data[2]};
                    } else {
                        byte[] raw = response.getBytes(StandardCharsets.UTF_8);
                        finalData = new byte[raw.length + 2];
                        finalData[0] = data[1];
                        finalData[1] = data[2];
                        System.arraycopy(raw, 0, finalData, 2, raw.length);
                    }
                    session.sendDownstreamPacket((Packet)new ServerboundCustomPayloadPacket(packet.getChannel(), finalData));
                });
                session.sendForm(form);
            });
        } else if (channel.equals("floodgate:transfer")) {
            session.ensureInEventLoop(() -> {
                byte[] data = packet.getData();
                if (data.length < 5) {
                    throw new NullPointerException("Transfer data should be at least 5 bytes long");
                }
                int port = data[0] << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                String address = new String(data, 4, data.length - 4);
                if (this.logger.isDebug()) {
                    this.logger.info("Transferring client to: " + address + ":" + port);
                }
                TransferPacket transferPacket = new TransferPacket();
                transferPacket.setAddress(address);
                transferPacket.setPort(port);
                session.sendUpstreamPacket((BedrockPacket)transferPacket);
            });
        } else if (channel.equals("floodgate:packet")) {
            session.ensureInEventLoop(() -> {
                this.logger.debug("A packet has been sent using the Floodgate api");
                byte[] data = packet.getData();
                if (data.length < 2) {
                    throw new IllegalStateException("Packet data should be at least 2 bytes long");
                }
                int packetId = data[0] & 0xFF;
                ByteBuf packetData = Unpooled.wrappedBuffer((byte[])data, (int)1, (int)(data.length - 1));
                UnknownPacket toSend = new UnknownPacket();
                toSend.setPacketId(packetId);
                toSend.setPayload(packetData);
                session.sendUpstreamPacket((BedrockPacket)toSend);
            });
        }
    }
}

