/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.sound.block;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.sound.BlockSoundInteractionTranslator;
import org.geysermc.geyser.translator.sound.SoundTranslator;

@SoundTranslator(blocks={"door", "fence_gate"})
public class OpenableSoundInteractionTranslator
implements BlockSoundInteractionTranslator {
    @Override
    public void translate(GeyserSession session, Vector3f position, BlockState state) {
        String identifier = state.toString();
        if (identifier.contains("iron")) {
            return;
        }
        SoundEvent event = this.getSound(state.getValue(Properties.OPEN, false), identifier);
        LevelSoundEventPacket levelSoundEventPacket = new LevelSoundEventPacket();
        levelSoundEventPacket.setPosition(position.add(0.5, 0.5, 0.5));
        levelSoundEventPacket.setBabySound(false);
        levelSoundEventPacket.setRelativeVolumeDisabled(false);
        levelSoundEventPacket.setIdentifier(":");
        levelSoundEventPacket.setSound(event);
        levelSoundEventPacket.setExtraData(session.getBlockMappings().getBedrockBlock(state).getRuntimeId());
        session.sendUpstreamPacket((BedrockPacket)levelSoundEventPacket);
    }

    private SoundEvent getSound(boolean open, String identifier) {
        if (identifier.contains("_door")) {
            return open ? SoundEvent.DOOR_OPEN : SoundEvent.DOOR_CLOSE;
        }
        if (identifier.contains("_trapdoor")) {
            return open ? SoundEvent.TRAPDOOR_OPEN : SoundEvent.TRAPDOOR_CLOSE;
        }
        return open ? SoundEvent.FENCE_GATE_OPEN : SoundEvent.FENCE_GATE_CLOSE;
    }
}

