/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.TrapDoorBlock;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;

public class SessionPlayerEntity
extends PlayerEntity {
    protected final Map<GeyserAttributeType, AttributeData> attributes = new Object2ObjectOpenHashMap<GeyserAttributeType, AttributeData>();
    private double blockInteractionRange = GeyserAttributeType.BLOCK_INTERACTION_RANGE.getDefaultValue();
    private boolean isRidingInFront;
    private Vector2f vehicleInput = Vector2f.ZERO;
    private int vehicleJumpStrength;
    private int lastAirSupply = this.getMaxAir();
    private boolean insideScaffolding = false;
    private Vector3f lastTickEndVelocity = Vector3f.ZERO;
    private Vector2f bedrockInteractRotation = Vector2f.ZERO;
    private boolean voidPositionDesynched;

    public SessionPlayerEntity(GeyserSession session) {
        super(session, -1, 1L, null, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, null, null);
        this.valid = true;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.PUSH_TOWARDS_CLOSEST_SPACE, true);
    }

    @Override
    protected void setClientSideSilent() {
    }

    @Override
    public void spawnEntity() {
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        if (this.voidPositionDesynched && !this.isBelowVoidFloor()) {
            this.voidPositionDesynched = false;
        }
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        this.session.getCollisionManager().updatePlayerBoundingBox(this.position.down(this.definition.offset()));
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.voidPositionDesynched && !this.isBelowVoidFloor()) {
            this.voidPositionDesynched = false;
        }
        super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.valid) {
            this.session.getCollisionManager().updatePlayerBoundingBox(position);
        }
        this.position = position.add(0.0f, this.definition.offset(), 0.0f);
    }

    public void updateOwnRotation(float yaw, float pitch, float headYaw) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(this.isOnGround());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
        movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        this.session.sendUpstreamPacket(movePlayerPacket);
    }

    public void setPositionManual(Vector3f position) {
        this.position = position;
    }

    @Override
    public void setFlags(ByteEntityMetadata entityMetadata) {
        if (!this.session.getGameMode().equals(GameMode.SPECTATOR)) {
            super.setFlags(entityMetadata);
        }
    }

    @Override
    protected void setSprinting(boolean value) {
        super.setSprinting(value);
        this.session.setSprinting(value);
    }

    @Override
    protected void setGliding(boolean value) {
        this.session.setGliding(value);
    }

    @Override
    protected void setSneaking(boolean value) {
        if (value) {
            this.session.startSneaking(false);
        } else {
            this.session.setShouldSendSneak(false);
            this.session.stopSneaking(false);
        }
    }

    @Override
    protected void setSpinAttack(boolean value) {
        this.session.setSpinAttack(value);
    }

    public void updateBoundingBox() {
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.getBoundingBoxHeight()));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.getBoundingBoxWidth()));
        this.updateBedrockMetadata();
    }

    @Override
    public boolean setBoundingBoxHeight(float height) {
        if (super.setBoundingBoxHeight(height)) {
            if (this.valid) {
                this.session.getCollisionManager().updatePlayerBoundingBox();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPose(Pose pose) {
        super.setPose(pose);
        this.session.setPose(pose);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    protected void setAirSupply(int amount) {
        this.setFlag(EntityFlag.BREATHING, amount >= this.lastAirSupply);
        this.lastAirSupply = amount;
        super.setAirSupply(amount);
    }

    @Override
    public void setRiderSeatPosition(Vector3f position) {
        super.setRiderSeatPosition(position);
        this.isRidingInFront = position != null && position.getX() > 0.0f;
    }

    @Override
    public AttributeData createHealthAttribute() {
        if (this.maxHealth % 2.0f == 1.0f) {
            this.maxHealth += 1.0f;
        }
        return super.createHealthAttribute();
    }

    @Override
    protected boolean hasShield(boolean offhand) {
        if (offhand) {
            return this.session.getPlayerInventory().getOffhand().asItem() == Items.SHIELD;
        }
        return this.session.getPlayerInventory().getItemInHand().asItem() == Items.SHIELD;
    }

    @Override
    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        if (javaAttribute.getType() == AttributeType.Builtin.ATTACK_SPEED) {
            this.session.setAttackSpeed(AttributeUtils.calculateValue(javaAttribute));
        } else if (javaAttribute.getType() == AttributeType.Builtin.BLOCK_INTERACTION_RANGE) {
            this.blockInteractionRange = AttributeUtils.calculateValue(javaAttribute);
        } else {
            super.updateAttribute(javaAttribute, newAttributes);
        }
    }

    @Override
    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        AttributeData attributeData = super.calculateAttribute(javaAttribute, type);
        this.attributes.put(type, attributeData);
        return attributeData;
    }

    public float attributeOrDefault(GeyserAttributeType type) {
        AttributeData attribute = this.attributes.get((Object)type);
        if (attribute == null) {
            return type.getDefaultValue();
        }
        return attribute.getValue();
    }

    public void setLastDeathPosition(@Nullable GlobalPos pos) {
        if (pos != null) {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_POS, pos.getPosition());
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_DIMENSION, DimensionUtils.javaToBedrock(pos.getDimension().asString()));
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, true);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, false);
        }
        this.setVoidPositionDesynched(false);
    }

    @Override
    public UUID getTabListUuid() {
        return this.session.getAuthData().uuid();
    }

    @Override
    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        this.attributes.put(GeyserAttributeType.ABSORPTION, GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue()));
        super.setAbsorptionHearts(entityMetadata);
    }

    @Override
    public void resetMetadata() {
        super.resetMetadata();
        this.resetAir();
        this.attributes.remove((Object)GeyserAttributeType.ABSORPTION);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(0.0f)));
        this.session.sendUpstreamPacket(attributesPacket);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, 0);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_AMBIENCE, (byte)0);
        this.dirtyMetadata.put(EntityDataTypes.FREEZING_EFFECT_STRENGTH, Float.valueOf(0.0f));
        this.silent = false;
    }

    public void resetAttributes() {
        this.attributes.clear();
        this.maxHealth = GeyserAttributeType.MAX_HEALTH.getDefaultValue();
        this.blockInteractionRange = GeyserAttributeType.BLOCK_INTERACTION_RANGE.getDefaultValue();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.MOVEMENT_SPEED.getAttribute()));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void resetAir() {
        this.setAirSupply(this.getMaxAir());
    }

    public void setVehicleInput(Vector2f vehicleInput) {
        this.vehicleInput = Vector2f.from(MathUtils.clamp(vehicleInput.getX(), -1.0f, 1.0f), MathUtils.clamp(vehicleInput.getY(), -1.0f, 1.0f));
    }

    public void setVehicleJumpStrength(int vehicleJumpStrength) {
        this.vehicleJumpStrength = MathUtils.constrain(vehicleJumpStrength, 0, 100);
    }

    @Override
    public void setVehicle(Entity entity) {
        if (entity instanceof BoatEntity) {
            entity.setBoundingBoxWidth(1.375f);
            entity.setBoundingBoxHeight(0.5625f);
            entity.updateBedrockMetadata();
        } else if (entity == null && this.vehicle instanceof BoatEntity) {
            this.vehicle.setBoundingBoxWidth(this.vehicle.getDefinition().width());
            this.vehicle.setBoundingBoxHeight(this.vehicle.getDefinition().height());
            this.vehicle.updateBedrockMetadata();
        }
        super.setVehicle(entity);
    }

    private boolean isBelowVoidFloor() {
        return this.position.getY() < (float)this.voidFloorPosition();
    }

    public int voidFloorPosition() {
        BedrockDimension bedrockDimension = this.session.getBedrockDimension();
        return bedrockDimension.minY() - 40;
    }

    public void teleportVoidFloorFix(boolean up) {
        if (this.voidPositionDesynched && !up || !this.voidPositionDesynched && up) {
            return;
        }
        Vector3f newPosition = this.getPosition();
        if (up) {
            newPosition = newPosition.up(4.0f);
            this.voidPositionDesynched = false;
        } else {
            newPosition = newPosition.down(4.0f);
            this.voidPositionDesynched = true;
        }
        this.setPositionManual(newPosition);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(newPosition);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
        movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        this.session.sendUpstreamPacketImmediately(movePlayerPacket);
    }

    public float getJumpVelocity() {
        float velocity = 0.42f;
        if (this.session.getGeyser().getWorldManager().blockAt(this.session, this.getPosition().sub(0.0f, EntityDefinitions.PLAYER.offset() + 0.1f, 0.0f).toInt()).is(Blocks.HONEY_BLOCK)) {
            velocity *= 0.6f;
        }
        return velocity + 0.1f * (float)this.session.getEffectCache().getJumpPower();
    }

    public boolean isOnClimbableBlock() {
        if (this.session.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        Vector3i pos = this.getPosition().down(EntityDefinitions.PLAYER.offset()).toInt();
        BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, pos);
        if (this.session.getTagCache().is(BlockTag.CLIMBABLE, state.block())) {
            return true;
        }
        if (state.block() instanceof TrapDoorBlock) {
            if (!state.getValue(Properties.OPEN).booleanValue()) {
                return false;
            }
            BlockState belowState = this.session.getGeyser().getWorldManager().blockAt(this.session, pos.down());
            return belowState.is(Blocks.LADDER) && belowState.getValue(Properties.HORIZONTAL_FACING) == state.getValue(Properties.HORIZONTAL_FACING);
        }
        return false;
    }

    public boolean canStartGliding() {
        if (this.session.getEffectCache().getEntityEffects().contains((Object)Effect.LEVITATION)) {
            return false;
        }
        if (this.isOnClimbableBlock() || this.session.getPlayerEntity().isOnGround()) {
            return false;
        }
        if (this.session.getCollisionManager().isPlayerTouchingWater()) {
            return false;
        }
        for (Map.Entry<EquipmentSlot, GeyserItemStack> entry : this.session.getPlayerInventory().getEquipment().entrySet()) {
            Equippable equippable;
            if (entry.getValue().getComponent(DataComponentTypes.GLIDER) != null && (equippable = entry.getValue().getComponent(DataComponentTypes.EQUIPPABLE)) != null && equippable.slot() == entry.getKey() && !entry.getValue().nextDamageWillBreak()) {
                return true;
            }
            if (entry.getKey() != EquipmentSlot.CHESTPLATE || entry.getValue().asItem().equals(Items.ELYTRA)) continue;
            return false;
        }
        return false;
    }

    public void forceFlagUpdate() {
        this.setFlagsDirty(true);
    }

    public boolean isGliding() {
        return this.getFlag(EntityFlag.GLIDING);
    }

    public Map<GeyserAttributeType, AttributeData> getAttributes() {
        return this.attributes;
    }

    public double getBlockInteractionRange() {
        return this.blockInteractionRange;
    }

    public boolean isRidingInFront() {
        return this.isRidingInFront;
    }

    public Vector2f getVehicleInput() {
        return this.vehicleInput;
    }

    public int getVehicleJumpStrength() {
        return this.vehicleJumpStrength;
    }

    public boolean isInsideScaffolding() {
        return this.insideScaffolding;
    }

    public void setInsideScaffolding(boolean insideScaffolding) {
        this.insideScaffolding = insideScaffolding;
    }

    public Vector3f getLastTickEndVelocity() {
        return this.lastTickEndVelocity;
    }

    public void setLastTickEndVelocity(Vector3f lastTickEndVelocity) {
        this.lastTickEndVelocity = lastTickEndVelocity;
    }

    public Vector2f getBedrockInteractRotation() {
        return this.bedrockInteractRotation;
    }

    public void setBedrockInteractRotation(Vector2f bedrockInteractRotation) {
        this.bedrockInteractRotation = bedrockInteractRotation;
    }

    public boolean isVoidPositionDesynched() {
        return this.voidPositionDesynched;
    }

    public void setVoidPositionDesynched(boolean voidPositionDesynched) {
        this.voidPositionDesynched = voidPositionDesynched;
    }
}

