/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.inventory.item.DyeColor;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MapHasher;
import org.geysermc.geyser.item.hashing.MinecraftHashEncoder;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Filterable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Unit;

@FunctionalInterface
public interface MinecraftHasher<Type> {
    public static final MinecraftHasher<Unit> UNIT = MinecraftHasher.unit();
    public static final MinecraftHasher<Byte> BYTE = (b, encoder) -> encoder.number((Number)b);
    public static final MinecraftHasher<Short> SHORT = (s, encoder) -> encoder.number((Number)s);
    public static final MinecraftHasher<Integer> INT = (i, encoder) -> encoder.number((Number)i);
    public static final MinecraftHasher<Long> LONG = (l, encoder) -> encoder.number((Number)l);
    public static final MinecraftHasher<Float> FLOAT = (f, encoder) -> encoder.number((Number)f);
    public static final MinecraftHasher<Double> DOUBLE = (d, encoder) -> encoder.number((Number)d);
    public static final MinecraftHasher<String> STRING = (s, encoder) -> encoder.string((String)s);
    public static final MinecraftHasher<Boolean> BOOL = (b, encoder) -> encoder.bool((boolean)b);
    public static final MinecraftHasher<IntStream> INT_ARRAY = (ints, encoder) -> encoder.intArray(ints.toArray());
    public static final MinecraftHasher<NbtMap> NBT_MAP = (map, encoder) -> encoder.nbtMap((NbtMap)map);
    public static final MinecraftHasher<NbtList<?>> NBT_LIST = (list, encoder) -> encoder.nbtList((NbtList<?>)list);
    public static final MinecraftHasher<Vector3i> POS = INT_ARRAY.cast(pos -> IntStream.of(pos.getX(), pos.getY(), pos.getZ()));
    public static final MinecraftHasher<Key> KEY = STRING.cast(Key::asString);
    public static final MinecraftHasher<Key> TAG = STRING.cast(key -> "#" + key.asString());
    public static final MinecraftHasher<Key> KEY_REMOVAL = STRING.cast(key -> "!" + key.asString());
    public static final MinecraftHasher<UUID> UUID = INT_ARRAY.cast(uuid -> {
        long mostSignificant = uuid.getMostSignificantBits();
        long leastSignificant = uuid.getLeastSignificantBits();
        return IntStream.of((int)(mostSignificant >> 32), (int)mostSignificant, (int)(leastSignificant >> 32), (int)leastSignificant);
    });
    public static final MinecraftHasher<GameProfile.Property> GAME_PROFILE_PROPERTY = MinecraftHasher.mapBuilder(builder -> builder.accept("name", STRING, GameProfile.Property::getName).accept("value", STRING, GameProfile.Property::getValue).optionalNullable("signature", STRING, GameProfile.Property::getSignature));
    public static final MinecraftHasher<GameProfile> GAME_PROFILE = MinecraftHasher.mapBuilder(builder -> builder.optionalNullable("name", STRING, GameProfile::getName).optionalNullable("id", UUID, GameProfile::getId).optionalList("properties", GAME_PROFILE_PROPERTY, GameProfile::getProperties));
    public static final MinecraftHasher<Integer> RARITY = MinecraftHasher.fromIdEnum((Enum[])Rarity.values(), Rarity::getName);
    public static final MinecraftHasher<Integer> DYE_COLOR = MinecraftHasher.fromIdEnum((Enum[])DyeColor.values(), DyeColor::getJavaIdentifier);
    public static final MinecraftHasher<EquipmentSlot> EQUIPMENT_SLOT = MinecraftHasher.fromEnum(slot -> switch (slot) {
        default -> throw new IncompatibleClassChangeError();
        case EquipmentSlot.MAIN_HAND -> "mainhand";
        case EquipmentSlot.OFF_HAND -> "offhand";
        case EquipmentSlot.BOOTS -> "feet";
        case EquipmentSlot.LEGGINGS -> "legs";
        case EquipmentSlot.CHESTPLATE -> "chest";
        case EquipmentSlot.HELMET -> "head";
        case EquipmentSlot.BODY -> "body";
        case EquipmentSlot.SADDLE -> "saddle";
    });
    public static final MinecraftHasher<ItemAttributeModifiers.EquipmentSlotGroup> EQUIPMENT_SLOT_GROUP = MinecraftHasher.fromEnum(group -> switch (group) {
        default -> throw new IncompatibleClassChangeError();
        case ItemAttributeModifiers.EquipmentSlotGroup.ANY -> "any";
        case ItemAttributeModifiers.EquipmentSlotGroup.MAIN_HAND -> "mainhand";
        case ItemAttributeModifiers.EquipmentSlotGroup.OFF_HAND -> "offhand";
        case ItemAttributeModifiers.EquipmentSlotGroup.HAND -> "hand";
        case ItemAttributeModifiers.EquipmentSlotGroup.FEET -> "feet";
        case ItemAttributeModifiers.EquipmentSlotGroup.LEGS -> "legs";
        case ItemAttributeModifiers.EquipmentSlotGroup.CHEST -> "chest";
        case ItemAttributeModifiers.EquipmentSlotGroup.HEAD -> "head";
        case ItemAttributeModifiers.EquipmentSlotGroup.ARMOR -> "armor";
        case ItemAttributeModifiers.EquipmentSlotGroup.BODY -> "body";
        case ItemAttributeModifiers.EquipmentSlotGroup.SADDLE -> "saddle";
    });
    public static final MinecraftHasher<GlobalPos> GLOBAL_POS = MinecraftHasher.mapBuilder(builder -> builder.accept("dimension", KEY, GlobalPos::getDimension).accept("pos", POS, GlobalPos::getPosition));

    public HashCode hash(Type var1, MinecraftHashEncoder var2);

    default public MinecraftHasher<List<Type>> list() {
        return (list, encoder) -> encoder.list(list.stream().map(element -> this.hash(element, encoder)).toList());
    }

    default public <Casted> MinecraftHasher<Casted> cast(Function<Casted, Type> converter) {
        return (value, encoder) -> this.hash(converter.apply(value), encoder);
    }

    default public <Casted> MinecraftHasher<Casted> sessionCast(BiFunction<GeyserSession, Casted, Type> converter) {
        return (value, encoder) -> this.hash(converter.apply(encoder.session(), value), encoder);
    }

    default public <Dispatched> MinecraftHasher<Dispatched> dispatch(Function<Dispatched, Type> typeExtractor, Function<Type, MapBuilder<Dispatched>> hashDispatch) {
        return this.dispatch("type", typeExtractor, hashDispatch);
    }

    default public <Dispatched> MinecraftHasher<Dispatched> dispatch(String typeKey, Function<Dispatched, Type> typeExtractor, Function<Type, MapBuilder<Dispatched>> mapDispatch) {
        return MinecraftHasher.mapBuilder(builder -> builder.accept(typeKey, this, typeExtractor).accept(typeExtractor, mapDispatch));
    }

    default public MinecraftHasher<Filterable<Type>> filterable() {
        return MinecraftHasher.mapBuilder(builder -> builder.accept("raw", this, Filterable::getRaw).optionalNullable("filtered", this, Filterable::getOptional));
    }

    public static <Type> MinecraftHasher<Type> unit() {
        return (value, encoder) -> encoder.emptyMap();
    }

    public static <Type> MinecraftHasher<Type> lazyInitialize(java.util.function.Supplier<MinecraftHasher<Type>> hasher) {
        Supplier memoized = Suppliers.memoize(hasher::get);
        return (arg_0, arg_1) -> MinecraftHasher.lambda$lazyInitialize$27((java.util.function.Supplier)memoized, arg_0, arg_1);
    }

    public static <EnumConstant extends Enum<EnumConstant>> MinecraftHasher<Integer> fromIdEnum(EnumConstant[] values) {
        return MinecraftHasher.fromIdEnum(values, (T constant) -> constant.name().toLowerCase(Locale.ROOT));
    }

    public static <EnumConstant extends Enum<EnumConstant>> MinecraftHasher<Integer> fromIdEnum(EnumConstant[] values, Function<EnumConstant, String> toName) {
        return STRING.cast(id -> (String)toName.apply(values[id]));
    }

    public static <EnumConstant extends Enum<EnumConstant>> MinecraftHasher<EnumConstant> fromEnum() {
        return MinecraftHasher.fromEnum(constant -> constant.name().toLowerCase(Locale.ROOT));
    }

    public static <EnumConstant extends Enum<EnumConstant>> MinecraftHasher<EnumConstant> fromEnum(Function<EnumConstant, String> toName) {
        return STRING.cast(toName);
    }

    public static <Type> MinecraftHasher<Type> mapBuilder(MapBuilder<Type> builder) {
        return (value, encoder) -> ((MapHasher)builder.apply(new MapHasher<Object>(value, encoder))).build();
    }

    public static <K, V> MinecraftHasher<Map<K, V>> map(MinecraftHasher<K> keyHasher, MinecraftHasher<V> valueHasher) {
        return MinecraftHasher.mapSet(keyHasher.cast(Map.Entry::getKey), valueHasher.cast(Map.Entry::getValue)).cast(Map::entrySet);
    }

    public static <Type> MinecraftHasher<Collection<Type>> mapSet(MinecraftHasher<Type> keyHasher, MinecraftHasher<Type> valueHasher) {
        return (set, encoder) -> encoder.map(set.stream().collect(Collectors.toMap(value -> keyHasher.hash(value, encoder), value -> valueHasher.hash(value, encoder))));
    }

    public static <Type, First, Second> MinecraftHasher<Type> either(MinecraftHasher<First> firstHasher, Function<Type, First> firstExtractor, MinecraftHasher<Second> secondHasher, Function<Type, Second> secondExtractor) {
        return (value, encoder) -> {
            Object first = firstExtractor.apply(value);
            if (first != null) {
                return firstHasher.hash(first, encoder);
            }
            return secondHasher.hash(secondExtractor.apply(value), encoder);
        };
    }

    public static <Type> MinecraftHasher<Type> dispatch(Function<Type, MinecraftHasher<Type>> hashDispatch) {
        return (value, encoder) -> ((MinecraftHasher)hashDispatch.apply(value)).hash(value, encoder);
    }

    private static /* synthetic */ HashCode lambda$lazyInitialize$27(java.util.function.Supplier memoized, Object value, MinecraftHashEncoder encoder) {
        return ((MinecraftHasher)memoized.get()).hash(value, encoder);
    }
}

