/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.util.MinecraftKey;

public class NumberRangeInput
extends DialogInput<Float> {
    public static final Key TYPE = MinecraftKey.key("number_range");
    private final float start;
    private final float end;
    private final float initial;
    private final float step;

    public NumberRangeInput(GeyserSession session, NbtMap map) {
        super(session, map);
        this.start = map.getFloat("start");
        this.end = map.getFloat("end");
        this.initial = map.getFloat("initial", this.start + (this.end - this.start) / 2.0f);
        this.step = map.getFloat("step", 1.0f);
    }

    @Override
    public void addComponent(CustomForm.Builder builder, Optional<Float> restored) {
        builder.slider(this.label, this.start, this.end, this.step, restored.orElse(Float.valueOf(this.initial)).floatValue());
    }

    @Override
    public Float read(CustomFormResponse response) throws DialogInputParseException {
        return Float.valueOf(response.asSlider());
    }

    @Override
    public String asSubstitution(Float value) {
        int rounded = value.intValue();
        return (float)rounded == value.floatValue() ? Integer.toString(rounded) : Float.toString(value.floatValue());
    }

    @Override
    public void addToMap(NbtMapBuilder builder, Float value) {
        builder.putFloat(this.key, value.floatValue());
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(this.initial);
    }
}

