/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.format.Style;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatTypeDecoration;

public record ChatDecoration(String translationKey, List<ChatTypeDecoration.Parameter> parameters, Style deserializedStyle) implements ChatTypeDecoration
{
    @Override
    public NbtMap style() {
        throw new UnsupportedOperationException();
    }

    public static ChatType readChatType(RegistryEntryContext context) {
        NbtMap tag = context.data();
        NbtMap chat = tag.getCompound("chat", null);
        if (chat != null) {
            String translationKey = chat.getString("translation_key");
            NbtMap styleTag = chat.getCompound("style");
            Style style = MessageTranslator.getStyleFromNbtMap(styleTag);
            ArrayList<ChatTypeDecoration.Parameter> parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            List parametersNbt = chat.getList("parameters", NbtType.STRING);
            for (String parameter : parametersNbt) {
                parameters.add(ChatTypeDecoration.Parameter.valueOf(parameter.toUpperCase(Locale.ROOT)));
            }
            return new ChatType(new ChatDecoration(translationKey, parameters, style), null);
        }
        return new ChatType(null, null);
    }

    public static Style getStyle(ChatTypeDecoration decoration) {
        if (decoration instanceof ChatDecoration) {
            ChatDecoration chatDecoration = (ChatDecoration)decoration;
            return chatDecoration.deserializedStyle();
        }
        return MessageTranslator.getStyleFromNbtMap(decoration.style());
    }
}

