/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.HappyGhastEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.HappyGhastVehicleComponent;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MobArmorEquipmentPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ColorParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType;

public class LivingEntity
extends Entity {
    protected EnumMap<EquipmentSlot, GeyserItemStack> equipment = new EnumMap(EquipmentSlot.class);
    protected float health = 1.0f;
    protected float maxHealth = 20.0f;
    private boolean isMaxFrozenState = false;
    private float scale;
    private float attributeScale;

    public LivingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public GeyserItemStack getItemInSlot(EquipmentSlot slot) {
        GeyserItemStack stack = this.equipment.get((Object)slot);
        if (stack == null) {
            return GeyserItemStack.EMPTY;
        }
        return stack;
    }

    public GeyserItemStack getMainHandItem() {
        return this.getItemInSlot(EquipmentSlot.MAIN_HAND);
    }

    public GeyserItemStack getOffHandItem() {
        return this.getItemInSlot(EquipmentSlot.OFF_HAND);
    }

    public boolean isHolding(Item item) {
        return this.getMainHandItem().is(item) || this.getOffHandItem().is(item);
    }

    public void setHelmet(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.HELMET, stack);
    }

    public void setChestplate(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.CHESTPLATE, stack);
    }

    public void setLeggings(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.LEGGINGS, stack);
    }

    public void setBoots(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.BOOTS, stack);
    }

    public void setBody(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.BODY, stack);
    }

    public void setSaddle(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.SADDLE, stack);
        boolean saddled = false;
        if (!stack.isEmpty()) {
            Equippable equippable = stack.getComponent(DataComponentTypes.EQUIPPABLE);
            saddled = equippable != null && equippable.slot() == EquipmentSlot.SADDLE;
        }
        this.updateSaddled(saddled);
    }

    public void setHand(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.MAIN_HAND, stack);
    }

    public void setOffhand(GeyserItemStack stack) {
        this.equipment.put(EquipmentSlot.OFF_HAND, stack);
    }

    protected void updateSaddled(boolean saddled) {
        this.setFlag(EntityFlag.SADDLED, saddled);
        this.updateBedrockMetadata();
        Entity mouseoverEntity = this.session.getMouseoverEntity();
        if (mouseoverEntity != null && mouseoverEntity.getEntityId() == this.entityId) {
            mouseoverEntity.updateInteractiveTag();
        }
    }

    public void switchHands() {
        GeyserItemStack offhand = this.equipment.get((Object)EquipmentSlot.OFF_HAND);
        this.equipment.put(EquipmentSlot.OFF_HAND, this.equipment.get((Object)EquipmentSlot.MAIN_HAND));
        this.equipment.put(EquipmentSlot.MAIN_HAND, offhand);
    }

    @Override
    protected void initializeMetadata() {
        this.scale = 1.0f;
        this.attributeScale = 1.0f;
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.STRUCTURAL_INTEGRITY, 1);
    }

    @Override
    public void updateNametag(@Nullable Team team) {
        this.updateNametag(team, team == null || team.isVisibleFor(this.session.getPlayerEntity().getUsername()));
    }

    public void setLivingEntityFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean isUsingItem = (xd & 1) == 1;
        boolean isUsingOffhand = (xd & 2) == 2;
        boolean isUsingShield = this.hasShield(isUsingOffhand);
        this.setFlag(EntityFlag.USING_ITEM, isUsingItem && !isUsingShield);
        this.setFlag(EntityFlag.BLOCKING, isUsingItem && isUsingShield);
        this.setSpinAttack((xd & 4) == 4);
        this.setFlag(EntityFlag.EMERGING, isUsingItem && isUsingOffhand);
    }

    protected void setSpinAttack(boolean value) {
        this.setFlag(EntityFlag.DAMAGE_NEARBY_MOBS, value);
    }

    public void setHealth(FloatEntityMetadata entityMetadata) {
        this.health = entityMetadata.getPrimitiveValue();
        AttributeData healthData = this.createHealthAttribute();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(healthData));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setParticles(ObjectEntityMetadata<List<Particle>> entityMetadata) {
        List<Particle> particles = entityMetadata.getValue();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int count = 0;
        for (Particle particle : particles) {
            if (particle.getType() != ParticleType.ENTITY_EFFECT) continue;
            int color = ((ColorParticleData)particle.getData()).getColor();
            r += (float)(color >> 16 & 0xFF) / 255.0f;
            g += (float)(color >> 8 & 0xFF) / 255.0f;
            b += (float)(color & 0xFF) / 255.0f;
            ++count;
        }
        int result = 0;
        if (count > 0) {
            r = r / (float)count * 255.0f;
            g = g / (float)count * 255.0f;
            b = b / (float)count * 255.0f;
            result = (int)r << 16 | (int)g << 8 | (int)b;
        }
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, result);
    }

    public @Nullable Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        Optional<Vector3i> optionalPos = entityMetadata.getValue();
        if (optionalPos.isPresent()) {
            Vector3i bedPosition = optionalPos.get();
            this.dirtyMetadata.put(EntityDataTypes.BED_POSITION, bedPosition);
            return bedPosition;
        }
        return null;
    }

    protected boolean hasShield(boolean offhand) {
        if (offhand) {
            return this.getOffHandItem().is(Items.SHIELD);
        }
        return this.getMainHandItem().is(Items.SHIELD);
    }

    @Override
    protected boolean isShaking() {
        return this.isMaxFrozenState;
    }

    @Override
    protected void setDimensionsFromPose(Pose pose) {
        if (pose == Pose.SLEEPING) {
            this.setBoundingBoxWidth(0.2f);
            this.setBoundingBoxHeight(0.2f);
        } else {
            super.setDimensionsFromPose(pose);
        }
    }

    @Override
    public float setFreezing(IntEntityMetadata entityMetadata) {
        float freezingPercentage = super.setFreezing(entityMetadata);
        this.isMaxFrozenState = freezingPercentage >= 1.0f;
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
        return freezingPercentage;
    }

    protected void setScale(float scale) {
        this.scale = scale;
        this.applyScale();
    }

    private void setAttributeScale(float scale) {
        this.attributeScale = MathUtils.clamp(scale, GeyserAttributeType.SCALE.getMinimum(), GeyserAttributeType.SCALE.getMaximum());
        this.applyScale();
    }

    private void applyScale() {
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(this.scale * this.attributeScale));
    }

    protected AttributeData createHealthAttribute() {
        return new AttributeData(GeyserAttributeType.HEALTH.getBedrockIdentifier(), 0.0f, this.maxHealth, (float)Math.ceil(this.health), this.maxHealth);
    }

    @Override
    public boolean isAlive() {
        return this.valid && this.health > 0.0f;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        InteractionResult result;
        GeyserItemStack itemStack = this.session.getPlayerInventory().getItemInHand(hand);
        if (itemStack.is(Items.NAME_TAG) && (result = this.checkInteractWithNameTag(itemStack)).consumesAction()) {
            return result;
        }
        return super.interact(hand);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        LivingEntity livingEntity = this;
        if (livingEntity instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            if (clientVehicle.isClientControlled()) {
                return;
            }
            clientVehicle.getVehicleComponent().moveRelative(relX, relY, relZ);
        }
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
    }

    @Override
    public boolean setBoundingBoxHeight(float height) {
        LivingEntity livingEntity;
        if (this.valid && (livingEntity = this) instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            clientVehicle.getVehicleComponent().setHeight(height);
        }
        return super.setBoundingBoxHeight(height);
    }

    @Override
    public void setBoundingBoxWidth(float width) {
        LivingEntity livingEntity;
        if (this.valid && (livingEntity = this) instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            clientVehicle.getVehicleComponent().setWidth(width);
        }
        super.setBoundingBoxWidth(width);
    }

    protected final InteractionResult checkInteractWithNameTag(GeyserItemStack itemStack) {
        if (itemStack.getComponent(DataComponentTypes.CUSTOM_NAME) != null) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void updateArmor() {
        if (!this.valid) {
            return;
        }
        GeyserItemStack helmet = this.getItemInSlot(EquipmentSlot.HELMET);
        GeyserItemStack chestplate = this.getItemInSlot(EquipmentSlot.CHESTPLATE);
        if (chestplate.isEmpty() && helmet.is(this.session, ItemTag.BANNERS)) {
            chestplate = helmet;
            helmet = GeyserItemStack.EMPTY;
        } else if (chestplate.is(this.session, ItemTag.BANNERS)) {
            chestplate = GeyserItemStack.EMPTY;
        }
        MobArmorEquipmentPacket armorEquipmentPacket = new MobArmorEquipmentPacket();
        armorEquipmentPacket.setRuntimeEntityId(this.geyserId);
        armorEquipmentPacket.setHelmet(ItemTranslator.translateToBedrock(this.session, helmet));
        armorEquipmentPacket.setChestplate(ItemTranslator.translateToBedrock(this.session, chestplate));
        armorEquipmentPacket.setLeggings(ItemTranslator.translateToBedrock(this.session, this.getItemInSlot(EquipmentSlot.LEGGINGS)));
        armorEquipmentPacket.setBoots(ItemTranslator.translateToBedrock(this.session, this.getItemInSlot(EquipmentSlot.BOOTS)));
        armorEquipmentPacket.setBody(ItemTranslator.translateToBedrock(this.session, this.getItemInSlot(EquipmentSlot.BODY)));
        this.session.sendUpstreamPacket(armorEquipmentPacket);
    }

    public void updateMainHand() {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket handPacket = new MobEquipmentPacket();
        handPacket.setRuntimeEntityId(this.geyserId);
        handPacket.setItem(ItemTranslator.translateToBedrock(this.session, this.getMainHandItem()));
        handPacket.setHotbarSlot(-1);
        handPacket.setInventorySlot(0);
        handPacket.setContainerId(0);
        this.session.sendUpstreamPacket(handPacket);
    }

    public void updateOffHand() {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket offHandPacket = new MobEquipmentPacket();
        offHandPacket.setRuntimeEntityId(this.geyserId);
        offHandPacket.setItem(ItemTranslator.translateToBedrock(this.session, this.getOffHandItem()));
        offHandPacket.setHotbarSlot(-1);
        offHandPacket.setInventorySlot(0);
        offHandPacket.setContainerId(119);
        this.session.sendUpstreamPacket(offHandPacket);
    }

    public boolean useArmSwingAttack() {
        return false;
    }

    public void updateBedrockAttributes(GeyserSession session, List<Attribute> attributes) {
        if (!this.valid) {
            return;
        }
        ArrayList<AttributeData> newAttributes = new ArrayList<AttributeData>();
        for (Attribute attribute : attributes) {
            this.updateAttribute(attribute, newAttributes);
        }
        if (newAttributes.isEmpty()) {
            return;
        }
        UpdateAttributesPacket updateAttributesPacket = new UpdateAttributesPacket();
        updateAttributesPacket.setRuntimeEntityId(this.geyserId);
        updateAttributesPacket.setAttributes(newAttributes);
        session.sendUpstreamPacket(updateAttributesPacket);
    }

    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        AttributeType attributeType = javaAttribute.getType();
        if (attributeType instanceof AttributeType.Builtin) {
            AttributeType.Builtin type = (AttributeType.Builtin)attributeType;
            switch (type) {
                case MAX_HEALTH: {
                    this.maxHealth = Math.max((float)AttributeUtils.calculateValue(javaAttribute), 1.0f);
                    newAttributes.add(this.createHealthAttribute());
                    break;
                }
                case MOVEMENT_SPEED: {
                    AttributeData attributeData = this.calculateAttribute(javaAttribute, GeyserAttributeType.MOVEMENT_SPEED);
                    newAttributes.add(attributeData);
                    LivingEntity livingEntity = this;
                    if (!(livingEntity instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
                    clientVehicle.getVehicleComponent().setMoveSpeed(attributeData.getValue());
                    break;
                }
                case STEP_HEIGHT: {
                    LivingEntity clientVehicle = this;
                    if (!(clientVehicle instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle2 = (ClientVehicle)((Object)clientVehicle);
                    clientVehicle2.getVehicleComponent().setStepHeight((float)AttributeUtils.calculateValue(javaAttribute));
                    break;
                }
                case GRAVITY: {
                    LivingEntity clientVehicle = this;
                    if (!(clientVehicle instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle2 = (ClientVehicle)((Object)clientVehicle);
                    clientVehicle2.getVehicleComponent().setGravity(AttributeUtils.calculateValue(javaAttribute));
                    break;
                }
                case ATTACK_DAMAGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.ATTACK_DAMAGE));
                    break;
                }
                case FLYING_SPEED: {
                    HappyGhastEntity ghast;
                    AttributeData attributeData = this.calculateAttribute(javaAttribute, GeyserAttributeType.FLYING_SPEED);
                    newAttributes.add(attributeData);
                    Object object = this;
                    if (!(object instanceof HappyGhastEntity) || !((object = (ghast = (HappyGhastEntity)object).getVehicleComponent()) instanceof HappyGhastVehicleComponent)) break;
                    HappyGhastVehicleComponent component = (HappyGhastVehicleComponent)object;
                    component.setFlyingSpeed(attributeData.getValue());
                    break;
                }
                case FOLLOW_RANGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.FOLLOW_RANGE));
                    break;
                }
                case KNOCKBACK_RESISTANCE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.KNOCKBACK_RESISTANCE));
                    break;
                }
                case JUMP_STRENGTH: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.HORSE_JUMP_STRENGTH));
                    break;
                }
                case SCALE: {
                    this.setAttributeScale((float)AttributeUtils.calculateValue(javaAttribute));
                    this.updateBedrockMetadata();
                    break;
                }
                case WATER_MOVEMENT_EFFICIENCY: {
                    LivingEntity livingEntity = this;
                    if (!(livingEntity instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle2 = (ClientVehicle)((Object)livingEntity);
                    clientVehicle2.getVehicleComponent().setWaterMovementEfficiency(AttributeUtils.calculateValue(javaAttribute));
                }
            }
        }
    }

    protected boolean hasBodyArmor() {
        return this.hasValidEquippableItemForSlot(EquipmentSlot.BODY);
    }

    private boolean hasValidEquippableItemForSlot(EquipmentSlot slot) {
        GeyserItemStack itemInSlot = this.equipment.get((Object)slot);
        if (itemInSlot != null) {
            Equippable equippable = itemInSlot.getComponent(DataComponentTypes.EQUIPPABLE);
            if (equippable != null) {
                return slot == equippable.slot() && this.canUseSlot(slot) && EntityUtils.equipmentUsableByEntity(this.session, equippable, this.definition.entityType());
            }
            return slot == EquipmentSlot.MAIN_HAND && this.canUseSlot(EquipmentSlot.MAIN_HAND);
        }
        return false;
    }

    protected boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        return type.getAttribute((float)AttributeUtils.calculateValue(javaAttribute));
    }

    public EnumMap<EquipmentSlot, GeyserItemStack> getEquipment() {
        return this.equipment;
    }

    public boolean isMaxFrozenState() {
        return this.isMaxFrozenState;
    }

    public void setEquipment(EnumMap<EquipmentSlot, GeyserItemStack> equipment) {
        this.equipment = equipment;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setMaxFrozenState(boolean isMaxFrozenState) {
        this.isMaxFrozenState = isMaxFrozenState;
    }
}

