/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.option;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;

public class OptionHolder
extends HashMap<ResourcePackOption.Type, ResourcePackOption<?>> {
    public OptionHolder() {
    }

    public OptionHolder(PriorityOption option) {
        this.put(option.type(), option);
    }

    public void validateAndAdd(ResourcePack pack, ResourcePackOption<?> ... options) {
        for (ResourcePackOption<?> option : options) {
            option.validate(pack);
            if (super.containsKey((Object)option.type())) {
                super.replace(option.type(), option);
                continue;
            }
            super.put(option.type(), option);
        }
    }

    public static <T> T valueOrFallback(@NonNull ResourcePackOption.Type type, @Nullable OptionHolder sessionPackOptions, @NonNull OptionHolder resourcePackOptions, @NonNull T defaultValue) {
        ResourcePackOption option;
        if (sessionPackOptions != null && (option = (ResourcePackOption)sessionPackOptions.get((Object)type)) != null) {
            return option.value();
        }
        option = (ResourcePackOption)resourcePackOptions.get((Object)type);
        if (option != null) {
            return option.value();
        }
        return defaultValue;
    }

    public static @Nullable ResourcePackOption<?> optionByType(@NonNull ResourcePackOption.Type type, @Nullable OptionHolder sessionPackOptions, @NonNull OptionHolder resourcePackOptions) {
        ResourcePackOption option;
        if (sessionPackOptions != null && (option = (ResourcePackOption)sessionPackOptions.get((Object)type)) != null) {
            return option;
        }
        return (ResourcePackOption)resourcePackOptions.get((Object)type);
    }

    public void remove(ResourcePackOption<?> option) {
        super.remove((Object)option.type());
    }

    public Collection<ResourcePackOption<?>> immutableValues() {
        return Collections.unmodifiableCollection(this.values());
    }

    public Collection<ResourcePackOption<?>> immutableValues(OptionHolder defaultValues) {
        HashMap combinedOptions = new HashMap(this);
        defaultValues.forEach(combinedOptions::putIfAbsent);
        return Collections.unmodifiableCollection(combinedOptions.values());
    }
}

