/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

public class ClientboundBlockEntityDataPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Vector3i position;
    @lombok.NonNull
    private final BlockEntityType type;
    private final @Nullable NbtMap nbt;

    public ClientboundBlockEntityDataPacket(ByteBuf in) {
        this.position = MinecraftTypes.readPosition(in);
        this.type = MinecraftTypes.readBlockEntityType(in);
        this.nbt = MinecraftTypes.readCompoundTag(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.position);
        MinecraftTypes.writeBlockEntityType(out, this.type);
        MinecraftTypes.writeAnyTag(out, this.nbt);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Vector3i getPosition() {
        return this.position;
    }

    @lombok.NonNull
    public BlockEntityType getType() {
        return this.type;
    }

    public @Nullable NbtMap getNbt() {
        return this.nbt;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundBlockEntityDataPacket)) {
            return false;
        }
        ClientboundBlockEntityDataPacket other = (ClientboundBlockEntityDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockEntityType this$type = this.getType();
        BlockEntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        NbtMap this$nbt = this.getNbt();
        NbtMap other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundBlockEntityDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockEntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        NbtMap $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundBlockEntityDataPacket(position=" + String.valueOf(this.getPosition()) + ", type=" + String.valueOf((Object)this.getType()) + ", nbt=" + String.valueOf(this.getNbt()) + ")";
    }

    public @NonNull ClientboundBlockEntityDataPacket withPosition(@lombok.NonNull Vector3i position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        return this.position == position ? this : new ClientboundBlockEntityDataPacket(position, this.type, this.nbt);
    }

    public @NonNull ClientboundBlockEntityDataPacket withType(@lombok.NonNull BlockEntityType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundBlockEntityDataPacket(this.position, type, this.nbt);
    }

    public @NonNull ClientboundBlockEntityDataPacket withNbt(@Nullable NbtMap nbt) {
        return this.nbt == nbt ? this : new ClientboundBlockEntityDataPacket(this.position, this.type, nbt);
    }

    public ClientboundBlockEntityDataPacket(@lombok.NonNull Vector3i position, @lombok.NonNull BlockEntityType type, @Nullable NbtMap nbt) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.position = position;
        this.type = type;
        this.nbt = nbt;
    }
}

