/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.HeightmapTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.LightUpdateData;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

public class ClientboundLevelChunkWithLightPacket
implements MinecraftPacket {
    private final int x;
    private final int z;
    private final byte @lombok.NonNull [] chunkData;
    @lombok.NonNull
    private final Map<HeightmapTypes, long[]> heightMaps;
    @lombok.NonNull
    private final @lombok.NonNull BlockEntityInfo @lombok.NonNull [] blockEntities;
    @lombok.NonNull
    private final LightUpdateData lightData;

    public ClientboundLevelChunkWithLightPacket(ByteBuf in) {
        int i;
        this.x = in.readInt();
        this.z = in.readInt();
        this.heightMaps = new EnumMap<HeightmapTypes, long[]>(HeightmapTypes.class);
        int length = MinecraftTypes.readVarInt(in);
        for (i = 0; i < length; ++i) {
            this.heightMaps.put(HeightmapTypes.from(MinecraftTypes.readVarInt(in)), MinecraftTypes.readLongArray(in));
        }
        this.chunkData = MinecraftTypes.readByteArray(in);
        this.blockEntities = new BlockEntityInfo[MinecraftTypes.readVarInt(in)];
        for (i = 0; i < this.blockEntities.length; ++i) {
            byte xz = in.readByte();
            int blockEntityX = xz >> 4 & 0xF;
            int blockEntityZ = xz & 0xF;
            short blockEntityY = in.readShort();
            BlockEntityType type = MinecraftTypes.readBlockEntityType(in);
            NbtMap tag = MinecraftTypes.readCompoundTag(in);
            this.blockEntities[i] = new BlockEntityInfo(blockEntityX, blockEntityY, blockEntityZ, type, tag);
        }
        this.lightData = MinecraftTypes.readLightUpdateData(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeInt(this.x);
        out.writeInt(this.z);
        MinecraftTypes.writeVarInt(out, this.heightMaps.size());
        for (Map.Entry<HeightmapTypes, long[]> entry : this.heightMaps.entrySet()) {
            MinecraftTypes.writeVarInt(out, entry.getKey().ordinal());
            MinecraftTypes.writeLongArray(out, entry.getValue());
        }
        MinecraftTypes.writeVarInt(out, this.chunkData.length);
        out.writeBytes(this.chunkData);
        MinecraftTypes.writeVarInt(out, this.blockEntities.length);
        for (BlockEntityInfo blockEntity : this.blockEntities) {
            out.writeByte((blockEntity.getX() & 0xF) << 4 | blockEntity.getZ() & 0xF);
            out.writeShort(blockEntity.getY());
            MinecraftTypes.writeBlockEntityType(out, blockEntity.getType());
            MinecraftTypes.writeAnyTag(out, blockEntity.getNbt());
        }
        MinecraftTypes.writeLightUpdateData(out, this.lightData);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public byte @lombok.NonNull [] getChunkData() {
        return this.chunkData;
    }

    @lombok.NonNull
    public Map<HeightmapTypes, long[]> getHeightMaps() {
        return this.heightMaps;
    }

    @lombok.NonNull
    public @lombok.NonNull BlockEntityInfo @lombok.NonNull [] getBlockEntities() {
        return this.blockEntities;
    }

    @lombok.NonNull
    public LightUpdateData getLightData() {
        return this.lightData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLevelChunkWithLightPacket)) {
            return false;
        }
        ClientboundLevelChunkWithLightPacket other = (ClientboundLevelChunkWithLightPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        if (!Arrays.equals(this.getChunkData(), other.getChunkData())) {
            return false;
        }
        Map<HeightmapTypes, long[]> this$heightMaps = this.getHeightMaps();
        Map<HeightmapTypes, long[]> other$heightMaps = other.getHeightMaps();
        if (this$heightMaps == null ? other$heightMaps != null : !((Object)this$heightMaps).equals(other$heightMaps)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBlockEntities(), other.getBlockEntities())) {
            return false;
        }
        LightUpdateData this$lightData = this.getLightData();
        LightUpdateData other$lightData = other.getLightData();
        return !(this$lightData == null ? other$lightData != null : !((Object)this$lightData).equals(other$lightData));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundLevelChunkWithLightPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        result = result * 59 + Arrays.hashCode(this.getChunkData());
        Map<HeightmapTypes, long[]> $heightMaps = this.getHeightMaps();
        result = result * 59 + ($heightMaps == null ? 43 : ((Object)$heightMaps).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBlockEntities());
        LightUpdateData $lightData = this.getLightData();
        result = result * 59 + ($lightData == null ? 43 : ((Object)$lightData).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundLevelChunkWithLightPacket(x=" + this.getX() + ", z=" + this.getZ() + ", chunkData=" + Arrays.toString(this.getChunkData()) + ", heightMaps=" + String.valueOf(this.getHeightMaps()) + ", blockEntities=" + Arrays.deepToString(this.getBlockEntities()) + ", lightData=" + String.valueOf(this.getLightData()) + ")";
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withX(int x) {
        return this.x == x ? this : new ClientboundLevelChunkWithLightPacket(x, this.z, this.chunkData, this.heightMaps, this.blockEntities, this.lightData);
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withZ(int z) {
        return this.z == z ? this : new ClientboundLevelChunkWithLightPacket(this.x, z, this.chunkData, this.heightMaps, this.blockEntities, this.lightData);
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withChunkData(byte @lombok.NonNull [] chunkData) {
        if (chunkData == null) {
            throw new NullPointerException("chunkData is marked non-null but is null");
        }
        return this.chunkData == chunkData ? this : new ClientboundLevelChunkWithLightPacket(this.x, this.z, chunkData, this.heightMaps, this.blockEntities, this.lightData);
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withHeightMaps(@lombok.NonNull Map<HeightmapTypes, long[]> heightMaps) {
        if (heightMaps == null) {
            throw new NullPointerException("heightMaps is marked non-null but is null");
        }
        return this.heightMaps == heightMaps ? this : new ClientboundLevelChunkWithLightPacket(this.x, this.z, this.chunkData, heightMaps, this.blockEntities, this.lightData);
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withBlockEntities(@lombok.NonNull @lombok.NonNull BlockEntityInfo @lombok.NonNull [] blockEntities) {
        if (blockEntities == null) {
            throw new NullPointerException("blockEntities is marked non-null but is null");
        }
        return this.blockEntities == blockEntities ? this : new ClientboundLevelChunkWithLightPacket(this.x, this.z, this.chunkData, this.heightMaps, blockEntities, this.lightData);
    }

    public @NonNull ClientboundLevelChunkWithLightPacket withLightData(@lombok.NonNull LightUpdateData lightData) {
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        return this.lightData == lightData ? this : new ClientboundLevelChunkWithLightPacket(this.x, this.z, this.chunkData, this.heightMaps, this.blockEntities, lightData);
    }

    public ClientboundLevelChunkWithLightPacket(int x, int z, byte @lombok.NonNull [] chunkData, @lombok.NonNull Map<HeightmapTypes, long[]> heightMaps, @lombok.NonNull @lombok.NonNull BlockEntityInfo @lombok.NonNull [] blockEntities, @lombok.NonNull LightUpdateData lightData) {
        if (heightMaps == null) {
            throw new NullPointerException("heightMaps is marked non-null but is null");
        }
        if (blockEntities == null) {
            throw new NullPointerException("blockEntities is marked non-null but is null");
        }
        if (lightData == null) {
            throw new NullPointerException("lightData is marked non-null but is null");
        }
        if (chunkData == null) {
            throw new NullPointerException("chunkData is marked non-null but is null");
        }
        this.x = x;
        this.z = z;
        this.chunkData = chunkData;
        this.heightMaps = heightMaps;
        this.blockEntities = blockEntities;
        this.lightData = lightData;
    }
}

