/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.factory.EntityFactory;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.translator.entity.EntityMetadataTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public record EntityDefinition<T extends Entity>(EntityFactory<T> factory, EntityType entityType, String identifier, float width, float height, float offset, GeyserEntityProperties registeredProperties, List<EntityMetadataTranslator<? super T, ?, ?>> translators) {
    public static <T extends Entity> Builder<T> inherited(EntityFactory<T> factory, EntityDefinition<? super T> parent) {
        return new Builder<T>(factory, parent.entityType, parent.identifier, parent.width, parent.height, parent.offset, new ObjectArrayList(parent.translators));
    }

    public static <T extends Entity> Builder<T> builder(EntityFactory<T> factory) {
        return new Builder<T>(factory);
    }

    public <M> void translateMetadata(T entity, EntityMetadata<M, ? extends MetadataType<M>> metadata) {
        EntityMetadataTranslator<T, ?, ?> translator = this.translators.get(metadata.getId());
        if (translator == null) {
            return;
        }
        if (translator.acceptedType() != metadata.getType()) {
            GeyserImpl.getInstance().getLogger().warning("Metadata ID " + metadata.getId() + " was received with type " + String.valueOf(metadata.getType()) + " but we expected " + String.valueOf(translator.acceptedType()) + " for " + String.valueOf((Object)((Entity)entity).getDefinition().entityType()));
            if (GeyserImpl.getInstance().config().debugMode()) {
                GeyserImpl.getInstance().getLogger().debug(metadata.toString());
            }
            return;
        }
        translator.translate(entity, metadata);
    }

    public static class Builder<T extends Entity> {
        private final EntityFactory<T> factory;
        private EntityType type;
        private String identifier;
        private float width;
        private float height;
        private float offset = 1.0E-5f;
        private GeyserEntityProperties.Builder propertiesBuilder;
        private final List<EntityMetadataTranslator<? super T, ?, ?>> translators;

        private Builder(EntityFactory<T> factory) {
            this.factory = factory;
            this.translators = new ObjectArrayList();
        }

        public Builder(EntityFactory<T> factory, EntityType type, String identifier, float width, float height, float offset, List<EntityMetadataTranslator<? super T, ?, ?>> translators) {
            this.factory = factory;
            this.type = type;
            this.identifier = identifier;
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.translators = translators;
        }

        public Builder<T> heightAndWidth(float value) {
            this.height = value;
            this.width = value;
            return this;
        }

        public Builder<T> offset(float offset) {
            this.offset = offset + 1.0E-5f;
            return this;
        }

        public Builder<T> type(EntityType type) {
            this.type = type;
            this.identifier = null;
            return this;
        }

        public Builder<T> property(PropertyType<?, ?> propertyType) {
            if (this.propertiesBuilder == null) {
                this.propertiesBuilder = new GeyserEntityProperties.Builder(this.identifier);
            }
            this.propertiesBuilder.add(propertyType);
            return this;
        }

        public <U, EM extends EntityMetadata<U, ? extends MetadataType<U>>> Builder<T> addTranslator(MetadataType<U> type, BiConsumer<T, EM> translateFunction) {
            this.translators.add(new EntityMetadataTranslator<T, U, EM>(type, translateFunction));
            return this;
        }

        public Builder<T> addTranslator(EntityMetadataTranslator<T, ?, ?> translator) {
            this.translators.add(translator);
            return this;
        }

        public EntityDefinition<T> build() {
            return this.build(true);
        }

        public EntityDefinition<T> build(boolean register) {
            if (this.identifier == null && this.type != null) {
                this.identifier = "minecraft:" + this.type.name().toLowerCase(Locale.ROOT);
            }
            GeyserEntityProperties registeredProperties = this.propertiesBuilder == null ? new GeyserEntityProperties() : this.propertiesBuilder.build();
            EntityDefinition<T> definition = new EntityDefinition<T>(this.factory, this.type, this.identifier, this.width, this.height, this.offset, registeredProperties, this.translators);
            if (register && definition.entityType() != null) {
                ((Map)Registries.ENTITY_DEFINITIONS.get()).putIfAbsent(definition.entityType(), definition);
                ((Map)Registries.JAVA_ENTITY_IDENTIFIERS.get()).putIfAbsent("minecraft:" + this.type.name().toLowerCase(Locale.ROOT), definition);
            }
            return definition;
        }

        public Builder<T> identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder<T> width(float width) {
            this.width = width;
            return this;
        }

        public Builder<T> height(float height) {
            this.height = height;
            return this;
        }

        public Builder<T> propertiesBuilder(GeyserEntityProperties.Builder propertiesBuilder) {
            this.propertiesBuilder = propertiesBuilder;
            return this;
        }
    }
}

