/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.Optional;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.properties.type.IntProperty;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public class CreakingEntity
extends MonsterEntity {
    public static final EnumProperty<CreakingState> STATE_PROPERTY = new EnumProperty<CreakingState>(IdentifierImpl.of("creaking_state"), CreakingState.class, CreakingState.NEUTRAL);
    public static final IntProperty SWAYING_TICKS_PROPERTY = new IntProperty(IdentifierImpl.of("creaking_swaying_ticks"), 6, 0, 0);
    private Vector3i homePosition;

    public CreakingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    public void setCanMove(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        this.setFlag(EntityFlag.BODY_ROTATION_BLOCKED, booleanEntityMetadata.getValue() == false);
        STATE_PROPERTY.apply(this.propertyManager, booleanEntityMetadata.getValue() != false ? CreakingState.HOSTILE_UNOBSERVED : CreakingState.HOSTILE_OBSERVED);
        this.updateBedrockEntityProperties();
    }

    public void setActive(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (!booleanEntityMetadata.getValue().booleanValue()) {
            STATE_PROPERTY.apply(this.propertyManager, CreakingState.NEUTRAL);
        }
    }

    public void setIsTearingDown(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (booleanEntityMetadata.getValue().booleanValue()) {
            STATE_PROPERTY.apply(this.propertyManager, CreakingState.CRUMBLING);
            this.updateBedrockEntityProperties();
        }
    }

    public void setHomePos(EntityMetadata<Optional<Vector3i>, ? extends MetadataType<Optional<Vector3i>>> optionalEntityMetadata) {
        this.homePosition = optionalEntityMetadata.getValue().isPresent() ? optionalEntityMetadata.getValue().get() : null;
    }

    public void createParticleBeam() {
        if (this.homePosition != null) {
            LevelEventGenericPacket levelEventGenericPacket = new LevelEventGenericPacket();
            levelEventGenericPacket.setType(LevelEvent.PARTICLE_CREAKING_HEART_TRIAL);
            levelEventGenericPacket.setTag(NbtMap.builder().putInt("CreakingAmount", 20).putFloat("CreakingX", this.position.getX()).putFloat("CreakingY", this.position.getY()).putFloat("CreakingZ", this.position.getZ()).putInt("HeartAmount", 20).putFloat("HeartX", this.homePosition.getX()).putFloat("HeartY", this.homePosition.getY()).putFloat("HeartZ", this.homePosition.getZ()).build());
            this.session.sendUpstreamPacket(levelEventGenericPacket);
        }
    }

    public static enum CreakingState {
        NEUTRAL,
        HOSTILE_OBSERVED,
        HOSTILE_UNOBSERVED,
        TWITCHING,
        CRUMBLING;

    }
}

