/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reference;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.io.leangen.geantyref.TypeToken;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.ConfigurateException;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.ConfigurationNode;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.NodePath;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.ScopedConfigurationNode;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.loader.ConfigurationLoader;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reactive.Processor;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reactive.Publisher;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reference.ConfigurationReference;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reference.ValueReference;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.reference.ValueReferenceImpl;
import org.geysermc.geyser.platform.spigot.shaded.org.spongepowered.configurate.serialize.SerializationException;

class ManualConfigurationReference<N extends ScopedConfigurationNode<N>>
implements ConfigurationReference<N> {
    protected volatile @MonotonicNonNull N node;
    private final ConfigurationLoader<? extends N> loader;
    protected final Processor.TransactionalIso<N> updateListener;
    protected final Processor.Iso<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errorListener;

    ManualConfigurationReference(ConfigurationLoader<? extends N> loader, Executor taskExecutor) {
        this.loader = loader;
        this.updateListener = Processor.createTransactional(taskExecutor);
        this.errorListener = Processor.create(taskExecutor);
        this.errorListener.fallbackHandler(it -> {
            System.err.println("Unhandled error while performing a " + String.valueOf(it.getKey()) + " for a configuration reference: " + String.valueOf(it.getValue()));
            ((Throwable)it.getValue()).printStackTrace();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() throws ConfigurateException {
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            this.node = (ScopedConfigurationNode)this.loader.load();
            this.updateListener.submit(this.node);
        }
    }

    @Override
    public final void save() throws ConfigurateException {
        this.save((ConfigurationNode)this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationNode newNode) throws ConfigurateException {
        Objects.requireNonNull(newNode, "newNode");
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            N existing = this.node;
            if (existing.getClass().equals(newNode.getClass())) {
                this.node = (ScopedConfigurationNode)newNode;
                this.loader.save((ConfigurationNode)this.node);
                if (newNode != existing) {
                    this.updateListener.submit(this.node);
                }
            } else {
                this.loader.save(this.node.from(newNode));
                this.updateListener.submit(this.node);
            }
        }
    }

    @Override
    public final Publisher<N> saveAsync() {
        return Publisher.execute(() -> {
            this.save();
            return this.node();
        }, this.updateListener.executor());
    }

    @Override
    public final Publisher<N> updateAsync(Function<N, ? extends N> updater) {
        return Publisher.execute(() -> {
            ScopedConfigurationNode newNode = (ScopedConfigurationNode)updater.apply(this.node());
            this.save(newNode);
            return newNode;
        }, this.updateListener.executor());
    }

    @Override
    public final N node() {
        return this.node;
    }

    @Override
    public final ConfigurationLoader<? extends N> loader() {
        return this.loader;
    }

    @Override
    public final N get(Object ... path) {
        return (N)this.node().node(path);
    }

    @Override
    public final N get(Iterable<?> path) {
        return (N)this.node().node((Iterable)path);
    }

    @Override
    public final <T> ValueReference<T, N> referenceTo(TypeToken<T> type, NodePath path, @Nullable T def) throws SerializationException {
        return new ValueReferenceImpl(this, path, type, def);
    }

    @Override
    public final <T> ValueReference<T, N> referenceTo(Class<T> type, NodePath path, @Nullable T def) throws SerializationException {
        return new ValueReferenceImpl(this, path, type, def);
    }

    @Override
    public final Publisher<N> updates() {
        return this.updateListener;
    }

    @Override
    public final Publisher<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errors() {
        return this.errorListener;
    }

    @Override
    public void close() {
        this.updateListener.onClose();
    }
}

