/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v544.serializer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v354.serializer.ClientboundMapItemDataSerializer_v354;
import org.cloudburstmc.protocol.bedrock.data.MapDecoration;
import org.cloudburstmc.protocol.bedrock.data.MapTrackedObject;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.longs.LongList;

public class ClientboundMapItemDataSerializer_v544
extends ClientboundMapItemDataSerializer_v354 {
    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        LongList trackedEntityIds;
        VarInts.writeLong(buffer, packet.getUniqueMapId());
        int type = 0;
        int[] colors = packet.getColors();
        if (colors != null && colors.length > 0) {
            type |= 2;
        }
        List<MapDecoration> decorations = packet.getDecorations();
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        if (!decorations.isEmpty() && !trackedObjects.isEmpty()) {
            type |= 4;
        }
        if (!(trackedEntityIds = packet.getTrackedEntityIds()).isEmpty()) {
            type |= 8;
        }
        VarInts.writeUnsignedInt(buffer, type);
        buffer.writeByte(packet.getDimensionId());
        buffer.writeBoolean(packet.isLocked());
        helper.writeVector3i(buffer, packet.getOrigin());
        if ((type & 8) != 0) {
            this.writeMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            buffer.writeByte(packet.getScale());
        }
        if ((type & 4) != 0) {
            this.writeMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.writeTextureUpdate(buffer, helper, packet);
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        packet.setUniqueMapId(VarInts.readLong(buffer));
        int type = VarInts.readUnsignedInt(buffer);
        packet.setDimensionId(buffer.readUnsignedByte());
        packet.setLocked(buffer.readBoolean());
        packet.setOrigin(helper.readVector3i(buffer));
        if ((type & 8) != 0) {
            this.readMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            packet.setScale(buffer.readUnsignedByte());
        }
        if ((type & 4) != 0) {
            this.readMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.readTextureUpdate(buffer, helper, packet);
        }
    }
}

