/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.world.manager;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DecoratedPot;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.erosion.bukkit.BukkitUtils;
import org.geysermc.erosion.bukkit.SchedulerUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class GeyserSpigotWorldManager
extends WorldManager {
    private final Plugin plugin;

    public GeyserSpigotWorldManager(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        Player bukkitPlayer = Bukkit.getPlayer((String)session.getPlayerEntity().getUsername());
        if (bukkitPlayer == null) {
            return 0;
        }
        World world = bukkitPlayer.getWorld();
        if (!world.isChunkLoaded(x >> 4, z >> 4)) {
            return 0;
        }
        return this.getBlockNetworkId(world.getBlockAt(x, y, z));
    }

    public int getBlockNetworkId(Block block) {
        if (SchedulerUtils.FOLIA && !Bukkit.isOwnedByCurrentRegion((Block)block)) {
            CompletableFuture blockData = new CompletableFuture();
            Bukkit.getRegionScheduler().execute(this.plugin, block.getLocation(), () -> blockData.complete(block.getBlockData().getAsString()));
            return BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault((String)blockData.join(), 0);
        }
        return BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault(block.getBlockData().getAsString(), 0);
    }

    @Override
    public boolean hasOwnChunkCache() {
        return true;
    }

    @Override
    public boolean getGameRuleBool(GeyserSession session, org.geysermc.geyser.level.GameRule gameRule) {
        GameRule bukkitGameRule = GameRule.getByName((String)gameRule.getJavaID());
        if (bukkitGameRule == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown game rule " + gameRule.getJavaID());
            return gameRule.getDefaultBooleanValue();
        }
        Player bukkitPlayer = Objects.requireNonNull(Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid()));
        Object value = bukkitPlayer.getWorld().getGameRuleValue(bukkitGameRule);
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        GeyserImpl.getInstance().getLogger().debug("Expected a bool for " + String.valueOf((Object)gameRule) + " but got " + String.valueOf(value));
        return gameRule.getDefaultBooleanValue();
    }

    @Override
    public int getGameRuleInt(GeyserSession session, org.geysermc.geyser.level.GameRule gameRule) {
        GameRule bukkitGameRule = GameRule.getByName((String)gameRule.getJavaID());
        if (bukkitGameRule == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown game rule " + gameRule.getJavaID());
            return gameRule.getDefaultIntValue();
        }
        Player bukkitPlayer = Objects.requireNonNull(Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid()));
        Object value = bukkitPlayer.getWorld().getGameRuleValue(bukkitGameRule);
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue;
        }
        GeyserImpl.getInstance().getLogger().debug("Expected an int for " + String.valueOf((Object)gameRule) + " but got " + String.valueOf(value));
        return gameRule.getDefaultIntValue();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.byId(Bukkit.getDefaultGameMode().ordinal());
    }

    @Override
    public void getDecoratedPotData(GeyserSession session, Vector3i pos, Consumer<List<String>> apply) {
        Player bukkitPlayer = Bukkit.getPlayer((UUID)session.getPlayerEntity().getUuid());
        if (bukkitPlayer == null) {
            return;
        }
        Block block = bukkitPlayer.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
        SchedulerUtils.runTask(this.plugin, () -> {
            BlockState state = BukkitUtils.getBlockState(block);
            if (!(state instanceof DecoratedPot)) {
                return;
            }
            DecoratedPot pot = (DecoratedPot)state;
            apply.accept(pot.getShards().stream().map(material -> material.getKey().toString()).toList());
        }, block);
    }

    public boolean isLegacy() {
        return false;
    }
}

