/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.versions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;

public abstract class MappingsReader {
    public abstract void readItemMappings(Path var1, JsonObject var2, BiConsumer<String, CustomItemData> var3);

    public abstract void readBlockMappings(Path var1, JsonObject var2, BiConsumer<String, CustomBlockMapping> var3);

    public abstract CustomItemData readItemMappingEntry(JsonObject var1) throws InvalidCustomMappingsFileException;

    public abstract CustomBlockMapping readBlockMappingEntry(String var1, JsonObject var2) throws InvalidCustomMappingsFileException;

    protected @Nullable CustomRenderOffsets fromJsonObject(JsonObject node) {
        if (node == null) {
            return null;
        }
        return new CustomRenderOffsets(this.getHandOffsets(node, "main_hand"), this.getHandOffsets(node, "off_hand"));
    }

    protected @Nullable CustomRenderOffsets.Hand getHandOffsets(JsonObject node, String hand) {
        JsonElement jsonElement = node.get(hand);
        if (!(jsonElement instanceof JsonObject)) {
            return null;
        }
        JsonObject tmpNode = (JsonObject)jsonElement;
        return new CustomRenderOffsets.Hand(this.getPerspectiveOffsets(tmpNode, "first_person"), this.getPerspectiveOffsets(tmpNode, "third_person"));
    }

    protected @Nullable CustomRenderOffsets.Offset getPerspectiveOffsets(JsonObject node, String perspective) {
        JsonElement jsonElement = node.get(perspective);
        if (!(jsonElement instanceof JsonObject)) {
            return null;
        }
        JsonObject tmpNode = (JsonObject)jsonElement;
        return new CustomRenderOffsets.Offset(this.getOffsetXYZ(tmpNode, "position"), this.getOffsetXYZ(tmpNode, "rotation"), this.getOffsetXYZ(tmpNode, "scale"));
    }

    protected @Nullable CustomRenderOffsets.OffsetXYZ getOffsetXYZ(JsonObject node, String offsetType) {
        JsonElement jsonElement = node.get(offsetType);
        if (!(jsonElement instanceof JsonObject)) {
            return null;
        }
        JsonObject tmpNode = (JsonObject)jsonElement;
        if (!(tmpNode.has("x") && tmpNode.has("y") && tmpNode.has("z"))) {
            return null;
        }
        return new CustomRenderOffsets.OffsetXYZ(tmpNode.get("x").getAsFloat(), tmpNode.get("y").getAsFloat(), tmpNode.get("z").getAsFloat());
    }
}

