/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.level.block.type.BannerBlock;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.BANNER})
public class BannerBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, @Nullable NbtMap javaNbt, BlockState blockState) {
        String customName;
        Block block = blockState.block();
        if (block instanceof BannerBlock) {
            BannerBlock banner = (BannerBlock)block;
            bedrockNbt.putInt("Base", 15 - banner.dyeColor());
        }
        if (javaNbt == null) {
            return;
        }
        List patterns = javaNbt.getList("patterns", NbtType.COMPOUND);
        if (!patterns.isEmpty()) {
            if (BannerItem.isOminous(patterns)) {
                bedrockNbt.putInt("Type", 1);
            } else {
                bedrockNbt.putList("Patterns", NbtType.COMPOUND, BannerItem.convertBannerPattern(patterns));
            }
        }
        if ((customName = javaNbt.getString("CustomName", null)) != null) {
            bedrockNbt.putString("CustomName", customName);
        }
    }
}

