/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityProperty;
import org.cloudburstmc.protocol.bedrock.data.entity.FloatEntityProperty;
import org.cloudburstmc.protocol.bedrock.data.entity.IntEntityProperty;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.entity.properties.type.PropertyType;

public class GeyserEntityPropertyManager {
    private final GeyserEntityProperties properties;
    private final Object2ObjectMap<String, IntEntityProperty> intEntityProperties = new Object2ObjectArrayMap();
    private final Object2ObjectMap<String, FloatEntityProperty> floatEntityProperties = new Object2ObjectArrayMap();

    public GeyserEntityPropertyManager(GeyserEntityProperties properties) {
        this.properties = properties;
        for (PropertyType<?, ?> property : properties.getProperties()) {
            String name = property.identifier().toString();
            int index = properties.getPropertyIndex(name);
            this.addProperty(name, (EntityProperty)property.defaultValue(index));
        }
    }

    public <T> void addProperty(PropertyType<T, ? extends EntityProperty> propertyType, T value) {
        int index = this.properties.getPropertyIndex(propertyType.identifier().toString());
        this.addProperty(propertyType.identifier().toString(), propertyType.createValue(index, value));
    }

    private void addProperty(String propertyName, EntityProperty entityProperty) {
        if (entityProperty instanceof FloatEntityProperty) {
            FloatEntityProperty floatEntityProperty = (FloatEntityProperty)entityProperty;
            this.floatEntityProperties.put((Object)propertyName, (Object)floatEntityProperty);
        } else if (entityProperty instanceof IntEntityProperty) {
            IntEntityProperty intEntityProperty = (IntEntityProperty)entityProperty;
            this.intEntityProperties.put((Object)propertyName, (Object)intEntityProperty);
        }
    }

    public boolean hasFloatProperties() {
        return !this.floatEntityProperties.isEmpty();
    }

    public boolean hasIntProperties() {
        return !this.intEntityProperties.isEmpty();
    }

    public boolean hasProperties() {
        return this.hasFloatProperties() || this.hasIntProperties();
    }

    public void applyIntProperties(List<IntEntityProperty> properties) {
        properties.addAll((Collection<IntEntityProperty>)this.intEntityProperties.values());
        this.intEntityProperties.clear();
    }

    public void applyFloatProperties(List<FloatEntityProperty> properties) {
        properties.addAll((Collection<FloatEntityProperty>)this.floatEntityProperties.values());
        this.floatEntityProperties.clear();
    }

    public NbtMap toNbtMap(String entityType) {
        return this.properties.toNbtMap(entityType);
    }
}

