/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class ThrowableEntity
extends Entity
implements Tickable {
    protected Vector3f lastJavaPosition;

    public ThrowableEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.lastJavaPosition = position;
    }

    @Override
    public void tick() {
        if (this.removedInVoid()) {
            return;
        }
        this.moveAbsoluteImmediate(this.position.add(this.motion), this.getYaw(), this.getPitch(), this.getHeadYaw(), this.isOnGround(), false);
        float drag = this.getDrag();
        float gravity = this.getGravity();
        this.motion = this.motion.mul(drag).down(gravity);
    }

    protected void moveAbsoluteImmediate(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        MoveEntityDeltaPacket moveEntityDeltaPacket = new MoveEntityDeltaPacket();
        moveEntityDeltaPacket.setRuntimeEntityId(this.geyserId);
        if (isOnGround) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        this.setOnGround(isOnGround);
        if (teleported) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.TELEPORTING);
        }
        if (this.position.getX() != position.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityDeltaPacket.setX(position.getX());
        }
        if (this.position.getY() != position.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityDeltaPacket.setY(position.getY());
        }
        if (this.position.getZ() != position.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityDeltaPacket.setZ(position.getZ());
        }
        this.setPosition(position);
        if (this.getYaw() != yaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityDeltaPacket.setYaw(yaw);
            this.setYaw(yaw);
        }
        if (this.getPitch() != pitch) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            moveEntityDeltaPacket.setPitch(pitch);
            this.setPitch(pitch);
        }
        if (this.getHeadYaw() != headYaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            moveEntityDeltaPacket.setHeadYaw(headYaw);
            this.setHeadYaw(headYaw);
        }
        if (!moveEntityDeltaPacket.getFlags().isEmpty()) {
            this.session.sendUpstreamPacket((BedrockPacket)moveEntityDeltaPacket);
        }
    }

    protected float getGravity() {
        if (this.getFlag(EntityFlag.HAS_GRAVITY)) {
            switch (this.definition.entityType()) {
                case LINGERING_POTION: 
                case SPLASH_POTION: {
                    return 0.05f;
                }
                case EXPERIENCE_BOTTLE: {
                    return 0.07f;
                }
                case FIREBALL: 
                case SHULKER_BULLET: {
                    return 0.0f;
                }
                case SNOWBALL: 
                case EGG: 
                case ENDER_PEARL: {
                    return 0.03f;
                }
                case LLAMA_SPIT: {
                    return 0.06f;
                }
            }
        }
        return 0.0f;
    }

    protected float getDrag() {
        if (this.isInWater()) {
            return 0.8f;
        }
        switch (this.definition.entityType()) {
            case LINGERING_POTION: 
            case SPLASH_POTION: 
            case EXPERIENCE_BOTTLE: 
            case SNOWBALL: 
            case EGG: 
            case ENDER_PEARL: 
            case LLAMA_SPIT: {
                return 0.99f;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: 
            case DRAGON_FIREBALL: {
                return 0.95f;
            }
            case SHULKER_BULLET: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    protected boolean isInWater() {
        int block = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.position.toInt());
        return BlockStateValues.getWaterLevel(block) != -1;
    }

    @Override
    public void despawnEntity() {
        if (this.definition.entityType() == EntityType.ENDER_PEARL) {
            LevelEventPacket particlePacket = new LevelEventPacket();
            particlePacket.setType((LevelEventType)LevelEvent.PARTICLE_TELEPORT);
            particlePacket.setPosition(this.position);
            this.session.sendUpstreamPacket((BedrockPacket)particlePacket);
        }
        super.despawnEntity();
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveAbsoluteImmediate(this.lastJavaPosition.add(relX, relY, relZ), yaw, pitch, headYaw, isOnGround, false);
        this.lastJavaPosition = this.position;
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.moveAbsoluteImmediate(position, yaw, pitch, headYaw, isOnGround, teleported);
        this.lastJavaPosition = position;
    }

    public boolean removedInVoid() {
        if (this.position.getY() < (float)(this.session.getDimensionType().minY() - 64)) {
            this.session.getEntityCache().removeEntity(this);
            return true;
        }
        return false;
    }
}

