/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class DecoratedPotItem
extends BlockItem {
    public DecoratedPotItem(Item.Builder builder, Block block, Block ... otherBlocks) {
        super(builder, block, otherBlocks);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        List decorations = (List)components.get(DataComponentTypes.POT_DECORATIONS);
        if (decorations != null) {
            ArrayList<String> sherds = new ArrayList<String>(decorations.size());
            for (Integer decoration : decorations) {
                ItemMapping mapping = session.getItemMappings().getMapping(decoration);
                sherds.add(mapping.getBedrockIdentifier());
            }
            builder.putList("sherds", NbtType.STRING, sherds);
        }
    }
}

