/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod.world;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class GeyserModWorldManager
extends GeyserWorldManager {
    private final MinecraftServer server;

    public GeyserModWorldManager(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public int getBlockAt(GeyserSession session, int x, int y, int z) {
        LevelChunkSection section;
        if (SharedConstants.getCurrentVersion().protocolVersion() != GameProtocol.getJavaProtocolVersion()) {
            return super.getBlockAt(session, x, y, z);
        }
        ServerPlayer player = this.getPlayer(session);
        if (player == null) {
            return 0;
        }
        ServerLevel level = player.level();
        if (y < level.getMinY()) {
            return 0;
        }
        LevelChunk chunk = ((ServerChunkCache)level.getChunkSource()).chunkMap.getChunkToSend(ChunkPos.asLong((int)(x >> 4), (int)(z >> 4)));
        if (chunk == null) {
            return 0;
        }
        int worldOffset = level.getMinY() >> 4;
        int chunkOffset = (y >> 4) - worldOffset;
        if (chunkOffset < chunk.getSections().length && (section = chunk.getSections()[chunkOffset]) != null && !section.hasOnlyAir()) {
            return Block.getId((BlockState)section.getBlockState(x & 0xF, y & 0xF, z & 0xF));
        }
        return 0;
    }

    @Override
    public boolean hasOwnChunkCache() {
        return SharedConstants.getCurrentVersion().protocolVersion() == GameProtocol.getJavaProtocolVersion();
    }

    @Override
    public GameMode getDefaultGameMode(GeyserSession session) {
        return GameMode.byId((int)this.server.getDefaultGameType().getId());
    }

    @Override
    public void getDecoratedPotData(GeyserSession session, Vector3i pos, Consumer<List<String>> apply) {
        this.server.execute(() -> {
            ServerPlayer player = this.getPlayer(session);
            if (player == null) {
                return;
            }
            BlockPos blockPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
            BlockEntity blockEntity = player.level().getChunkAt(blockPos).getBlockEntity(blockPos);
            if (blockEntity instanceof DecoratedPotBlockEntity) {
                DecoratedPotBlockEntity pot = (DecoratedPotBlockEntity)blockEntity;
                List<String> sherds = pot.getDecorations().ordered().stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).toList();
                apply.accept(sherds);
            }
        });
    }

    private ServerPlayer getPlayer(GeyserSession session) {
        return this.server.getPlayerList().getPlayer(session.getPlayerEntity().getUuid());
    }
}

