/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundChangeGameModePacket;

@Translator(packet=SetPlayerGameTypePacket.class)
public class BedrockSetPlayerGameTypeTranslator
extends PacketTranslator<SetPlayerGameTypePacket> {
    @Override
    public void translate(GeyserSession session, SetPlayerGameTypePacket packet) {
        SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
        playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(session.getGameMode()).ordinal());
        session.sendUpstreamPacket((BedrockPacket)playerGameTypePacket);
        if (session.getOpPermissionLevel() >= 2 && packet.getGamemode() != session.getGameMode().ordinal()) {
            GameMode gameMode = switch (packet.getGamemode()) {
                case 1 -> GameMode.CREATIVE;
                case 2 -> GameMode.ADVENTURE;
                case 5 -> session.getGeyser().getWorldManager().getDefaultGameMode(session);
                case 6 -> GameMode.SPECTATOR;
                default -> GameMode.SURVIVAL;
            };
            session.sendDownstreamGamePacket((Packet)new ServerboundChangeGameModePacket(gameMode));
        }
    }
}

