/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.biome.BiomeWeightedData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.index.Indexable;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.index.Unindexed;

public final class BiomeConditionalTransformationData {
    private final List<BiomeWeightedData> weightedBiomes;
    private final transient Indexable<String> conditionJson;
    private final long minPassingNeighbors;

    @JsonCreator
    public BiomeConditionalTransformationData(List<BiomeWeightedData> weightedBiomes, String conditionJson, long minPassingNeighbors) {
        this.weightedBiomes = weightedBiomes;
        this.conditionJson = new Unindexed<String>(conditionJson);
        this.minPassingNeighbors = minPassingNeighbors;
    }

    public String getConditionJson() {
        return this.conditionJson.get();
    }

    public List<BiomeWeightedData> getWeightedBiomes() {
        return this.weightedBiomes;
    }

    public long getMinPassingNeighbors() {
        return this.minPassingNeighbors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeConditionalTransformationData)) {
            return false;
        }
        BiomeConditionalTransformationData other = (BiomeConditionalTransformationData)o;
        if (this.getMinPassingNeighbors() != other.getMinPassingNeighbors()) {
            return false;
        }
        List<BiomeWeightedData> this$weightedBiomes = this.getWeightedBiomes();
        List<BiomeWeightedData> other$weightedBiomes = other.getWeightedBiomes();
        return !(this$weightedBiomes == null ? other$weightedBiomes != null : !((Object)this$weightedBiomes).equals(other$weightedBiomes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minPassingNeighbors = this.getMinPassingNeighbors();
        result = result * 59 + (int)($minPassingNeighbors >>> 32 ^ $minPassingNeighbors);
        List<BiomeWeightedData> $weightedBiomes = this.getWeightedBiomes();
        result = result * 59 + ($weightedBiomes == null ? 43 : ((Object)$weightedBiomes).hashCode());
        return result;
    }

    public String toString() {
        return "BiomeConditionalTransformationData(weightedBiomes=" + this.getWeightedBiomes() + ", conditionJson=" + this.getConditionJson() + ", minPassingNeighbors=" + this.getMinPassingNeighbors() + ")";
    }

    @Deprecated
    public BiomeConditionalTransformationData(List<BiomeWeightedData> weightedBiomes, Indexable<String> conditionJson, long minPassingNeighbors) {
        this.weightedBiomes = weightedBiomes;
        this.conditionJson = conditionJson;
        this.minPassingNeighbors = minPassingNeighbors;
    }
}

